/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    Tree parent;
    boolean resizable = true;
    boolean moveable;
    String toolTipText;
    int id;

    public TreeColumn(Tree tree, int n) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, tree.getColumnCount());
    }

    public TreeColumn(Tree tree, int n, int n2) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TreeColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return 0;
        }
        long l = this.parent.hwndHeader;
        if (l == 0L) {
            return 0;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 1;
        OS.SendMessage(l, OS.HDM_GETITEM, (long)n, hDITEM);
        return hDITEM.cxy;
    }

    public void pack() {
        Object object;
        int n;
        RECT rECT;
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = 0;
        long l = this.parent.handle;
        long l2 = this.parent.hwndHeader;
        RECT rECT2 = new RECT();
        OS.SendMessage(l2, 4615, (long)n2, rECT2);
        long l3 = OS.GetDC(l);
        long l4 = 0L;
        long l5 = OS.SendMessage(l, 49, 0L, 0L);
        if (l5 != 0L) {
            l4 = OS.SelectObject(l3, l5);
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 28;
        tVITEM.hItem = OS.SendMessage(l, 4362, 0L, 0L);
        while (tVITEM.hItem != 0L) {
            OS.SendMessage(l, OS.TVM_GETITEM, 0L, tVITEM);
            RECT rECT3 = rECT = tVITEM.lParam != -1L ? this.parent.items[(int)tVITEM.lParam] : null;
            if (rECT != null) {
                n = 0;
                if (this.parent.hooks(41)) {
                    int n4 = (tVITEM.state & 2) != 0 ? 2 : 0;
                    Event event = this.parent.sendMeasureItemEvent((TreeItem)((Object)rECT), n2, l3, n4);
                    if (this.isDisposed() || this.parent.isDisposed()) break;
                    object = event.getBoundsInPixels();
                    n = ((Rectangle)object).x + ((Rectangle)object).width;
                } else {
                    long l6 = ((TreeItem)((Object)rECT)).fontHandle(n2);
                    if (l6 != -1L) {
                        l6 = OS.SelectObject(l3, l6);
                    }
                    object = ((TreeItem)((Object)rECT)).getBounds(n2, true, true, false, false, false, l3);
                    if (l6 != -1L) {
                        OS.SelectObject(l3, l6);
                    }
                    n = ((RECT)object).right;
                }
                n3 = Math.max(n3, n - rECT2.left);
            }
            tVITEM.hItem = OS.SendMessage(l, 4362, 6L, tVITEM.hItem);
        }
        rECT = new RECT();
        n = 3072;
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, false);
        OS.DrawText(l3, tCHAR, tCHAR.length(), rECT, n);
        int n5 = rECT.right - rECT.left + 12;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n5 += 3;
        }
        if (this.image != null || this.parent.sortColumn == this) {
            object = null;
            if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
                if (OS.COMCTL32_MAJOR < 6) {
                    object = this.display.getSortImage(this.parent.sortDirection);
                } else {
                    n5 += 10;
                }
            } else {
                object = this.image;
            }
            if (object != null) {
                Rectangle rectangle = ((Image)object).getBoundsInPixels();
                n5 += rectangle.width;
            }
            int n6 = 0;
            n6 = l2 != 0L && OS.COMCTL32_VERSION >= OS.VERSION(5, 80) ? (int)OS.SendMessage(l2, 4629, 0L, 0L) : OS.GetSystemMetrics(45) * 3;
            n5 += n6 * 2;
        }
        if (l5 != 0L) {
            OS.SelectObject(l3, l4);
        }
        OS.ReleaseDC(l, l3);
        int n7 = this.parent.linesVisible ? 1 : 0;
        this.setWidthInPixels(Math.max(n5, n3 + n7));
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        long l = this.parent.hwndHeader;
        if (l == 0L) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 4;
        OS.SendMessage(l, OS.HDM_GETITEM, (long)n2, hDITEM);
        hDITEM.fmt &= 0xFFFFFFFC;
        if ((this.style & 0x4000) == 16384) {
            hDITEM.fmt |= 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            hDITEM.fmt |= 2;
        }
        if ((this.style & 0x20000) == 131072) {
            hDITEM.fmt |= 1;
        }
        OS.SendMessage(l, OS.HDM_SETITEM, (long)n2, hDITEM);
        if (n2 != 0) {
            long l2 = this.parent.handle;
            this.parent.forceResize();
            RECT rECT = new RECT();
            RECT rECT2 = new RECT();
            OS.GetClientRect(l2, rECT);
            OS.SendMessage(l, 4615, (long)n2, rECT2);
            rECT.left = rECT2.left;
            rECT.right = rECT2.right;
            OS.InvalidateRect(l2, rECT, true);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.parent.sortColumn != this || this.parent.sortDirection != 0) {
            this.setImage(image, false, false);
        }
    }

    void setImage(Image image, boolean bl, boolean bl2) {
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        long l = this.parent.hwndHeader;
        if (l == 0L) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 52;
        OS.SendMessage(l, OS.HDM_GETITEM, (long)n, hDITEM);
        hDITEM.fmt &= 0xFFFFEFFF;
        if (image != null) {
            if (bl) {
                hDITEM.mask &= 0xFFFFFFDF;
                hDITEM.fmt &= 0xFFFFF7FF;
                hDITEM.fmt |= 0x2000;
                hDITEM.hbm = image.handle;
            } else {
                hDITEM.mask &= 0xFFFFFFEF;
                hDITEM.fmt &= 0xFFFFDFFF;
                hDITEM.fmt |= 0x800;
                hDITEM.iImage = this.parent.imageIndexHeader(image);
            }
            if (bl2) {
                hDITEM.fmt |= 0x1000;
            }
        } else {
            hDITEM.mask &= 0xFFFFFFCF;
            hDITEM.fmt &= 0xFFFFD7FF;
        }
        OS.SendMessage(l, OS.HDM_SETITEM, (long)n, hDITEM);
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.moveable = bl;
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.resizable = bl;
    }

    void setSortDirection(int n) {
        if (OS.COMCTL32_MAJOR >= 6) {
            long l = this.parent.hwndHeader;
            if (l != 0L) {
                int n2 = this.parent.indexOf(this);
                if (n2 == -1) {
                    return;
                }
                HDITEM hDITEM = new HDITEM();
                hDITEM.mask = 36;
                OS.SendMessage(l, OS.HDM_GETITEM, (long)n2, hDITEM);
                switch (n) {
                    case 128: {
                        hDITEM.fmt &= 0xFFFFF5FF;
                        hDITEM.fmt |= 0x400;
                        if (this.image != null) break;
                        hDITEM.mask &= 0xFFFFFFDF;
                        break;
                    }
                    case 1024: {
                        hDITEM.fmt &= 0xFFFFF3FF;
                        hDITEM.fmt |= 0x200;
                        if (this.image != null) break;
                        hDITEM.mask &= 0xFFFFFFDF;
                        break;
                    }
                    case 0: {
                        hDITEM.fmt &= 0xFFFFF9FF;
                        if (this.image != null) {
                            hDITEM.fmt |= 0x800;
                            hDITEM.iImage = this.parent.imageIndexHeader(this.image);
                            break;
                        }
                        hDITEM.fmt &= 0xFFFFF7FF;
                        hDITEM.mask &= 0xFFFFFFDF;
                    }
                }
                OS.SendMessage(l, OS.HDM_SETITEM, (long)n2, hDITEM);
                if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                    long l2 = this.parent.handle;
                    this.parent.forceResize();
                    RECT rECT = new RECT();
                    RECT rECT2 = new RECT();
                    OS.GetClientRect(l2, rECT);
                    OS.SendMessage(l, 4615, (long)n2, rECT2);
                    rECT.left = rECT2.left;
                    rECT.right = rECT2.right;
                    OS.InvalidateRect(l2, rECT, true);
                }
            }
        } else {
            switch (n) {
                case 128: 
                case 1024: {
                    this.setImage(this.display.getSortImage(n), true, true);
                    break;
                }
                case 0: {
                    this.setImage(this.image, false, false);
                }
            }
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setText(string);
        boolean bl = !OS.IsWinCE && OS.WIN32_VERSION <= OS.VERSION(4, 10);
        long l = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string, bl), true);
        int n2 = tCHAR.length() * TCHAR.sizeof;
        long l2 = OS.HeapAlloc(l, 8, n2);
        OS.MoveMemory(l2, tCHAR, n2);
        long l3 = this.parent.hwndHeader;
        if (l3 == 0L) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 2;
        hDITEM.pszText = l2;
        long l4 = OS.SendMessage(l3, OS.HDM_SETITEM, (long)n, hDITEM);
        if (l2 != 0L) {
            OS.HeapFree(l, 0, l2);
        }
        if (l4 == 0L) {
            this.error(13);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        long l = this.parent.headerToolTipHandle;
        if (l == 0L) {
            this.parent.createHeaderToolTips();
            this.parent.updateHeaderToolTips();
        }
    }

    public void setWidth(int n) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(n));
    }

    void setWidthInPixels(int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        long l = this.parent.hwndHeader;
        if (l == 0L) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 1;
        hDITEM.cxy = n;
        OS.SendMessage(l, OS.HDM_SETITEM, (long)n2, hDITEM);
        RECT rECT = new RECT();
        OS.SendMessage(l, 4615, (long)n2, rECT);
        this.parent.forceResize();
        long l2 = this.parent.handle;
        RECT rECT2 = new RECT();
        OS.GetClientRect(l2, rECT2);
        rECT2.left = rECT.left;
        OS.InvalidateRect(l2, rECT2, true);
        this.parent.setScrollWidth();
    }

    void updateToolTip(int n) {
        RECT rECT;
        long l;
        long l2 = this.parent.headerToolTipHandle;
        if (l2 != 0L && OS.SendMessage(l = this.parent.hwndHeader, 4615, (long)n, rECT = new RECT()) != 0L) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.hwnd = l;
            tOOLINFO.uId = this.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            OS.SendMessage(l2, OS.TTM_NEWTOOLRECT, 0L, tOOLINFO);
        }
    }
}

