/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.awt;

import com.openinventor.awt.event.SliderEvent;
import com.openinventor.awt.event.SliderListener;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

@Deprecated
public abstract class Slider
extends Canvas {
    Vector listeners;
    private float value;
    private float min;
    private float max;
    private boolean horizontal;
    private boolean doRedraw = false;

    public Slider(float f, float f2, float f3, boolean bl) {
        this.value = f;
        this.horizontal = bl;
        this.min = f2;
        this.max = f3;
        if (this.min > this.max) {
            this.min = this.max - this.min;
            this.max -= this.min;
            this.min += this.max;
        }
        if (this.min == this.max) {
            this.max += 1.0E-6f;
        }
        if (this.value > this.max) {
            this.value = this.max;
        } else if (this.value < this.min) {
            this.value = this.min;
        }
        this.listeners = new Vector();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.isHorizontal() ? new Dimension(110, 25) : new Dimension(25, 110);
    }

    public synchronized boolean setValue(float f) {
        return this.setValue(f, true);
    }

    public synchronized boolean setValue(float f, boolean bl) {
        boolean bl2 = this.setPosition(f);
        if (bl2 && bl) {
            this.valueChangeAdjustment(this.value);
        }
        return bl2;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setMaximum(float f) {
        if (f > this.min) {
            this.max = f;
        }
    }

    public void setMinimum(float f) {
        if (f < this.max) {
            this.min = f;
        }
    }

    public float getMaximum() {
        return this.max;
    }

    public float getMinimum() {
        return this.min;
    }

    protected boolean setPosition(float f) {
        if (f <= this.max && f >= this.min) {
            this.value = f;
            if (this.doRedraw) {
                this.redraw();
            }
            return true;
        }
        if (f < this.min) {
            this.value = this.min;
        } else if (f > this.max) {
            this.value = this.max;
        }
        if (this.doRedraw) {
            this.redraw();
        }
        return false;
    }

    protected void redraw() {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.doRedraw = true;
    }

    protected float getPosition() {
        return (this.value - this.min) / (this.max - this.min);
    }

    private void startAdjustment(float f) {
        this.dispatchEvent(new SliderEvent(this, 2000, f));
    }

    private void endAdjustment(float f) {
        this.dispatchEvent(new SliderEvent(this, 2001, f));
    }

    private void valueChangeAdjustment(float f) {
        this.dispatchEvent(new SliderEvent(this, 2002, f));
    }

    public void addSliderListener(SliderListener sliderListener) {
        if (sliderListener != null && !this.listeners.contains(sliderListener)) {
            this.listeners.addElement(sliderListener);
        }
    }

    public void removeSliderListener(SliderListener sliderListener) {
        if (sliderListener != null && this.listeners.contains(sliderListener)) {
            this.listeners.removeElement(sliderListener);
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof SliderEvent) {
            this.processSliderEvent((SliderEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processSliderEvent(SliderEvent sliderEvent) {
        if (this.isEnabled()) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                SliderListener sliderListener = (SliderListener)enumeration.nextElement();
                switch (sliderEvent.getID()) {
                    case 2000: {
                        sliderListener.adjustmentStarted(sliderEvent);
                        break;
                    }
                    case 2001: {
                        sliderListener.adjustmentEnded(sliderEvent);
                        break;
                    }
                    case 2002: {
                        sliderListener.adjustmentValueChanged(sliderEvent);
                    }
                }
            }
        }
    }

    protected void beginSlide() {
        this.startAdjustment(this.value);
    }

    protected void endSlide() {
        this.endAdjustment(this.value);
    }

    protected void slide() {
        this.setValue(this.value);
    }
}

