/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.awt;

import com.openinventor.awt.Slider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

@Deprecated
public class TriangleSlider
extends Slider {
    private static final int margin = 5;
    private static final int bottomMargin = 1;
    private static final int triangleHeight = 10;
    private static final int triangleWidth = 12;
    private boolean doubleBuffering = false;
    private Image doubleBuffer;
    private Graphics dblBuffer;

    public TriangleSlider() {
        this(true);
    }

    public TriangleSlider(float f) {
        this(f, 0.0f, 100.0f);
    }

    public TriangleSlider(float f, float f2, float f3) {
        this(f, f2, f3, true);
    }

    public TriangleSlider(boolean bl) {
        this(0.0f, 0.0f, 100.0f, bl);
    }

    public TriangleSlider(float f, float f2, float f3, boolean bl) {
        super(f, f2, f3, bl);
        ListenSlider listenSlider = new ListenSlider();
        this.addMouseListener(listenSlider);
        this.addMouseMotionListener(listenSlider);
    }

    void setMousePosition(int n, int n2) {
        if (this.isHorizontal()) {
            this.setPosition((this.getMaximum() - this.getMinimum()) * (float)(n - 5) / (float)(this.getSize().width - 10) + this.getMinimum());
        } else {
            this.setPosition((this.getMaximum() - this.getMinimum()) * (float)(n2 - 5) / (float)(this.getSize().height - 10) + this.getMinimum());
        }
    }

    public void drawInnerRegion(Graphics graphics, Dimension dimension) {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        graphics.draw3DRect(5, 5, dimension.width - 10, dimension.height - 10, false);
        this.doubleBuffering = false;
        this.drawSlider(graphics);
    }

    @Override
    public final void redraw() {
        this.drawSlider(this.getGraphics());
    }

    private void setDoubleBuffering() {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        this.doubleBuffer = this.createImage(dimension.width, dimension.height);
        this.dblBuffer = this.doubleBuffer.getGraphics();
        this.dblBuffer.setColor(this.getBackground());
        this.dblBuffer.fillRect(0, 0, dimension.width, dimension.height);
        this.dblBuffer.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        this.dblBuffer.draw3DRect(5, 5, dimension.width - 10, dimension.height - 10, false);
        this.doubleBuffering = true;
    }

    private void drawSlider(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (!this.doubleBuffering) {
            if (dimension.width > 0 && dimension.height > 0) {
                this.drawInnerRegion(graphics.create(6, 6, dimension.width - 10 - 2, dimension.height - 10 - 1), new Dimension(dimension.width - 10 - 2, dimension.height - 10 - 1));
            }
            this.setDoubleBuffering();
        } else {
            if (this.doubleBuffer == null || this.dblBuffer == null) {
                this.setDoubleBuffering();
            }
            this.drawInnerRegion(this.dblBuffer.create(6, 6, dimension.width - 10 - 2, dimension.height - 10 - 1), new Dimension(dimension.width - 10 - 2, dimension.height - 10 - 1));
            graphics.drawImage(this.doubleBuffer, 0, 0, dimension.width, dimension.height, null);
        }
        if (this.isHorizontal()) {
            int n = 5 + Math.round(this.getPosition() * (float)(dimension.width - 10 - 2));
            nArray[0] = n - 5;
            nArray[1] = n + 5;
            nArray[2] = n;
            nArray2[0] = dimension.height - 1;
            nArray2[1] = dimension.height - 1;
            nArray2[2] = dimension.height - 11;
        } else {
            int n = 5 + Math.round(this.getPosition() * (float)(dimension.height - 10 - 2));
            nArray2[0] = n - 5;
            nArray2[1] = n + 5;
            nArray2[2] = n;
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 10;
        }
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, 3);
        graphics.setColor(Color.lightGray);
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(Color.white);
        graphics.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
    }

    class ListenSlider
    extends MouseAdapter
    implements MouseMotionListener {
        ListenSlider() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TriangleSlider triangleSlider = (TriangleSlider)mouseEvent.getSource();
            if (triangleSlider.isEnabled()) {
                triangleSlider.setMousePosition(mouseEvent.getX(), mouseEvent.getY());
                triangleSlider.redraw();
                triangleSlider.beginSlide();
                triangleSlider.slide();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TriangleSlider triangleSlider = (TriangleSlider)mouseEvent.getSource();
            if (triangleSlider.isEnabled()) {
                triangleSlider.setMousePosition(mouseEvent.getX(), mouseEvent.getY());
                triangleSlider.redraw();
                triangleSlider.endSlide();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TriangleSlider triangleSlider = (TriangleSlider)mouseEvent.getSource();
            if (triangleSlider.isEnabled()) {
                triangleSlider.setMousePosition(mouseEvent.getX(), mouseEvent.getY());
                triangleSlider.redraw();
                triangleSlider.slide();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

