/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.directviz;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoNode;

public class SoDirectVizManager
extends SoNode {
    private static boolean s_checklic = true;
    @Deprecated
    public static final int READ_WRITE_MODE = CacheModes.access$000();
    @Deprecated
    public static final int READ_MODE = CacheModes.access$100();
    @Deprecated
    public static final int WRITE_MODE = CacheModes.access$200();
    @Deprecated
    public static final int ENV_LIGHTS_0 = EnvLights.access$300();
    @Deprecated
    public static final int ENV_LIGHTS_2 = EnvLights.access$400();
    @Deprecated
    public static final int ENV_LIGHTS_4 = EnvLights.access$500();
    @Deprecated
    public static final int ENV_LIGHTS_8 = EnvLights.access$600();
    @Deprecated
    public static final int ENV_LIGHTS_16 = EnvLights.access$700();
    @Deprecated
    public static final int ENV_LIGHTS_32 = EnvLights.access$800();
    @Deprecated
    public static final int ENV_LIGHTS_64 = EnvLights.access$900();
    @Deprecated
    public static final int ENV_LIGHTS_128 = EnvLights.access$1000();
    @Deprecated
    public static final int ENV_LIGHTS_256 = EnvLights.access$1100();
    public final SoSFBool accumulation;
    public final SoSFInt32 maxAccumulationValue;
    public final SoSFBool subSampling;
    public final SoSFFloat subSamplingFactor;
    public final SoSFInt32 recursionLimit;
    public final SoSFBool subRecursion;
    public final SoSFBool progressiveRendering;
    public final SoSFInt32 numProgressiveRenderingSteps;
    public final SoSFBool rendering;
    public final SoSFBool globalShadowing;
    public final SoSFBool adaptiveOversampling;
    public final SoSFBool softShadows;
    public final SoSFBool fuzzyLights;
    public final SoSFBool glossySurfaces;
    public final SoSFEnum<EnvLights> numEnvLights;
    public final SoSFFloat envLightIntensityScale;
    public final SoSFBool fileCaching;
    public final SoSFBool controlDialog;

    private static native int getCurrentAccumValueImpl(long var0);

    private static native void setCacheFileImpl(long var0, String var2, int var3);

    private static native void getRenderedImageSizeImpl(long var0, short[] var2);

    private static native void setCacheDirectoryImpl(long var0, String var2);

    private static native long getInstanceImpl(long var0);

    private static native double getLastRenderTimeImpl(long var0);

    private static native void setCameraImpl(long var0, long var2);

    private static native int getNumEnvironmentLightsImpl(long var0);

    protected SoDirectVizManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        if (s_checklic) {
            if (System.getProperty("os.name").startsWith("Mac")) {
                throw new UnsupportedOperationException("Unsupported platform.");
            }
            Inventor.checkDVizLP();
            s_checklic = false;
        }
        this.initializeFields();
        this.accumulation = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "accumulation"));
        this.maxAccumulationValue = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "maxAccumulationValue"));
        this.subSampling = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "subSampling"));
        this.subSamplingFactor = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "subSamplingFactor"));
        this.recursionLimit = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "recursionLimit"));
        this.subRecursion = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "subRecursion"));
        this.progressiveRendering = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "progressiveRendering"));
        this.numProgressiveRenderingSteps = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "numProgressiveRenderingSteps"));
        this.rendering = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "rendering"));
        this.globalShadowing = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "globalShadowing"));
        this.adaptiveOversampling = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "adaptiveOversampling"));
        this.softShadows = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "softShadows"));
        this.fuzzyLights = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "fuzzyLights"));
        this.glossySurfaces = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "glossySurfaces"));
        this.numEnvLights = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "numEnvLights"), EnvLights.class);
        this.envLightIntensityScale = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "envLightIntensityScale"));
        this.fileCaching = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "fileCaching"));
        this.controlDialog = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDirectVizManager.getFieldHandle(this.getNativeResourceHandle(), "controlDialog"));
    }

    static native String getClassTypeId();

    public void setCacheFile(String string) {
        this.setCacheFile(string, CacheModes.valueOf(CacheModes.READ_WRITE_MODE.getValue()));
    }

    public void setCacheFile(String string, CacheModes cacheModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDirectVizManager.setCacheFileImpl(this.getNativeResourceHandle(), string, cacheModes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumEnvironmentLights() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDirectVizManager.getNumEnvironmentLightsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setCamera(SoCamera soCamera) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDirectVizManager.setCameraImpl(this.getNativeResourceHandle(), soCamera != null ? soCamera.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setCacheDirectory(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDirectVizManager.setCacheDirectoryImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2s getRenderedImageSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDirectVizManager.getRenderedImageSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public int getCurrentAccumValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDirectVizManager.getCurrentAccumValueImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoDirectVizManager getInstance(SoSceneManager soSceneManager) {
        ObjectManager.globalLock.lock();
        try {
            SoDirectVizManager soDirectVizManager = ObjectManager.getManagedObjectFor(SoDirectVizManager.class, SoDirectVizManager.getInstanceImpl(soSceneManager != null ? soSceneManager.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soDirectVizManager;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public double getLastRenderTime() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            double d = SoDirectVizManager.getLastRenderTimeImpl(this.getNativeResourceHandle());
            return d;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum EnvLights implements IntegerValuedEnum
    {
        ENV_LIGHTS_0(EnvLights.getENVLIGHTS0()),
        ENV_LIGHTS_2(EnvLights.getENVLIGHTS2()),
        ENV_LIGHTS_4(EnvLights.getENVLIGHTS4()),
        ENV_LIGHTS_8(EnvLights.getENVLIGHTS8()),
        ENV_LIGHTS_16(EnvLights.getENVLIGHTS16()),
        ENV_LIGHTS_32(EnvLights.getENVLIGHTS32()),
        ENV_LIGHTS_64(EnvLights.getENVLIGHTS64()),
        ENV_LIGHTS_128(EnvLights.getENVLIGHTS128()),
        ENV_LIGHTS_256(EnvLights.getENVLIGHTS256());

        private int value;

        private static native int getENVLIGHTS64();

        private static native int getENVLIGHTS32();

        private static native int getENVLIGHTS128();

        private EnvLights(int n2) {
            this.value = n2;
        }

        private static native int getENVLIGHTS256();

        private static native int getENVLIGHTS2();

        private static native int getENVLIGHTS0();

        private static native int getENVLIGHTS4();

        private static native int getENVLIGHTS16();

        private static native int getENVLIGHTS8();

        @Deprecated
        public static EnvLights fromValue(int n) {
            return EnvLights.valueOf(n);
        }

        public static EnvLights valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(EnvLights.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$300() {
            return EnvLights.getENVLIGHTS0();
        }

        static /* synthetic */ int access$400() {
            return EnvLights.getENVLIGHTS2();
        }

        static /* synthetic */ int access$500() {
            return EnvLights.getENVLIGHTS4();
        }

        static /* synthetic */ int access$600() {
            return EnvLights.getENVLIGHTS8();
        }

        static /* synthetic */ int access$700() {
            return EnvLights.getENVLIGHTS16();
        }

        static /* synthetic */ int access$800() {
            return EnvLights.getENVLIGHTS32();
        }

        static /* synthetic */ int access$900() {
            return EnvLights.getENVLIGHTS64();
        }

        static /* synthetic */ int access$1000() {
            return EnvLights.getENVLIGHTS128();
        }

        static /* synthetic */ int access$1100() {
            return EnvLights.getENVLIGHTS256();
        }
    }

    public static enum CacheModes implements IntegerValuedEnum
    {
        READ_WRITE_MODE(CacheModes.getREADWRITEMODE()),
        READ_MODE(CacheModes.getREADMODE()),
        WRITE_MODE(CacheModes.getWRITEMODE());

        private int value;

        private static native int getWRITEMODE();

        private CacheModes(int n2) {
            this.value = n2;
        }

        private static native int getREADWRITEMODE();

        private static native int getREADMODE();

        @Deprecated
        public static CacheModes fromValue(int n) {
            return CacheModes.valueOf(n);
        }

        public static CacheModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CacheModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return CacheModes.getREADWRITEMODE();
        }

        static /* synthetic */ int access$100() {
            return CacheModes.getREADMODE();
        }

        static /* synthetic */ int access$200() {
            return CacheModes.getWRITEMODE();
        }
    }
}

