/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.fxviz.aps;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoTexture2;
import com.openinventor.inventor.nodes.SoTextureCoordinate2;

public class SoAppearancePreserver
extends Inventor {
    private static native long getDisplacementMapTextureImpl(long var0, String var2);

    private static native void setSceneGraphsImpl(long var0, long var2, long var4);

    private static native void setTextureSizeImpl(long var0, int var2, int var3);

    private static native void setTriangleMinSizeImpl(long var0, int var2);

    private static native long getNormalMapTextureImpl(long var0, String var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoAppearancePreserver.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native long getBumpCoordsImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoAppearancePreserver(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoTexture2 getNormalMapTexture() {
        return this.getNormalMapTexture("");
    }

    public SoTexture2 getDisplacementMapTexture() {
        return this.getDisplacementMapTexture("");
    }

    public SoTexture2 getNormalMapTexture(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTexture2 soTexture2 = ObjectManager.getManagedObjectFor(SoTexture2.class, SoAppearancePreserver.getNormalMapTextureImpl(this.getNativeResourceHandle(), string));
            return soTexture2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoAppearancePreserver() {
        this(Inventor.ConstructorCommand.CreateInstance, SoAppearancePreserver.ctorImplSync());
    }

    public SoTexture2 getDisplacementMapTexture(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTexture2 soTexture2 = ObjectManager.getManagedObjectFor(SoTexture2.class, SoAppearancePreserver.getDisplacementMapTextureImpl(this.getNativeResourceHandle(), string));
            return soTexture2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTriangleMinSize(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAppearancePreserver.setTriangleMinSizeImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTextureSize(int n, int n2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAppearancePreserver.setTextureSizeImpl(this.getNativeResourceHandle(), n, n2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSceneGraphs(SoNode soNode, SoNode soNode2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAppearancePreserver.setSceneGraphsImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoTextureCoordinate2 getBumpCoords() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTextureCoordinate2 soTextureCoordinate2 = ObjectManager.getManagedObjectFor(SoTextureCoordinate2.class, SoAppearancePreserver.getBumpCoordsImpl(this.getNativeResourceHandle()));
            return soTextureCoordinate2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

