/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.hardcopy;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoCallbackAction;

public class SoToU3DAction
extends SoCallbackAction {
    private static boolean s_checklic = true;

    private static native void forcePolygonalText3Impl(long var0, boolean var2);

    private static native void enableElementImpl(String var0, int var1);

    private static native boolean areDraggersExportedImpl(long var0);

    private static native void setExportDraggersImpl(long var0, boolean var2);

    private static native boolean isPolygonalText3ForcedImpl(long var0);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoToU3DAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean closeFileImpl(long var0);

    private static native boolean openFileImpl(long var0, String var2);

    protected SoToU3DAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        if (s_checklic) {
            Inventor.checkHcpyLP();
            s_checklic = false;
        }
        this.initializeFields();
    }

    static native String getClassTypeId();

    public boolean openFile(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoToU3DAction.openFileImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoToU3DAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoToU3DAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoToU3DAction.ctorImplSync());
    }

    public boolean isPolygonalText3Forced() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoToU3DAction.isPolygonalText3ForcedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setExportDraggers(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToU3DAction.setExportDraggersImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean areDraggersExported() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoToU3DAction.areDraggersExportedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean closeFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoToU3DAction.closeFileImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void forcePolygonalText3(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToU3DAction.forcePolygonalText3Impl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

