/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.hardcopy;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoVectorOutput
extends Inventor {
    private static native boolean openFileImpl(long var0, String var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVectorOutput.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void closeFileImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoVectorOutput(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean openFile(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVectorOutput.openFileImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVectorOutput() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVectorOutput.ctorImplSync());
    }

    public void closeFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVectorOutput.closeFileImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

