/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.hardcopy;

import com.openinventor.hardcopy.SoGDIVectorOutput;
import com.openinventor.hardcopy.SoVectorizeAction;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoVectorizeGDIAction
extends SoVectorizeAction {
    private static native long getGDIVectorOutputImpl(long var0);

    private static native void enableElementImpl(String var0, int var1);

    private static native boolean hasPrinterImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVectorizeGDIAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    protected SoVectorizeGDIAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new UnsupportedOperationException("Unsupported platform.");
        }
        this.initializeFields();
    }

    static native String getClassTypeId();

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoVectorizeGDIAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoVectorizeGDIAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVectorizeGDIAction.ctorImplSync());
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new UnsupportedOperationException("Unsupported platform.");
        }
    }

    public SoGDIVectorOutput getGDIVectorOutput() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGDIVectorOutput soGDIVectorOutput = ObjectManager.getManagedObjectFor(SoGDIVectorOutput.class, SoVectorizeGDIAction.getGDIVectorOutputImpl(this.getNativeResourceHandle()));
            return soGDIVectorOutput;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean hasPrinter() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVectorizeGDIAction.hasPrinterImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

