/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.imageviz;

import com.openinventor.imageviz.SbChannelList;
import com.openinventor.imageviz.nodes.images.SoImageDataAdapter;
import com.openinventor.imageviz.nodes.images.SoMemoryDataAdapter;
import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbBox4i32;
import com.openinventor.inventor.SbVec4i32;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import java.util.Collection;

public class SbImageDataAccessor
extends Inventor {
    private SoCpuBufferObject m_values_setRow;
    private SoCpuBufferObject m_values_setColumn;

    private static native long getImageAdapterImpl(long var0);

    private static native long copyRegionImpl1(long var0, long var2);

    private static native boolean setColumnImpl(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native boolean getRowImpl(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native boolean setRowImpl(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native boolean setColumnImpl1(long var0, double[] var2, int var3, int var4, int var5, int var6);

    private static native boolean getColumnImpl(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native long copyRegionImpl(long var0, long var2, long var4);

    private static native boolean setRowImpl1(long var0, double[] var2, int var3, int var4, int var5, int var6);

    private static native long createSliceRegionImpl(long var0, int var2);

    private static native long createFullRegionImpl(long var0);

    private static native boolean setVoxelImpl(long var0, double var2, int var4, int var5, int var6, int var7, int var8);

    private static native double getVoxelImpl1(long var0, int var2, int var3, int var4, int var5, int var6);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SbImageDataAccessor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean setRow(SoCpuBufferObject soCpuBufferObject, int n, int n2) {
        return this.setRow(soCpuBufferObject, n, n2, 0, 0);
    }

    public boolean setRow(SoCpuBufferObject soCpuBufferObject, int n) {
        return this.setRow(soCpuBufferObject, n, 0, 0, 0);
    }

    public boolean setRow(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3) {
        return this.setRow(soCpuBufferObject, n, n2, n3, 0);
    }

    public boolean setRow(Collection<Double> collection, int n, int n2) {
        return this.setRow(collection, n, n2, 0, 0);
    }

    public boolean setRow(Collection<Double> collection, int n) {
        return this.setRow(collection, n, 0, 0, 0);
    }

    public boolean setVoxel(double d, int n, int n2, int n3, int n4) {
        return this.setVoxel(d, n, n2, n3, n4, 0);
    }

    public boolean setVoxel(double d, int n, int n2, int n3) {
        return this.setVoxel(d, n, n2, n3, 0, 0);
    }

    public boolean getRow(SoCpuBufferObject soCpuBufferObject, int n) {
        return this.getRow(soCpuBufferObject, n, 0, 0, 0);
    }

    public boolean getRow(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3) {
        return this.getRow(soCpuBufferObject, n, n2, n3, 0);
    }

    public boolean getRow(SoCpuBufferObject soCpuBufferObject, int n, int n2) {
        return this.getRow(soCpuBufferObject, n, n2, 0, 0);
    }

    public boolean setColumn(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3) {
        return this.setColumn(soCpuBufferObject, n, n2, n3, 0);
    }

    public boolean setColumn(SoCpuBufferObject soCpuBufferObject, int n, int n2) {
        return this.setColumn(soCpuBufferObject, n, n2, 0, 0);
    }

    public boolean setColumn(Collection<Double> collection, int n) {
        return this.setColumn(collection, n, 0, 0, 0);
    }

    public boolean setColumn(Collection<Double> collection, int n, int n2, int n3) {
        return this.setColumn(collection, n, n2, n3, 0);
    }

    public boolean setColumn(Collection<Double> collection, int n, int n2) {
        return this.setColumn(collection, n, n2, 0, 0);
    }

    public boolean getColumn(SoCpuBufferObject soCpuBufferObject, int n) {
        return this.getColumn(soCpuBufferObject, n, 0, 0, 0);
    }

    public boolean setRow(Collection<Double> collection, int n, int n2, int n3) {
        return this.setRow(collection, n, n2, n3, 0);
    }

    public boolean getColumn(SoCpuBufferObject soCpuBufferObject, int n, int n2) {
        return this.getColumn(soCpuBufferObject, n, n2, 0, 0);
    }

    public boolean setColumn(SoCpuBufferObject soCpuBufferObject, int n) {
        return this.setColumn(soCpuBufferObject, n, 0, 0, 0);
    }

    public boolean getColumn(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3) {
        return this.getColumn(soCpuBufferObject, n, n2, n3, 0);
    }

    public double getVoxel(int n, int n2) {
        return this.getVoxel(n, n2, 0, 0, 0);
    }

    public boolean setVoxel(double d, int n, int n2) {
        return this.setVoxel(d, n, n2, 0, 0, 0);
    }

    public double getVoxel(int n, int n2, int n3, int n4) {
        return this.getVoxel(n, n2, n3, n4, 0);
    }

    public double getVoxel(int n, int n2, int n3) {
        return this.getVoxel(n, n2, n3, 0, 0);
    }

    public SoMemoryDataAdapter copyRegion(Region region) {
        if (!Inventor.class.isAssignableFrom(region.getClass())) {
            throw new UnsupportedOperationException();
        }
        return ObjectManager.getManagedObjectFor(SoMemoryDataAdapter.class, SbImageDataAccessor.copyRegionImpl1(this.getNativeResourceHandle(), region != null ? ((Inventor)((Object)region)).getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public boolean setRow(Collection<Double> collection, int n, int n2, int n3, int n4) {
        if (collection == null) {
            throw new IllegalArgumentException("values cannot be null");
        }
        double[] dArray = new double[collection.size()];
        int n5 = 0;
        for (double d : collection) {
            dArray[n5++] = d;
        }
        return SbImageDataAccessor.setRowImpl1(this.getNativeResourceHandle(), dArray, n, n2, n3, n4);
    }

    public SoMemoryDataAdapter copyRegion(Region region, SbChannelList sbChannelList) {
        if (!Inventor.class.isAssignableFrom(region.getClass())) {
            throw new UnsupportedOperationException();
        }
        return ObjectManager.getManagedObjectFor(SoMemoryDataAdapter.class, SbImageDataAccessor.copyRegionImpl(this.getNativeResourceHandle(), region != null ? ((Inventor)((Object)region)).getNativeResourceHandle() : Inventor.ZeroHandle, sbChannelList != null ? sbChannelList.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public boolean setColumn(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3, int n4) {
        this.m_values_setColumn = soCpuBufferObject;
        return SbImageDataAccessor.setColumnImpl(this.getNativeResourceHandle(), soCpuBufferObject != null ? soCpuBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, n, n2, n3, n4);
    }

    public boolean setColumn(Collection<Double> collection, int n, int n2, int n3, int n4) {
        if (collection == null) {
            throw new IllegalArgumentException("values cannot be null");
        }
        double[] dArray = new double[collection.size()];
        int n5 = 0;
        for (double d : collection) {
            dArray[n5++] = d;
        }
        return SbImageDataAccessor.setColumnImpl1(this.getNativeResourceHandle(), dArray, n, n2, n3, n4);
    }

    public boolean getColumn(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3, int n4) {
        return SbImageDataAccessor.getColumnImpl(this.getNativeResourceHandle(), soCpuBufferObject != null ? soCpuBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, n, n2, n3, n4);
    }

    public boolean setRow(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3, int n4) {
        this.m_values_setRow = soCpuBufferObject;
        return SbImageDataAccessor.setRowImpl(this.getNativeResourceHandle(), soCpuBufferObject != null ? soCpuBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, n, n2, n3, n4);
    }

    public static SubVolumeRegion createSliceRegion(SoImageDataAdapter soImageDataAdapter, int n) {
        return ObjectManager.createManagedObject(SubVolumeRegion.class, (Long)SbImageDataAccessor.createSliceRegionImpl(soImageDataAdapter != null ? soImageDataAdapter.getNativeResourceHandle() : Inventor.ZeroHandle, n), Inventor.ConstructorCommand.CreateInstance);
    }

    public static SubVolumeRegion createFullRegion(SoImageDataAdapter soImageDataAdapter) {
        return ObjectManager.createManagedObject(SubVolumeRegion.class, (Long)SbImageDataAccessor.createFullRegionImpl(soImageDataAdapter != null ? soImageDataAdapter.getNativeResourceHandle() : Inventor.ZeroHandle), Inventor.ConstructorCommand.CreateInstance);
    }

    public double getVoxel(int n, int n2, int n3, int n4, int n5) {
        return SbImageDataAccessor.getVoxelImpl1(this.getNativeResourceHandle(), n, n2, n3, n4, n5);
    }

    public SoImageDataAdapter getImageAdapter() {
        return ObjectManager.getManagedObjectFor(SoImageDataAdapter.class, SbImageDataAccessor.getImageAdapterImpl(this.getNativeResourceHandle()));
    }

    public boolean getRow(SoCpuBufferObject soCpuBufferObject, int n, int n2, int n3, int n4) {
        return SbImageDataAccessor.getRowImpl(this.getNativeResourceHandle(), soCpuBufferObject != null ? soCpuBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, n, n2, n3, n4);
    }

    public boolean setVoxel(double d, int n, int n2, int n3, int n4, int n5) {
        return SbImageDataAccessor.setVoxelImpl(this.getNativeResourceHandle(), d, n, n2, n3, n4, n5);
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static interface Region {
        public SbVec4i32 getPosition(long var1);

        public SbBox4i32 getExtent();

        public SbVec4i32 getSize();

        public long getNumVoxel();
    }

    public static class SubVolumeRegion
    extends Inventor
    implements Region {
        private static native void getPositionImpl(long var0, long var2, int[] var4);

        private static native void getExtentImpl(long var0, int[] var2);

        private static native long getNumVoxelImpl(long var0);

        private static long ctorImplSync(SbBox3i32 sbBox3i32) {
            ObjectManager.globalLock.lock();
            try {
                long l = SubVolumeRegion.ctorImpl(sbBox3i32 != null ? sbBox3i32.array : null);
                return l;
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }

        private static native void getSizeImpl(long var0, int[] var2);

        private static native long ctorImpl(int[] var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected SubVolumeRegion(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public SubVolumeRegion(SbBox3i32 sbBox3i32) {
            this(Inventor.ConstructorCommand.CreateInstance, SubVolumeRegion.ctorImplSync(sbBox3i32));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SbVec4i32 getPosition(long l) {
            SbVec4i32 sbVec4i32 = new SbVec4i32();
            this.acquireLock(ObjectManager.globalLock);
            try {
                SubVolumeRegion.getPositionImpl(this.getNativeResourceHandle(), l, sbVec4i32.array);
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
            return sbVec4i32;
        }

        @Override
        public long getNumVoxel() {
            this.acquireLock(ObjectManager.globalLock);
            try {
                long l = SubVolumeRegion.getNumVoxelImpl(this.getNativeResourceHandle());
                return l;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }

        @Override
        public SbBox4i32 getExtent() {
            SbBox4i32 sbBox4i32 = new SbBox4i32();
            this.acquireLock(ObjectManager.globalLock);
            try {
                SubVolumeRegion.getExtentImpl(this.getNativeResourceHandle(), sbBox4i32.array);
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
            return sbBox4i32;
        }

        @Override
        public SbVec4i32 getSize() {
            SbVec4i32 sbVec4i32 = new SbVec4i32();
            this.acquireLock(ObjectManager.globalLock);
            try {
                SubVolumeRegion.getSizeImpl(this.getNativeResourceHandle(), sbVec4i32.array);
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
            return sbVec4i32;
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }
}

