/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.imageviz.engines;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.engines.SoEngine;

public class SoImageVizEngine
extends SoEngine {
    @Deprecated
    public static final int MODE_2D = ComputeModes.access$600();
    @Deprecated
    public static final int MODE_3D = ComputeModes.access$700();
    @Deprecated
    public static final int MODE_AUTO = ComputeModes.access$800();
    @Deprecated
    public static final int CONNECTIVITY_6 = Neighborhood3ds.access$900();
    @Deprecated
    public static final int CONNECTIVITY_18 = Neighborhood3ds.access$1000();
    @Deprecated
    public static final int CONNECTIVITY_26 = Neighborhood3ds.access$1100();
    public final SbEventHandler<EventArg> onBegin;
    public final SbEventHandler<EventArg> onEnd;
    public final SbEventHandler<EventArg> onProgress;

    private static native void waitEvaluateImpl(long var0);

    private static native boolean isEvaluatingImpl(long var0);

    private static native void abortEvaluateImpl(long var0);

    private static native void startEvaluateImpl(long var0);

    private static native long addOnProgressEventHandler(long var0, OnProgressEventHandler var2, String var3);

    private static native boolean removeOnBeginEventHandler(long var0, long var2);

    private static native long addOnBeginEventHandler(long var0, OnBeginEventHandler var2, String var3);

    private static native boolean removeOnProgressEventHandler(long var0, long var2);

    private static native boolean removeOnEndEventHandler(long var0, long var2);

    private static native long addOnEndEventHandler(long var0, OnEndEventHandler var2, String var3);

    protected SoImageVizEngine(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.onBegin = new OnBeginEventHandler();
        this.onEnd = new OnEndEventHandler();
        this.onProgress = new OnProgressEventHandler();
    }

    static native String getClassTypeId();

    public boolean isEvaluating() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoImageVizEngine.isEvaluatingImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void abortEvaluate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoImageVizEngine.abortEvaluateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void waitEvaluate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoImageVizEngine.waitEvaluateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void startEvaluate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoImageVizEngine.startEvaluateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private class OnProgressEventHandler
    extends SbEventHandler<EventArg> {
        private OnProgressEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoImageVizEngine.removeOnProgressEventHandler(SoImageVizEngine.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = EventArg.class.getName();
            this.m_nativeEventHandler = SoImageVizEngine.addOnProgressEventHandler(SoImageVizEngine.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnEndEventHandler
    extends SbEventHandler<EventArg> {
        private OnEndEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoImageVizEngine.removeOnEndEventHandler(SoImageVizEngine.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = EventArg.class.getName();
            this.m_nativeEventHandler = SoImageVizEngine.addOnEndEventHandler(SoImageVizEngine.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnBeginEventHandler
    extends SbEventHandler<EventArg> {
        private OnBeginEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoImageVizEngine.removeOnBeginEventHandler(SoImageVizEngine.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = EventArg.class.getName();
            this.m_nativeEventHandler = SoImageVizEngine.addOnBeginEventHandler(SoImageVizEngine.this.getNativeResourceHandle(), this, string);
        }
    }

    public static class EventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, float var2);

        private static native float getProgressImpl(long var0);

        private static native long getEngineImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected EventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public void setValue(EventArg eventArg) {
            EventArg.setValueImpl(this.getNativeResourceHandle(), eventArg.getNativeResourceHandle());
        }

        @Override
        public SoImageVizEngine getSource() {
            return ObjectManager.getManagedObjectFor(SoImageVizEngine.class, EventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public float getProgress() {
            return EventArg.getProgressImpl(this.getNativeResourceHandle());
        }

        @Deprecated
        public SoImageVizEngine getEngine() {
            return ObjectManager.getManagedObjectFor(SoImageVizEngine.class, EventArg.getEngineImpl(this.getNativeResourceHandle()));
        }

        public EventArg(SoImageVizEngine soImageVizEngine, float f) {
            this(Inventor.ConstructorCommand.CreateInstance, EventArg.ctorImpl(soImageVizEngine != null ? soImageVizEngine.getNativeResourceHandle() : Inventor.ZeroHandle, f));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static enum Neighborhood3ds implements IntegerValuedEnum
    {
        CONNECTIVITY_6(Neighborhood3ds.getCONNECTIVITY6()),
        CONNECTIVITY_18(Neighborhood3ds.getCONNECTIVITY18()),
        CONNECTIVITY_26(Neighborhood3ds.getCONNECTIVITY26());

        private int value;

        private static native int getCONNECTIVITY26();

        private Neighborhood3ds(int n2) {
            this.value = n2;
        }

        private static native int getCONNECTIVITY6();

        private static native int getCONNECTIVITY18();

        @Deprecated
        public static Neighborhood3ds fromValue(int n) {
            return Neighborhood3ds.valueOf(n);
        }

        public static Neighborhood3ds valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Neighborhood3ds.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$900() {
            return Neighborhood3ds.getCONNECTIVITY6();
        }

        static /* synthetic */ int access$1000() {
            return Neighborhood3ds.getCONNECTIVITY18();
        }

        static /* synthetic */ int access$1100() {
            return Neighborhood3ds.getCONNECTIVITY26();
        }
    }

    public static enum ComputeModes implements IntegerValuedEnum
    {
        MODE_2D(ComputeModes.getMODE2D()),
        MODE_3D(ComputeModes.getMODE3D()),
        MODE_AUTO(ComputeModes.getMODEAUTO());

        private int value;

        private static native int getMODEAUTO();

        private ComputeModes(int n2) {
            this.value = n2;
        }

        private static native int getMODE2D();

        private static native int getMODE3D();

        @Deprecated
        public static ComputeModes fromValue(int n) {
            return ComputeModes.valueOf(n);
        }

        public static ComputeModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ComputeModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$600() {
            return ComputeModes.getMODE2D();
        }

        static /* synthetic */ int access$700() {
            return ComputeModes.getMODE3D();
        }

        static /* synthetic */ int access$800() {
            return ComputeModes.getMODEAUTO();
        }
    }
}

