/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.imageviz.engines;

import com.openinventor.imageviz.engines.SoImageVizEngineOutput;
import com.openinventor.imageviz.fields.SoSFAnalysisResult;
import com.openinventor.imageviz.nodes.analysis.SoImageAnalysisResult;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.errors.SoInternalError;
import java.lang.reflect.Constructor;

public class SoImageVizEngineAnalysisOutput<T>
extends SoImageVizEngineOutput<SoSFAnalysisResult, SoImageAnalysisResult> {
    private Class<T> m_TClass;

    SoImageVizEngineAnalysisOutput(Inventor.ConstructorCommand constructorCommand, long l, Class<T> clazz) {
        super(constructorCommand, l, SoSFAnalysisResult.class, SoImageAnalysisResult.class);
        this.initializeFields();
        this.m_TClass = clazz;
    }

    public T getDetail(long l) {
        if (l >= this.getNumDetails()) {
            throw new IndexOutOfBoundsException("index");
        }
        Class[] classArray = new Class[]{SoImageAnalysisResult.class, Integer.TYPE};
        Constructor<T> constructor = null;
        try {
            constructor = this.m_TClass.getDeclaredConstructor(classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new SoInternalError();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new SoInternalError();
        }
        Object[] objectArray = new Object[]{this.getValue(), (int)l};
        try {
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public long getNumDetails() {
        SoImageAnalysisResult soImageAnalysisResult = (SoImageAnalysisResult)this.getValue();
        if (soImageAnalysisResult != null) {
            return soImageAnalysisResult.getNumDetails();
        }
        return 0L;
    }
}

