/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.NativeHandleMap;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.errors.SoInternalError;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Hashtable;

public abstract class AbstractNativeResourceHandle
extends WeakReference<Inventor> {
    private static ReferenceQueue<Inventor> refQueue = new ReferenceQueue();
    private static Hashtable<Long, AbstractNativeResourceHandle> handleMap = new Hashtable();
    Long handle;
    protected Class<? extends Inventor> wrapperClass;
    private int handleState;
    protected int refCounter;

    static ReferenceQueue<Inventor> referenceQueue() {
        return refQueue;
    }

    protected AbstractNativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
        super(inventor, refQueue);
        this.handle = l;
        this.wrapperClass = inventor.getClass();
        this.refCounter = 0;
        this.handleState = NativeHandleStateBitMask.set(0, NativeHandleStateBitMask.NEW_INSTANCE, constructorCommand == Inventor.ConstructorCommand.CreateInstance);
        if (this.isInvalid()) {
            System.err.println("setting handle to a non valid value");
        } else {
            NativeHandleMap.instance.addObjectMapping(l, this);
        }
    }

    public Long getHandle() {
        return this.handle;
    }

    public Inventor referent() {
        return (Inventor)this.get();
    }

    abstract boolean deleteNativeResourceWhenReleased();

    public void setHandle(long l) {
        if (!this.isInvalid()) {
            throw new RuntimeException("Handle already set");
        }
        this.handle = l;
    }

    public boolean isInvalid() {
        return this.handle == 0L;
    }

    void invalidate() {
        this.handle = 0L;
    }

    public boolean isClosed() {
        return NativeHandleStateBitMask.get(this.handleState, NativeHandleStateBitMask.CLOSED);
    }

    private void closeHandle(boolean bl) {
        this.handleState = NativeHandleStateBitMask.set(this.handleState, NativeHandleStateBitMask.CLOSED, bl);
    }

    public boolean isNewInstance() {
        return NativeHandleStateBitMask.get(this.handleState, NativeHandleStateBitMask.NEW_INSTANCE);
    }

    public void DangerousAddRef() {
        if (this.isClosed()) {
            throw new SoInternalError("trying to resurrect a potentially released native resource.");
        }
        ++this.refCounter;
    }

    public void DangerousRelease() {
        if (this.refCounter <= 0) {
            throw new SoInternalError("trying to release twice the same native resource.");
        }
        --this.refCounter;
        this.closeHandle(this.refCounter == 0);
        if (this.isClosed()) {
            NativeHandleMap.instance.removeObjectMapping(this.handle);
        }
    }

    public int DangerousRefCounter() {
        return this.refCounter;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == AbstractNativeResourceHandle.class) {
            AbstractNativeResourceHandle abstractNativeResourceHandle = (AbstractNativeResourceHandle)object;
            return abstractNativeResourceHandle.getHandle() == this.getHandle();
        }
        return false;
    }

    private static enum NativeHandleStateBitMask implements IntegerValuedEnum
    {
        CLOSED(1),
        NEW_INSTANCE(2);

        private int value;

        private NativeHandleStateBitMask(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static int set(int n, NativeHandleStateBitMask nativeHandleStateBitMask, boolean bl) {
            if (bl) {
                return n | nativeHandleStateBitMask.getValue();
            }
            return n & ~nativeHandleStateBitMask.getValue();
        }

        public static boolean get(int n, NativeHandleStateBitMask nativeHandleStateBitMask) {
            return (n & nativeHandleStateBitMask.getValue()) == nativeHandleStateBitMask.getValue();
        }
    }
}

