/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPreferences;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

class DynamicTypeManager {
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String PACKAGE_SEPARATOR_REPLACEMENT = "__";
    private static final String INNER_CLASS_SEPARATOR = "$";
    private static final String INNER_CLASS_SEPARATOR_REPLACEMENT = "___";

    private DynamicTypeManager() {
    }

    static String getCompliantTypeName(String string) {
        return string.replace(PACKAGE_SEPARATOR, PACKAGE_SEPARATOR_REPLACEMENT).replace(INNER_CLASS_SEPARATOR, INNER_CLASS_SEPARATOR_REPLACEMENT);
    }

    static String getClassName(String string) {
        return string.replace(INNER_CLASS_SEPARATOR_REPLACEMENT, INNER_CLASS_SEPARATOR).replace(PACKAGE_SEPARATOR_REPLACEMENT, PACKAGE_SEPARATOR);
    }

    private static String handleUnknownType(String string) {
        Class<Inventor> clazz;
        Object object;
        if (Inventor.VERBOSE_LEVEL > 0) {
            System.out.println("DEBUG JAVA, DynamicTypeManager.handleUnknownType: search for a managed type corresponding to name = " + string);
        }
        Class<?> clazz2 = null;
        String string2 = DynamicTypeManager.getClassName(string);
        try {
            clazz2 = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                object = SoPreferences.getValue("OIV_USER_LIBS");
                if (object == null) {
                    throw new ClassNotFoundException(string2 + " class could not be found.");
                }
                String[] stringArray = ((String)object).split(";");
                ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    if (file.exists()) {
                        try {
                            arrayList.add(file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                        }
                        continue;
                    }
                    System.err.println("The file or directory \"" + stringArray[i] + "\" specified by OIV_USER_LIBS doesn't exist!");
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]));
                clazz2 = Class.forName(string2, true, uRLClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException2.printStackTrace();
            }
        }
        if (clazz2 != null && Inventor.class.isAssignableFrom(clazz2) && (object = ObjectManager.newInstance(clazz = clazz2.asSubclass(Inventor.class))) != null) {
            return NativeTypeMap.getNativeTypeName(clazz);
        }
        return null;
    }

    private static long newInstance(String string) {
        Class<? extends Inventor> clazz = NativeTypeMap.getJavaClass(string);
        Inventor inventor = ObjectManager.newInstance(clazz);
        if (inventor == null) {
            return Inventor.ZeroHandle;
        }
        return inventor.getNativeResourceHandle();
    }
}

