/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.errors.SoInternalError;
import java.util.Hashtable;
import javax.management.RuntimeErrorException;

class NativeHandleMap
extends Hashtable<Long, AbstractNativeResourceHandle> {
    public static final NativeHandleMap instance = new NativeHandleMap();

    private NativeHandleMap() {
    }

    synchronized Object lookupHandle(Long l) {
        AbstractNativeResourceHandle abstractNativeResourceHandle = (AbstractNativeResourceHandle)this.get(l);
        if (abstractNativeResourceHandle != null) {
            Inventor inventor = (Inventor)abstractNativeResourceHandle.get();
            if (inventor == null) {
                this.removeObjectMapping(l);
            } else if (abstractNativeResourceHandle.isEnqueued() || inventor.getNativeResourceHandle().longValue() != l.longValue() || !abstractNativeResourceHandle.wrapperClass.isAssignableFrom(inventor.getClass())) {
                this.removeObjectMapping(l);
                inventor = null;
            }
            return inventor;
        }
        return null;
    }

    synchronized void removeObjectMapping(Long l) {
        if (l != 0L) {
            this.remove(l);
        }
    }

    synchronized void addObjectMapping(Long l, AbstractNativeResourceHandle abstractNativeResourceHandle) {
        AbstractNativeResourceHandle abstractNativeResourceHandle2 = (AbstractNativeResourceHandle)this.get(l);
        if (abstractNativeResourceHandle2 != null && !abstractNativeResourceHandle.isNewInstance() && abstractNativeResourceHandle2.deleteNativeResourceWhenReleased() && abstractNativeResourceHandle2.referent() != null && abstractNativeResourceHandle2.referent() != abstractNativeResourceHandle.referent()) {
            throw new RuntimeErrorException(new SoInternalError("Trying to duplicate a wrapper object"));
        }
        if (abstractNativeResourceHandle2 != null) {
            this.removeObjectMapping(l);
            if (abstractNativeResourceHandle2.isEnqueued()) {
                abstractNativeResourceHandle2.invalidate();
            }
        }
        assert (!this.containsKey(l));
        this.put(l, abstractNativeResourceHandle);
    }
}

