/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.AWTGlobalLock;
import com.openinventor.internal.ClassHelper;
import com.openinventor.internal.NativeHandleMap;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.details.SoDetail;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.errors.SoError;
import com.openinventor.inventor.errors.SoInternalError;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.misc.SoBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;

public class ObjectManager {
    private static Hashtable<String, ClassHelper> registeredHelpers = new Hashtable();
    public static final Lock globalLock = new AWTGlobalLock();
    static final boolean DISPOSE_RESOURCE_ON_EVENT_DISPATCHING_THREAD = SoPreferences.getBoolean("DISPOSE_RESOURCE_ON_EVENT_DISPATCHING_THREAD", true);
    private static final int VERBOSE_LEVEL = SoPreferences.getInteger("OIV_JAVA_VERBOSE_LEVEL", 0);

    private ObjectManager() {
    }

    public static void registerHelper(ClassHelper classHelper) {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Register helper for " + classHelper.getClass().getPackage().getName());
        }
        registeredHelpers.put(classHelper.getClass().getPackage().getName(), classHelper);
    }

    public static ClassHelper helperFor(Class<?> clazz) {
        ClassHelper classHelper = registeredHelpers.get(clazz.getPackage().getName());
        if (classHelper == null) {
            try {
                Class.forName(clazz.getPackage().getName() + ".PackageAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            finally {
                classHelper = registeredHelpers.get(clazz.getPackage().getName());
            }
        }
        return classHelper;
    }

    private static <T extends Inventor> T getManagedObjectForInternal(Class<T> clazz, long l) {
        return ObjectManager.getManagedObjectFor(clazz, l, null);
    }

    private static <T extends Inventor> T getManagedObjectForInternal(String string, long l) {
        try {
            Class<?> clazz = Class.forName(string);
            return (T)ObjectManager.getManagedObjectFor(clazz, l, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        return null;
    }

    private static <T extends Enum<?>> T getEnumValueOf(String string, int n) {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("valueOf", Integer.TYPE);
            Enum enum_ = (Enum)method.invoke(null, n);
            return (T)enum_;
        }
        catch (ClassCastException | ClassNotFoundException exception) {
            exception.printStackTrace();
        }
        catch (NoSuchMethodException | SecurityException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static <T> T newInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (T)ObjectManager.newInstance(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    static <T> T newInstance(final Class<T> clazz) {
        Object t = AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Object t;
                block9: {
                    t = null;
                    try {
                        Class<?> clazz2 = clazz.getEnclosingClass();
                        try {
                            if (clazz2 == null) {
                                t = clazz.newInstance();
                                break block9;
                            }
                            Object obj = ObjectManager.newInstance(clazz2);
                            Constructor constructor = clazz.getConstructor(clazz2);
                            t = constructor.newInstance(obj);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            t = constructor.newInstance(new Object[0]);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        throw new SoInternalError("ObjectManager.createInstance: " + clazz + " class does not define a default constructor.");
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                        throw new SoInternalError("ObjectManager.createInstance: " + clazz + " class does not define a default constructor.");
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                        throw new SoInternalError("ObjectManager.createInstance: " + clazz + " class does not define a default constructor.");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                return t;
            }
        });
        return t;
    }

    public static <T extends SbBasic> T getBasicObjectFor(Class<T> clazz, Long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new SoInternalError();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new SoInternalError();
        }
        Object[] objectArray = new Object[]{l};
        ClassHelper classHelper = ObjectManager.helperFor(clazz);
        assert (classHelper != null);
        return (T)((SbBasic)classHelper.newInstance(constructor, objectArray));
    }

    public static <T extends Inventor> T getManagedObjectFor(Class<T> clazz, Long l) {
        return ObjectManager.getManagedObjectFor(clazz, l, null);
    }

    public static <T extends Inventor> T getManagedObjectFor(Class<T> clazz, Long l, Class<?> ... classArray) {
        if (l == 0L) {
            return null;
        }
        T t = ObjectManager.getCustomClassObject(clazz, l);
        if (t != null) {
            return t;
        }
        Class<? extends Inventor> clazz2 = null;
        if (SoAction.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoActionNativeObject(l);
        } else if (SoBase.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoBaseNativeObject(l);
        } else if (SoDetail.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoDetailNativeObject(l);
        } else if (SoError.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoErrorNativeObject(l);
        } else if (SoEvent.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoEventNativeObject(l);
        } else if (SoField.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoFieldNativeObject(l);
        } else if (SoElement.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoElementNativeObject(l);
        } else if (SoBufferObject.class.isAssignableFrom(clazz)) {
            clazz2 = ObjectManager.getManagedClassForSoBufferObjectNativeObject(l);
        }
        Object object = NativeHandleMap.instance.lookupHandle(l);
        if (object != null) {
            if (clazz2 != null) {
                if (clazz2.isAssignableFrom(object.getClass())) {
                    return (T)((Inventor)object);
                }
                NativeHandleMap.instance.removeObjectMapping(l);
            } else {
                if (clazz.isAssignableFrom(object.getClass())) {
                    return (T)((Inventor)object);
                }
                NativeHandleMap.instance.removeObjectMapping(l);
            }
        }
        if (clazz2 != null) {
            return (T)ObjectManager.createManagedObject(clazz2, l, classArray);
        }
        return ObjectManager.createManagedObject(clazz, l, classArray);
    }

    private static <T extends Inventor> T createManagedObject(Class<T> clazz, Long l, Class<?>[] classArray) {
        return ObjectManager.createManagedObject(clazz, l, classArray, Inventor.ConstructorCommand.CreateFromInstance);
    }

    public static <T extends Inventor> T createManagedObject(Class<T> clazz, Long l, Inventor.ConstructorCommand constructorCommand) {
        return ObjectManager.createManagedObject(clazz, l, null, constructorCommand);
    }

    public static <T extends Inventor> T createManagedObject(Class<T> clazz, Long l, Class<?>[] classArray, Inventor.ConstructorCommand constructorCommand) {
        int n = 2 + (classArray != null ? classArray.length : 0);
        Class[] classArray2 = new Class[n];
        classArray2[0] = Inventor.ConstructorCommand.class;
        classArray2[1] = Long.TYPE;
        for (int i = 2; i < n; ++i) {
            classArray2[i] = Class.class;
        }
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(classArray2);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new SoInternalError();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new SoInternalError();
        }
        Object[] objectArray = new Object[n];
        objectArray[0] = constructorCommand;
        objectArray[1] = l;
        for (int i = 2; i < n; ++i) {
            objectArray[i] = classArray[i - 2];
        }
        ClassHelper classHelper = ObjectManager.helperFor(clazz);
        assert (classHelper != null);
        return (T)((Inventor)classHelper.newInstance(constructor, objectArray));
    }

    private static Class<? extends Inventor> getManagedClassForSoErrorNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoErrorNativeTypeName(l));
    }

    private static Class<? extends Inventor> getManagedClassForSoDetailNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoDetailNativeTypeName(l));
    }

    private static Class<? extends Inventor> getManagedClassForSoBaseNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoBaseNativeTypeName(l));
    }

    private static Class<? extends Inventor> getManagedClassForSoActionNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoActionNativeTypeName(l));
    }

    private static Class<? extends Inventor> getManagedClassForSoFieldNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoFieldNativeTypeName(l));
    }

    private static Class<? extends Inventor> getManagedClassForSoEventNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoEventNativeTypeName(l));
    }

    private static Class<? extends Inventor> getManagedClassForSoElementNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoElementNativeTypeName(l));
    }

    private static Class<? extends Inventor> getManagedClassForSoBufferObjectNativeObject(Long l) {
        return NativeTypeMap.getJavaClass(ObjectManager.getSoBufferObjectNativeTypeName(l));
    }

    private static native String getSoEventNativeTypeName(long var0);

    private static native String getSoElementNativeTypeName(long var0);

    private static native String getSoFieldNativeTypeName(long var0);

    private static native String getSoActionNativeTypeName(long var0);

    private static native String getSoBaseNativeTypeName(long var0);

    private static native String getSoDetailNativeTypeName(long var0);

    private static native String getSoErrorNativeTypeName(long var0);

    private static native String getSoBufferObjectNativeTypeName(long var0);

    private static <T extends Inventor> T getCustomClassObject(Class<T> clazz, Long l) {
        if (SoBase.class.isAssignableFrom(clazz)) {
            return (T)((Inventor)ObjectManager.getCustomSoBaseClass(l));
        }
        if (SoDetail.class.isAssignableFrom(clazz)) {
            return (T)((Inventor)ObjectManager.getCustomSoDetailClass(l));
        }
        if (SoElement.class.isAssignableFrom(clazz)) {
            return (T)((Inventor)ObjectManager.getCustomSoElementClass(l));
        }
        return null;
    }

    private static native Object getCustomSoBaseClass(long var0);

    private static native Object getCustomSoDetailClass(long var0);

    private static native Object getCustomSoElementClass(long var0);
}

