/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.errors.SoInternalError;
import com.openinventor.inventor.sensors.SoTimerSensor;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;

public final class ProcessReferenceQueueBounded {
    private static final Runnable PROCESS_REF_QUEUE_TASK = new ProcessReferenceQueueTask();
    private static SoTimerSensor s_processRefQueueSensor = null;

    public static void init() {
        s_processRefQueueSensor = null;
        SbTime sbTime = new SbTime(0.0);
        SbTime sbTime2 = new SbTime(0.1);
        s_processRefQueueSensor = new SoTimerSensor(PROCESS_REF_QUEUE_TASK);
        s_processRefQueueSensor.setBaseTime(sbTime);
        s_processRefQueueSensor.setInterval(sbTime2);
        try {
            Method method = Inventor.class.getDeclaredMethod("setSynchronized", Boolean.TYPE);
            ObjectManager.helperFor(SoDB.class).invokeMethod(method, s_processRefQueueSensor, new Object[]{false});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SoInternalError("instance cannot be desynchronized");
        }
        catch (SecurityException securityException) {
            throw new SoInternalError("instance cannot be desynchronized");
        }
    }

    public static void reset() {
        if (s_processRefQueueSensor != null) {
            s_processRefQueueSensor.unschedule();
            s_processRefQueueSensor = null;
        }
    }

    public static void run() {
        if (s_processRefQueueSensor != null) {
            if (ObjectManager.DISPOSE_RESOURCE_ON_EVENT_DISPATCHING_THREAD) {
                if (!s_processRefQueueSensor.isScheduled()) {
                    s_processRefQueueSensor.schedule();
                }
            } else {
                PROCESS_REF_QUEUE_TASK.run();
            }
        }
    }

    private static class ProcessReferenceQueueTask
    implements Runnable {
        private ProcessReferenceQueueTask() {
        }

        @Override
        public void run() {
            ReferenceQueue<Inventor> referenceQueue = AbstractNativeResourceHandle.referenceQueue();
            AbstractNativeResourceHandle abstractNativeResourceHandle = null;
            ObjectManager.globalLock.lock();
            try {
                do {
                    if ((abstractNativeResourceHandle = (AbstractNativeResourceHandle)referenceQueue.poll()) == null || abstractNativeResourceHandle.isInvalid()) continue;
                    abstractNativeResourceHandle.DangerousRelease();
                } while (abstractNativeResourceHandle != null);
                if (s_processRefQueueSensor != null) {
                    s_processRefQueueSensor.unschedule();
                }
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

