/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.TypedNativeResourceHandle;
import com.openinventor.inventor.Inventor;

public final class RefCountedNativeResourceHandle
extends TypedNativeResourceHandle {
    private static native void refImpl(long var0);

    private static native void unrefImpl(long var0);

    private static native int getRefCount(long var0);

    public RefCountedNativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
        super(inventor, l, constructorCommand);
    }

    @Override
    public void DangerousRelease() {
        super.DangerousRelease();
        ObjectManager.globalLock.lock();
        try {
            RefCountedNativeResourceHandle.unrefImpl(this.handle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    public void DangerousAddRef() {
        super.DangerousAddRef();
        RefCountedNativeResourceHandle.refImpl(this.handle);
    }

    @Override
    public int DangerousRefCounter() {
        return RefCountedNativeResourceHandle.getRefCount(this.handle);
    }

    @Override
    boolean deleteNativeResourceWhenReleased() {
        return true;
    }
}

