/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import java.util.Stack;

public class ThreadPool {
    private Stack<Worker> pool = new Stack();
    private int maxSize = 10;

    public void setMaximumSize(int n) {
        this.maxSize = n;
    }

    public synchronized void run(Runnable runnable) {
        if (this.pool.size() == 0) {
            new Worker(runnable);
        } else {
            Worker worker = this.pool.pop();
            worker.run(runnable);
        }
    }

    private synchronized void returnWorker(Worker worker) {
        if (this.pool.size() < this.maxSize) {
            this.pool.push(worker);
        } else {
            worker.die();
        }
    }

    class Worker
    extends Thread {
        boolean running = true;
        Runnable work;

        Worker(Runnable runnable) {
            this.work = runnable;
            this.setDaemon(true);
            this.start();
        }

        public synchronized void die() {
            this.running = false;
            this.notify();
        }

        public synchronized void run(Runnable runnable) {
            if (this.work != null) {
                throw new IllegalStateException("Worker already has work to do.");
            }
            this.work = runnable;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                if (this.work != null) {
                    try {
                        this.work.run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.work = null;
                }
                ThreadPool.this.returnWorker(this);
                Worker worker = this;
                synchronized (worker) {
                    while (this.running && this.work == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }
}

