/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.ProcessReferenceQueueBounded;
import com.openinventor.inventor.DelayQueueManager;
import com.openinventor.inventor.RealTimeManager;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.errors.SoInternalError;
import com.openinventor.inventor.errors.SoLicenseError;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.locks.Lock;

public abstract class Inventor {
    private AbstractNativeResourceHandle nativeResourceHandle = null;
    @Deprecated
    private long address = 0L;
    public static final int VERBOSE_LEVEL;
    public static final long ZeroHandle;
    private static boolean internalTaskStarted;
    private boolean m_hasDispose = false;
    private static HashSet<Inventor> stronglyReferencedObjects;
    private boolean m_isSynchronized = true;

    static void doStaticInit() {
    }

    protected static <T extends Inventor> Vector<T> toVector(Class<T> clazz, long[] lArray) {
        Vector<T> vector = new Vector<T>();
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                vector.add(ObjectManager.getManagedObjectFor(clazz, lArray[i]));
            }
        }
        return vector;
    }

    public static void startInternalThreads() {
        if (!internalTaskStarted && !SoDB.useWrappedTimerSensors) {
            if (VERBOSE_LEVEL > 0) {
                System.out.println("Start internal threads");
            }
            RealTimeManager.start();
            DelayQueueManager.start();
            internalTaskStarted = true;
        }
    }

    public static void stopInternalThreads() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Stop internal threads");
        }
        RealTimeManager.stop();
        DelayQueueManager.stop();
        internalTaskStarted = false;
    }

    @Deprecated
    protected void initializeNativeHandle() {
    }

    protected void initializeNativeHandle(long l) {
        if (this.nativeResourceHandle == null) {
            ObjectManager.globalLock.lock();
            try {
                this.setNativeResourceHandle(ConstructorCommand.CreateFromInstance, l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    private static final native void checkJVM();

    protected static native void setNativeDebug(boolean var0);

    private static final native void initNativeOiv(long var0);

    private static final void handleLicenseError(String string) {
        if (string != null) {
            throw new SoLicenseError(string);
        }
    }

    protected static final void checkOivLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check OpenInventor license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkOivLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    protected static final void checkMVizLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check MeshViz license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkMVizLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    protected static final void checkVVizLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check VolumeViz license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkVVizLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    protected static final void checkVldmLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check LDM license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkVldmLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    protected static final void checkHcpyLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check HardCopy license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkHcpyLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    protected static final void checkDVizLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check DirectViz license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkDVizLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    protected static final void checkMVizXLMLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check MeshVizXLM license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkMVizXLMLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    protected static final void checkIVizLP() {
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check ImageViz license");
        }
        String string = null;
        ObjectManager.globalLock.lock();
        try {
            string = Inventor.checkIVizLPImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        Inventor.handleLicenseError(string);
    }

    private static final native String checkOivLPImpl();

    private static final native String checkMVizLPImpl();

    private static final native String checkVVizLPImpl();

    private static final native String checkVldmLPImpl();

    private static final native String checkHcpyLPImpl();

    private static final native String checkDVizLPImpl();

    private static final native String checkMVizXLMLPImpl();

    private static final native String checkIVizLPImpl();

    public Long getNativeResourceHandle() {
        if (this.nativeResourceHandle == null) {
            throw new IllegalStateException("Object does not hold any native resource.");
        }
        if (this.nativeResourceHandle.isClosed()) {
            throw new SoInternalError("Trying to use a native handle already closed.");
        }
        if (this.m_hasDispose) {
            throw new SoInternalError("Trying to use a native handle beeing closed.");
        }
        return this.nativeResourceHandle.getHandle();
    }

    private long getNativeResourceHandleInternal() {
        return this.getNativeResourceHandle();
    }

    @Deprecated
    public long getAddress() {
        return this.getNativeResourceHandle();
    }

    protected void setNativeResourceHandle(ConstructorCommand constructorCommand, Long l) {
        if (this.nativeResourceHandle != null) {
            throw new SoInternalError("Trying to set twice native resource handle for the same object.");
        }
        this.nativeResourceHandle = this.createHandleForNativeResource(constructorCommand, l);
        this.nativeResourceHandle.DangerousAddRef();
        this.address = l;
    }

    protected abstract AbstractNativeResourceHandle createHandleForNativeResource(ConstructorCommand var1, long var2);

    protected void initializeFields() {
    }

    protected long createNativeObject(String string, Object ... objectArray) {
        throw new UnsupportedOperationException("Cannot create native object! createNativeObject method must be overridden.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Inventor(ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        if (constructorCommand == ConstructorCommand.DontCreateInstance) {
            return;
        }
        ObjectManager.globalLock.lock();
        try {
            this.setNativeResourceHandle(constructorCommand, this.createNativeObject(string, objectArray));
            ProcessReferenceQueueBounded.run();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected Inventor(ConstructorCommand constructorCommand, long l) {
        if (constructorCommand == ConstructorCommand.DontCreateInstance) {
            return;
        }
        this.setNativeResourceHandle(constructorCommand, l);
        ProcessReferenceQueueBounded.run();
    }

    protected boolean hasDispose() {
        return this.m_hasDispose;
    }

    protected int getRefCount() {
        return this.nativeResourceHandle.DangerousRefCounter();
    }

    @Deprecated
    public boolean dispose() {
        boolean bl;
        if (this.m_hasDispose) {
            return false;
        }
        boolean bl2 = bl = this.nativeResourceHandle != null && !this.nativeResourceHandle.isInvalid() && !this.nativeResourceHandle.isClosed() && !this.nativeResourceHandle.isEnqueued();
        if (bl) {
            this.internalDispose();
        }
        return bl;
    }

    protected void internalDispose() {
        if (VERBOSE_LEVEL > 1) {
            System.out.println("Dispose object of class " + this.getClass() + " with handle=" + this.getNativeResourceHandle());
        }
        if (this.nativeResourceHandle == null) {
            throw new IllegalStateException("Object does not hold any native resource.");
        }
        if (this.m_hasDispose || this.nativeResourceHandle.isInvalid() || this.nativeResourceHandle.isClosed()) {
            throw new IllegalStateException("Object already disposed.");
        }
        if (this.nativeResourceHandle.isEnqueued()) {
            throw new SoInternalError("Object already registered to be disposed.");
        }
        this.preMortenClean();
        boolean bl = this.nativeResourceHandle.enqueue();
        assert (bl);
        this.m_hasDispose = true;
        ObjectManager.globalLock.lock();
        try {
            ProcessReferenceQueueBounded.run();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected void preMortenClean() {
    }

    void setCandidateForStrongReference(boolean bl) {
        if (bl && !stronglyReferencedObjects.contains(this)) {
            stronglyReferencedObjects.add(this);
        } else if (!bl) {
            stronglyReferencedObjects.remove(this);
        }
    }

    private static void printErrorMessage(String string) {
        System.err.println(string);
    }

    final boolean isSyncronized() {
        return this.m_isSynchronized;
    }

    final void setSynchronized(boolean bl) {
        this.m_isSynchronized = bl;
    }

    protected final void acquireLock(Lock lock) {
        if (this.m_isSynchronized) {
            lock.lock();
        }
    }

    protected final void releaseLock(Lock lock) {
        if (this.m_isSynchronized) {
            lock.unlock();
        }
    }

    static {
        Package package_;
        internalTaskStarted = false;
        SoDB.init();
        VERBOSE_LEVEL = SoPreferences.getInteger("OIV_JAVA_VERBOSE_LEVEL", 0);
        Inventor.setNativeDebug(VERBOSE_LEVEL > 0);
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Check JVM");
        }
        Inventor.checkJVM();
        if ((SoPreferences.getValue("VSG_LICENSE_DEBUG") != null || SoPreferences.getValue("OIV_LICENSE_DEBUG") != null) && (package_ = Package.getPackage("com.openinventor.inventor")) != null) {
            System.out.println("");
            System.out.println("************************** Jar manifest content **************************");
            System.out.println("Specification Title    : " + package_.getSpecificationTitle());
            System.out.println("Specification vendor   : " + package_.getSpecificationVendor());
            System.out.println("Specification version  : " + package_.getSpecificationVersion());
            System.out.println("Implementation version : " + package_.getImplementationVersion());
            System.out.println("**************************************************************************");
            System.out.println("");
        }
        ZeroHandle = 0L;
        stronglyReferencedObjects = new HashSet();
        if (VERBOSE_LEVEL > 0) {
            System.out.println("OpenInventor initialization");
        }
        Inventor.initNativeOiv(System.currentTimeMillis());
        Inventor.checkOivLP();
        if (!internalTaskStarted) {
            Inventor.startInternalThreads();
        }
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Reference queue initialization");
        }
        ProcessReferenceQueueBounded.init();
    }

    public static enum ConstructorCommand {
        CreateInstance,
        DontCreateInstance,
        CreateFromInstance;

    }
}

