/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.fields.SoSFTime;
import com.openinventor.inventor.sensors.SoTimerSensor;

abstract class RealTimeManager {
    private static SoTimerSensor realTimeSensor = null;
    private static RealTimeModifier realTimeModifier = null;

    RealTimeManager() {
    }

    static void start() {
        realTimeModifier = new RealTimeModifier();
        realTimeSensor = new SoTimerSensor();
        realTimeSensor.setMsecInterval(10L);
        realTimeSensor.setTask(realTimeModifier);
        realTimeSensor.schedule();
    }

    static void stop() {
        if (realTimeSensor != null) {
            realTimeSensor.unschedule();
        }
        realTimeSensor = null;
        realTimeModifier = null;
    }

    static native void processTimerQueueNative();

    static class RealTimeModifier
    implements Runnable {
        private SbTime realSbTime = new SbTime();
        private SoSFTime realTime = (SoSFTime)SoDB.getGlobalField("realTime");

        RealTimeModifier() {
        }

        @Override
        public void run() {
            this.realSbTime.setMsecValue(System.currentTimeMillis());
            this.realTime.setValue(this.realSbTime);
            ObjectManager.globalLock.lock();
            try {
                RealTimeManager.processTimerQueueNative();
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

