/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbMatrixd;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec4f;
import java.util.Arrays;

public class SbMatrix
extends SbBasic {
    public final float[] array;

    public float[] getRow(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException();
        }
        float[] fArray = new float[4];
        for (int i = 0; i < 4; ++i) {
            fArray[i] = this.array[n + i * 4];
        }
        return fArray;
    }

    public float[] getColumn(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException();
        }
        return Arrays.copyOfRange(this.array, 4 * n, 4 * (n + 1));
    }

    public void setElement(int n, int n2, float f) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException();
        }
        this.array[n + 4 * n2] = f;
    }

    public float getElement(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException();
        }
        return this.array[n + 4 * n2];
    }

    private static native void scaleImpl(float[] var0, float[] var1);

    private static native void inverseImpl(float[] var0, float[] var1);

    private static native void setValueFromHandle(float[] var0, long var1);

    private static native void multRightImpl(float[] var0, float[] var1, float[] var2);

    private static native void multLeftImpl(float[] var0, float[] var1, float[] var2);

    private static native void transposeImpl(float[] var0, float[] var1);

    private static native void decomposeImpl(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4, float[] var5);

    private static native void decomposeImpl1(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4);

    private static native void setTransformImpl1(float[] var0, float[] var1, float[] var2, float[] var3);

    private static native void setTransformImpl2(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4);

    private static native float det4Impl(float[] var0);

    private static native boolean factorImpl(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4, float[] var5);

    private static native float det3Impl(float[] var0, int var1, int var2, int var3, int var4, int var5, int var6);

    private static native float det3Impl1(float[] var0);

    private static native void multMatrixVecImpl(float[] var0, float[] var1, float[] var2);

    private static native boolean equalsImpl1(float[] var0, float[] var1, float var2);

    private static native boolean isInvertibleImpl(float[] var0);

    private static native void timesImpl(float[] var0, float[] var1, float[] var2);

    private static native boolean equalsImpl(float[] var0, float[] var1);

    private static native void toArrayImpl(long var0, SbMatrix[] var2);

    private static native void identityImpl(float[] var0);

    private static native void multVec4MatrixImpl(float[] var0, float[] var1, float[] var2);

    private static native void multDirMatrixImpl(float[] var0, float[] var1, float[] var2);

    private static native void multVecMatrixImpl(float[] var0, float[] var1, float[] var2);

    private static native void multMatrixVec4Impl(float[] var0, float[] var1, float[] var2);

    private static native void multiplyImpl(float[] var0, float[] var1);

    private static native void multLineMatrixImpl(float[] var0, float[] var1, float[] var2);

    private static native void setTransformImpl(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4, float[] var5);

    private static native void checkSize();

    private static native void setScaleImpl1(float[] var0, float[] var1);

    private static native void setScaleImpl(float[] var0, float var1);

    private static native void makeIdentityImpl(float[] var0);

    private static native void setValueImpl(float[] var0, double[] var1);

    private static native void setRotateImpl(float[] var0, float[] var1);

    private static native void translateImpl(float[] var0, float[] var1);

    private static native void setTranslateImpl(float[] var0, float[] var1);

    protected SbMatrix(int n) {
        this.array = new float[n];
    }

    SbMatrix(long l) {
        this();
        SbMatrix.setValueFromHandle(this.array, l);
    }

    public float[] getValue() {
        return this.array;
    }

    public void setValue(SbMatrix sbMatrix) {
        this.setValue(sbMatrix.array);
    }

    public SbMatrix setValue(float[] fArray) {
        for (int i = 0; i < 16; ++i) {
            this.array[i] = fArray[i];
        }
        return this;
    }

    public SbMatrix setValue(float[] fArray, int n) {
        if (n < 0 || n >= fArray.length - 16) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 16; ++i) {
            this.array[i] = fArray[n + i];
        }
        return this;
    }

    public SbMatrix setValue(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.array[0] = f;
        this.array[1] = f2;
        this.array[2] = f3;
        this.array[3] = f4;
        this.array[4] = f5;
        this.array[5] = f6;
        this.array[6] = f7;
        this.array[7] = f8;
        this.array[8] = f9;
        this.array[9] = f10;
        this.array[10] = f11;
        this.array[11] = f12;
        this.array[12] = f13;
        this.array[13] = f14;
        this.array[14] = f15;
        this.array[15] = f16;
        return this;
    }

    public SbMatrix(float[] fArray) {
        this(16);
        if (fArray == null) {
            throw new IllegalArgumentException("Expected a non-null argument.");
        }
        if (fArray.length != 16) {
            throw new IllegalArgumentException("Expected size is 16.");
        }
        this.setValue(fArray);
    }

    public SbMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this(16);
        this.setValue(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public SbMatrix(SbMatrix sbMatrix) {
        this();
        this.setValue(sbMatrix);
    }

    public SbMatrix() {
        this(16);
        this.setValue(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public float getValueAt(int n) {
        return this.array[n];
    }

    public void setValueAt(int n, float f) {
        this.array[n] = f;
    }

    public static SbMatrix[] toArray(long l, long l2) {
        SbMatrix[] sbMatrixArray = new SbMatrix[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbMatrixArray[n] = new SbMatrix();
            ++n;
        }
        SbMatrix.toArrayImpl(l, sbMatrixArray);
        return sbMatrixArray;
    }

    public void setTransform(SbVec3f sbVec3f, SbRotation sbRotation, SbVec3f sbVec3f2) {
        SbMatrix.setTransformImpl1(this.array, sbVec3f != null ? sbVec3f.array : null, sbRotation != null ? sbRotation.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
    }

    public void multiply(SbMatrix sbMatrix) {
        SbMatrix.multiplyImpl(this.array, sbMatrix != null ? sbMatrix.array : null);
    }

    public boolean equals(SbMatrix sbMatrix, float f) {
        return SbMatrix.equalsImpl1(this.array, sbMatrix != null ? sbMatrix.array : null, f);
    }

    public SbMatrix times(SbMatrix sbMatrix) {
        SbMatrix sbMatrix2 = new SbMatrix();
        SbMatrix.timesImpl(this.array, sbMatrix != null ? sbMatrix.array : null, sbMatrix2.array);
        return sbMatrix2;
    }

    public boolean isInvertible() {
        return SbMatrix.isInvertibleImpl(this.array);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SbMatrix) {
            SbMatrix sbMatrix = (SbMatrix)object;
            return SbMatrix.equalsImpl(this.array, sbMatrix.array);
        }
        return false;
    }

    public static SbMatrix identity() {
        SbMatrix sbMatrix = new SbMatrix();
        SbMatrix.identityImpl(sbMatrix.array);
        return sbMatrix;
    }

    public Factorization factor() {
        Factorization factorization = new Factorization();
        SbMatrix sbMatrix = new SbMatrix();
        SbVec3f sbVec3f = new SbVec3f();
        SbMatrix sbMatrix2 = new SbMatrix();
        SbVec3f sbVec3f2 = new SbVec3f();
        SbMatrix sbMatrix3 = new SbMatrix();
        boolean bl = false;
        bl = SbMatrix.factorImpl(this.array, sbMatrix != null ? sbMatrix.array : null, sbVec3f != null ? sbVec3f.array : null, sbMatrix2 != null ? sbMatrix2.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbMatrix3 != null ? sbMatrix3.array : null);
        if (bl) {
            factorization.r = sbMatrix;
            factorization.s = sbVec3f;
            factorization.u = sbMatrix2;
            factorization.t = sbVec3f2;
            factorization.proj = sbMatrix3;
            return factorization;
        }
        return null;
    }

    public void setScale(float f) {
        SbMatrix.setScaleImpl(this.array, f);
    }

    public float det4() {
        return SbMatrix.det4Impl(this.array);
    }

    public SbMatrix inverse() {
        SbMatrix sbMatrix = new SbMatrix();
        SbMatrix.inverseImpl(this.array, sbMatrix.array);
        return sbMatrix;
    }

    public void scale(SbVec3f sbVec3f) {
        SbMatrix.scaleImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void translate(SbVec3f sbVec3f) {
        SbMatrix.translateImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void setRotate(SbRotation sbRotation) {
        SbMatrix.setRotateImpl(this.array, sbRotation != null ? sbRotation.array : null);
    }

    public float det3() {
        return SbMatrix.det3Impl1(this.array);
    }

    public Decomposition decompose(SbVec3f sbVec3f) {
        Decomposition decomposition = new Decomposition();
        SbVec3f sbVec3f2 = new SbVec3f();
        SbRotation sbRotation = new SbRotation();
        SbVec3f sbVec3f3 = new SbVec3f();
        SbRotation sbRotation2 = new SbRotation();
        SbMatrix.decomposeImpl(this.array, sbVec3f2 != null ? sbVec3f2.array : null, sbRotation != null ? sbRotation.array : null, sbVec3f3 != null ? sbVec3f3.array : null, sbRotation2 != null ? sbRotation2.array : null, sbVec3f != null ? sbVec3f.array : null);
        decomposition.translation = sbVec3f2;
        decomposition.rotation = sbRotation;
        decomposition.scaleFactor = sbVec3f3;
        decomposition.scaleOrientation = sbRotation2;
        return decomposition;
    }

    public void setTransform(SbVec3f sbVec3f, SbRotation sbRotation, SbVec3f sbVec3f2, SbRotation sbRotation2) {
        SbMatrix.setTransformImpl2(this.array, sbVec3f != null ? sbVec3f.array : null, sbRotation != null ? sbRotation.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbRotation2 != null ? sbRotation2.array : null);
    }

    public void setTransform(SbVec3f sbVec3f, SbRotation sbRotation, SbVec3f sbVec3f2, SbRotation sbRotation2, SbVec3f sbVec3f3) {
        SbMatrix.setTransformImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbRotation != null ? sbRotation.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbRotation2 != null ? sbRotation2.array : null, sbVec3f3 != null ? sbVec3f3.array : null);
    }

    public void setTranslate(SbVec3f sbVec3f) {
        SbMatrix.setTranslateImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void setScale(SbVec3f sbVec3f) {
        SbMatrix.setScaleImpl1(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public float det3(int n, int n2, int n3, int n4, int n5, int n6) {
        return SbMatrix.det3Impl(this.array, n, n2, n3, n4, n5, n6);
    }

    public Decomposition decompose() {
        Decomposition decomposition = new Decomposition();
        SbVec3f sbVec3f = new SbVec3f();
        SbRotation sbRotation = new SbRotation();
        SbVec3f sbVec3f2 = new SbVec3f();
        SbRotation sbRotation2 = new SbRotation();
        SbMatrix.decomposeImpl1(this.array, sbVec3f != null ? sbVec3f.array : null, sbRotation != null ? sbRotation.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbRotation2 != null ? sbRotation2.array : null);
        decomposition.translation = sbVec3f;
        decomposition.rotation = sbRotation;
        decomposition.scaleFactor = sbVec3f2;
        decomposition.scaleOrientation = sbRotation2;
        return decomposition;
    }

    public SbVec4f multMatrixVec4(SbVec3f sbVec3f) {
        SbVec4f sbVec4f = new SbVec4f();
        SbMatrix.multMatrixVec4Impl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec4f != null ? sbVec4f.array : null);
        return sbVec4f;
    }

    public SbVec3f multVecMatrix(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbMatrix.multVecMatrixImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        return sbVec3f2;
    }

    public SbVec4f multVec4Matrix(SbVec3f sbVec3f) {
        SbVec4f sbVec4f = new SbVec4f();
        SbMatrix.multVec4MatrixImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec4f != null ? sbVec4f.array : null);
        return sbVec4f;
    }

    public SbLine multLineMatrix(SbLine sbLine) {
        SbLine sbLine2 = new SbLine();
        SbMatrix.multLineMatrixImpl(this.array, sbLine != null ? sbLine.array : null, sbLine2 != null ? sbLine2.array : null);
        return sbLine2;
    }

    public SbVec3f multDirMatrix(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbMatrix.multDirMatrixImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        return sbVec3f2;
    }

    public SbVec3f multMatrixVec(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbMatrix.multMatrixVecImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        return sbVec3f2;
    }

    public void makeIdentity() {
        SbMatrix.makeIdentityImpl(this.array);
    }

    public void setValue(SbMatrixd sbMatrixd) {
        SbMatrix.setValueImpl(this.array, sbMatrixd != null ? sbMatrixd.array : null);
    }

    public SbMatrix multLeft(SbMatrix sbMatrix) {
        SbMatrix sbMatrix2 = new SbMatrix();
        SbMatrix.multLeftImpl(this.array, sbMatrix != null ? sbMatrix.array : null, sbMatrix2.array);
        return sbMatrix2;
    }

    public SbMatrix multRight(SbMatrix sbMatrix) {
        SbMatrix sbMatrix2 = new SbMatrix();
        SbMatrix.multRightImpl(this.array, sbMatrix != null ? sbMatrix.array : null, sbMatrix2.array);
        return sbMatrix2;
    }

    public SbMatrix transpose() {
        SbMatrix sbMatrix = new SbMatrix();
        SbMatrix.transposeImpl(this.array, sbMatrix.array);
        return sbMatrix;
    }

    static {
        SbMatrix.checkSize();
    }

    public static class Factorization {
        public SbMatrix r;
        public SbVec3f s;
        public SbMatrix u;
        public SbVec3f t;
        public SbMatrix proj;
        public boolean returnedValue;
    }

    public static class Decomposition {
        public SbVec3f translation;
        public SbRotation rotation;
        public SbVec3f scaleFactor;
        public SbRotation scaleOrientation;
    }
}

