/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;

public class SbMatrix3
extends SbBasic {
    public final float[] array;

    private static native void multLeftImpl(float[] var0, float[] var1, float[] var2);

    private static native void setValueFromHandle(float[] var0, long var1);

    private static native void multVecMatrixImpl(float[] var0, float[] var1, float[] var2);

    private static native void multMatrixVecImpl(float[] var0, float[] var1, float[] var2);

    private static native void setRotateImpl(float[] var0, float[] var1);

    private static native void makeIdentityImpl(float[] var0);

    private static native void setScaleImpl1(float[] var0, float[] var1);

    private static native void setScaleImpl(float[] var0, float var1);

    private static native void identityImpl(float[] var0);

    private static native boolean equalsImpl(float[] var0, float[] var1);

    private static native void toArrayImpl(long var0, SbMatrix3[] var2);

    private static native void timesImpl(float[] var0, float[] var1, float[] var2);

    private static native void multiplyImpl(float[] var0, float[] var1);

    private static native void multRightImpl(float[] var0, float[] var1, float[] var2);

    private static native void checkSize();

    protected SbMatrix3(int n) {
        this.array = new float[n];
    }

    SbMatrix3(long l) {
        this();
        SbMatrix3.setValueFromHandle(this.array, l);
    }

    public float getValueAt(int n) {
        return this.array[n];
    }

    public void setValue(SbMatrix3 sbMatrix3) {
        this.setValue(sbMatrix3.array);
    }

    public SbMatrix3(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this(9);
        this.setValue(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public SbMatrix3(SbMatrix3 sbMatrix3) {
        this();
        this.setValue(sbMatrix3);
    }

    public SbMatrix3(float[] fArray) {
        this(9);
        if (fArray == null) {
            throw new IllegalArgumentException("Expected a non-null argument.");
        }
        if (fArray.length != 9) {
            throw new IllegalArgumentException("Expected size is 9.");
        }
        this.setValue(fArray);
    }

    public void setValueAt(int n, float f) {
        this.array[n] = f;
    }

    public SbMatrix3 setValue(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.array[0] = f;
        this.array[1] = f2;
        this.array[2] = f3;
        this.array[3] = f4;
        this.array[4] = f5;
        this.array[5] = f6;
        this.array[6] = f7;
        this.array[7] = f8;
        this.array[8] = f9;
        return this;
    }

    public SbMatrix3() {
        this(9);
        this.setValue(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public SbMatrix3 setValue(float[] fArray, int n) {
        if (n < 0 || n >= fArray.length - 9) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 9; ++i) {
            this.array[i] = fArray[n + i];
        }
        return this;
    }

    public SbMatrix3 setValue(float[] fArray) {
        for (int i = 0; i < 9; ++i) {
            this.array[i] = fArray[i];
        }
        return this;
    }

    public float[] getValue() {
        return this.array;
    }

    public void setRotate(SbRotation sbRotation) {
        SbMatrix3.setRotateImpl(this.array, sbRotation != null ? sbRotation.array : null);
    }

    public static SbMatrix3 identity() {
        SbMatrix3 sbMatrix3 = new SbMatrix3();
        SbMatrix3.identityImpl(sbMatrix3.array);
        return sbMatrix3;
    }

    public void setScale(float f) {
        SbMatrix3.setScaleImpl(this.array, f);
    }

    public void makeIdentity() {
        SbMatrix3.makeIdentityImpl(this.array);
    }

    public SbVec3f multVecMatrix(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbMatrix3.multVecMatrixImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        return sbVec3f2;
    }

    public SbVec3f multMatrixVec(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbMatrix3.multMatrixVecImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        return sbVec3f2;
    }

    public static SbMatrix3[] toArray(long l, long l2) {
        SbMatrix3[] sbMatrix3Array = new SbMatrix3[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbMatrix3Array[n] = new SbMatrix3();
            ++n;
        }
        SbMatrix3.toArrayImpl(l, sbMatrix3Array);
        return sbMatrix3Array;
    }

    public SbMatrix3 multRight(SbMatrix3 sbMatrix3) {
        SbMatrix3 sbMatrix32 = new SbMatrix3();
        SbMatrix3.multRightImpl(this.array, sbMatrix3 != null ? sbMatrix3.array : null, sbMatrix32.array);
        return sbMatrix32;
    }

    public void multiply(SbMatrix3 sbMatrix3) {
        SbMatrix3.multiplyImpl(this.array, sbMatrix3 != null ? sbMatrix3.array : null);
    }

    public SbMatrix3 multLeft(SbMatrix3 sbMatrix3) {
        SbMatrix3 sbMatrix32 = new SbMatrix3();
        SbMatrix3.multLeftImpl(this.array, sbMatrix3 != null ? sbMatrix3.array : null, sbMatrix32.array);
        return sbMatrix32;
    }

    public SbMatrix3 times(SbMatrix3 sbMatrix3) {
        SbMatrix3 sbMatrix32 = new SbMatrix3();
        SbMatrix3.timesImpl(this.array, sbMatrix3 != null ? sbMatrix3.array : null, sbMatrix32.array);
        return sbMatrix32;
    }

    public void setScale(SbVec3f sbVec3f) {
        SbMatrix3.setScaleImpl1(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SbMatrix3) {
            SbMatrix3 sbMatrix3 = (SbMatrix3)object;
            return SbMatrix3.equalsImpl(this.array, sbMatrix3.array);
        }
        return false;
    }

    static {
        SbMatrix3.checkSize();
    }
}

