/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.ProcessReferenceQueueBounded;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.lock.SoLockManager;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.sensors.SoSensorManager;
import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.vrmlnodes.SoVRMLGroup;
import com.openinventor.inventor.vrmlnodes.SoVRMLPROTODef;

public class SoDB {
    private static final int VERBOSE_LEVEL;
    static SoSensorManager sensorManager;
    static boolean useWrappedTimerSensors;
    private static SoSystemTimer m_systemTimer;
    @Deprecated
    public static final int COMPILE;
    @Deprecated
    public static final int COMPILE_AND_EXECUTE;
    @Deprecated
    public static final int AUTO_RENDER_CACHE;

    private static final native void initDatabase();

    static void init() {
    }

    public static SoSensorManager getSensorManager() {
        if (sensorManager == null) {
            sensorManager = SoDB.getNativSensorManager();
        }
        return sensorManager;
    }

    static native SoSensorManager getNativSensorManager();

    public static SoNode readNode(SoInput soInput) {
        long l = 0L;
        ObjectManager.globalLock.lock();
        try {
            l = SoDB.readNodeImpl(soInput.getNativeResourceHandle());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return l != 0L ? ObjectManager.getManagedObjectFor(SoNode.class, l) : null;
    }

    protected static native long readNodeImpl(long var0);

    @Deprecated
    public static void startInternalThreads() {
        Inventor.startInternalThreads();
    }

    @Deprecated
    public static void stopInternalThreads() {
        Inventor.stopInternalThreads();
    }

    static void initGuiThread() {
        SoDB.resetOivCppMainThreadIdNative();
        SoDB.initThreadLocalStorageNative();
    }

    private static native void resetOivCppMainThreadIdNative();

    private static native void initThreadLocalStorageNative();

    static boolean isTimerSensorWrapped() {
        return useWrappedTimerSensors;
    }

    private static void onSetSystemTimer(SoSystemTimer soSystemTimer) {
        if (m_systemTimer != null) {
            return;
        }
        m_systemTimer = soSystemTimer;
        Inventor.stopInternalThreads();
        ObjectManager.globalLock.lock();
        try {
            ProcessReferenceQueueBounded.reset();
            SoDB.restoreRealTimeUpdate();
            useWrappedTimerSensors = true;
            ProcessReferenceQueueBounded.init();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void restoreRealTimeUpdate();

    private SoDB() {
    }

    private static native boolean removePluginsDirectoryImpl(String var0);

    private static native void renameGlobalFieldImpl(String var0, String var1);

    private static native void setIvTuneAllowedImpl(boolean var0);

    private static native void setRealTimeIntervalImpl(long var0);

    private static native boolean addPluginsDirectoryImpl(String var0);

    private static native void getRealTimeIntervalImpl(long var0);

    private static native boolean getIvTuneAllowedImpl();

    private static native boolean isValidHeaderImpl(String var0);

    private static native float getLicensingVersionNumberImpl();

    private static native String getHeaderStringImpl(int var0);

    private static native void prioritizeChildrenCachingImpl(boolean var0);

    private static native long getGlobalFieldImpl(String var0);

    private static native int LicenseCheckImpl(String var0, float var1, String var2, boolean var3, String[] var4);

    private static native long createGlobalFieldImpl(String var0, String var1);

    private static native void setDelaySensorTimeoutImpl(long var0);

    private static native void writeunlockImpl();

    private static native void setRenderCacheModeImpl(int var0);

    private static native void writelockImpl();

    private static native void readlockImpl();

    private static native void setNumRenderCachesImpl(int var0);

    private static native void readunlockImpl();

    private static native int getNumRenderCachesImpl();

    private static native boolean addPluginImpl(String var0);

    private static native void getDelaySensorTimeoutImpl(long var0);

    private static native boolean removePluginImpl(String var0);

    private static native void processEventsImpl();

    private static native boolean isMultiThreadImpl();

    private static native int getRenderCacheModeImpl();

    private static native void getCurrentTimeImpl(long var0);

    private static native boolean isPrioritizedChildrenCachingImpl();

    private static native boolean readImpl(long var0, long[] var2);

    private static native boolean readPathImpl(long var0, long[] var2);

    private static native long readAllImpl(long var0);

    private static native void addConverterImpl(String var0, String var1, String var2);

    private static native String getConverterImpl(String var0, String var1);

    private static native String getVersionImpl();

    private static native void setSystemTimerImpl(long var0);

    private static native long readAllVRMLImpl(long var0);

    private static native void removeRouteImpl(long var0, String var2, long var3, String var5);

    private static native int getNumHeadersImpl();

    private static native void removeConverterImpl(String var0, String var1);

    private static native boolean readPROTOFromFileImpl1(long var0, String var2, long[] var3);

    private static native void createRouteImpl(long var0, String var2, long var3, String var5);

    @Deprecated
    public static int LicenseCheck(String string, float f, String string2) {
        return SoDB.LicenseCheck(string, f, string2, true, null);
    }

    @Deprecated
    public static int LicenseCheck(String string, float f) {
        return SoDB.LicenseCheck(string, f, null, true, null);
    }

    @Deprecated
    public static int LicenseCheck(String string, float f, String string2, boolean bl) {
        return SoDB.LicenseCheck(string, f, string2, bl, null);
    }

    public static SbTime getRealTimeInterval() {
        SbTime sbTime = new SbTime();
        ObjectManager.globalLock.lock();
        try {
            SoDB.getRealTimeIntervalImpl(sbTime.getNativeResourceHandle());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbTime;
    }

    public static int getNumHeaders() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoDB.getNumHeadersImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoField getGlobalField(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoField soField = ObjectManager.getManagedObjectFor(SoField.class, SoDB.getGlobalFieldImpl(string));
            return soField;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void renameGlobalField(String string, String string2) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.renameGlobalFieldImpl(string, string2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setRealTimeInterval(SbTime sbTime) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.setRealTimeIntervalImpl(sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static String getHeaderString(int n) {
        ObjectManager.globalLock.lock();
        try {
            String string = SoDB.getHeaderStringImpl(n);
            return string;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean isValidHeader(String string) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.isValidHeaderImpl(string);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoField createGlobalField(String string, Class<? extends Inventor> clazz) {
        String string2 = NativeTypeMap.getNativeTypeName(clazz);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoField soField = ObjectManager.getManagedObjectFor(SoField.class, SoDB.createGlobalFieldImpl(string, string2));
            return soField;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoute(SoNode soNode, String string, SoNode soNode2, String string2) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.removeRouteImpl(soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, string, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle, string2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoNode read(SoInput soInput) {
        long[] lArray = new long[1];
        boolean bl = false;
        ObjectManager.globalLock.lock();
        try {
            bl = SoDB.readImpl(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, lArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoNode.class, lArray[0]);
        }
        return null;
    }

    public static SoPath readPath(SoInput soInput) {
        long[] lArray = new long[1];
        boolean bl = false;
        ObjectManager.globalLock.lock();
        try {
            bl = SoDB.readPathImpl(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, lArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoPath.class, lArray[0]);
        }
        return null;
    }

    @Deprecated
    public static String getVersion() {
        ObjectManager.globalLock.lock();
        try {
            String string = SoDB.getVersionImpl();
            return string;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean addPlugin(String string) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.addPluginImpl(string);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setSystemTimer(SoSystemTimer soSystemTimer) {
        SoDB.onSetSystemTimer(soSystemTimer);
        ObjectManager.globalLock.lock();
        try {
            SoDB.setSystemTimerImpl(soSystemTimer != null ? soSystemTimer.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoVRMLPROTODef readPROTOFromFile(SoInput soInput, String string) {
        long[] lArray = new long[1];
        boolean bl = false;
        ObjectManager.globalLock.lock();
        try {
            bl = SoDB.readPROTOFromFileImpl1(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, string, lArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoVRMLPROTODef.class, lArray[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRoute(SoNode soNode, String string, SoNode soNode2, String string2) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.createRouteImpl(soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, string, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle, string2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoSeparator readAll(SoInput soInput) {
        ObjectManager.globalLock.lock();
        try {
            SoSeparator soSeparator = ObjectManager.getManagedObjectFor(SoSeparator.class, SoDB.readAllImpl(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soSeparator;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static SoVRMLGroup readAllVRML(SoInput soInput) {
        ObjectManager.globalLock.lock();
        try {
            SoVRMLGroup soVRMLGroup = ObjectManager.getManagedObjectFor(SoVRMLGroup.class, SoDB.readAllVRMLImpl(soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soVRMLGroup;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setDelaySensorTimeout(SbTime sbTime) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.setDelaySensorTimeoutImpl(sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean removePluginsDirectory(String string) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.removePluginsDirectoryImpl(string);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean getIvTuneAllowed() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.getIvTuneAllowedImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setIvTuneAllowed(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.setIvTuneAllowedImpl(bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SbTime getCurrentTime() {
        SbTime sbTime = new SbTime();
        ObjectManager.globalLock.lock();
        try {
            SoDB.getCurrentTimeImpl(sbTime.getNativeResourceHandle());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbTime;
    }

    public static boolean removePlugin(String string) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.removePluginImpl(string);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean addPluginsDirectory(String string) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.addPluginsDirectoryImpl(string);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static float getLicensingVersionNumber() {
        ObjectManager.globalLock.lock();
        try {
            float f = SoDB.getLicensingVersionNumberImpl();
            return f;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConverter(Class<? extends Inventor> clazz, Class<? extends Inventor> clazz2, Class<? extends Inventor> clazz3) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = NativeTypeMap.getNativeTypeName(clazz2);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        String string3 = NativeTypeMap.getNativeTypeName(clazz3);
        if (string3 == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoDB.addConverterImpl(string, string2, string3);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConverter(Class<? extends Inventor> clazz, Class<? extends Inventor> clazz2) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = NativeTypeMap.getNativeTypeName(clazz2);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoDB.removeConverterImpl(string, string2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static void prioritizeChildrenCaching(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.prioritizeChildrenCachingImpl(bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static int LicenseCheck(String string, float f, String string2, boolean bl, String[] stringArray) {
        ObjectManager.globalLock.lock();
        try {
            int n = SoDB.LicenseCheckImpl(string, f, string2, bl, stringArray);
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static boolean isPrioritizedChildrenCaching() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.isPrioritizedChildrenCachingImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean isMultiThread() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDB.isMultiThreadImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void writelock() {
        ObjectManager.globalLock.lock();
        try {
            SoDB.writelockImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void writeunlock() {
        ObjectManager.globalLock.lock();
        try {
            SoDB.writeunlockImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SbTime getDelaySensorTimeout() {
        SbTime sbTime = new SbTime();
        ObjectManager.globalLock.lock();
        try {
            SoDB.getDelaySensorTimeoutImpl(sbTime.getNativeResourceHandle());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbTime;
    }

    public static void processEvents() {
        ObjectManager.globalLock.lock();
        try {
            SoDB.processEventsImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<? extends Inventor> getConverter(Class<? extends Inventor> clazz, Class<? extends Inventor> clazz2) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = NativeTypeMap.getNativeTypeName(clazz2);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            Class<? extends Inventor> clazz3 = NativeTypeMap.getJavaClass(SoDB.getConverterImpl(string, string2));
            return clazz3;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static int getNumRenderCaches() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoDB.getNumRenderCachesImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setRenderCacheMode(RenderCacheModes renderCacheModes) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.setRenderCacheModeImpl(renderCacheModes.getValue());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static RenderCacheModes getRenderCacheMode() {
        ObjectManager.globalLock.lock();
        try {
            RenderCacheModes renderCacheModes = IntegerValuedEnumHelper.fromIntValue(RenderCacheModes.class, SoDB.getRenderCacheModeImpl());
            return renderCacheModes;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void readlock() {
        ObjectManager.globalLock.lock();
        try {
            SoDB.readlockImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void readunlock() {
        ObjectManager.globalLock.lock();
        try {
            SoDB.readunlockImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setNumRenderCaches(int n) {
        ObjectManager.globalLock.lock();
        try {
            SoDB.setNumRenderCachesImpl(n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        if (!SoLockManager.isNativeLoaded()) {
            throw new IllegalStateException("Native Open Inventor Java library not yet loaded.");
        }
        VERBOSE_LEVEL = SoPreferences.getInteger("OIV_JAVA_VERBOSE_LEVEL", 0);
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Set up native environment");
        }
        SoPreferences.initNativeEnvironment();
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Init database");
        }
        SoDB.initDatabase();
        useWrappedTimerSensors = false;
        m_systemTimer = null;
        COMPILE = RenderCacheModes.getCOMPILE();
        COMPILE_AND_EXECUTE = RenderCacheModes.getCOMPILEANDEXECUTE();
        AUTO_RENDER_CACHE = RenderCacheModes.getAUTORENDERCACHE();
    }

    public static enum RenderCacheModes implements IntegerValuedEnum
    {
        COMPILE(RenderCacheModes.getCOMPILE()),
        COMPILE_AND_EXECUTE(RenderCacheModes.getCOMPILEANDEXECUTE()),
        AUTO_RENDER_CACHE(RenderCacheModes.getAUTORENDERCACHE());

        private int value;

        private static native int getAUTORENDERCACHE();

        private RenderCacheModes(int n2) {
            this.value = n2;
        }

        private static native int getCOMPILE();

        private static native int getCOMPILEANDEXECUTE();

        @Deprecated
        public static RenderCacheModes fromValue(int n) {
            return RenderCacheModes.valueOf(n);
        }

        public static RenderCacheModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(RenderCacheModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

