/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.nodes.SoNode;

public class SoFullPath
extends SoPath {
    private static native int getInstanceIndexFromTailImpl(long var0, int var2);

    private static native long getTailImpl(long var0);

    private static native int getIndexFromTailImpl(long var0, int var2);

    private static native long getNodeFromTailImpl(long var0, int var2);

    private static native int getLengthImpl(long var0);

    private static native void popImpl(long var0);

    protected SoFullPath(Inventor.ConstructorCommand constructorCommand, long l) {
        this.initializeFields();
    }

    @Override
    public SoNode getTail() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoFullPath.getTailImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void pop() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFullPath.popImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public int getIndexFromTail(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoFullPath.getIndexFromTailImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getInstanceIndexFromTail(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoFullPath.getInstanceIndexFromTailImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SoNode getNodeFromTail(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoFullPath.getNodeFromTailImpl(this.getNativeResourceHandle(), n));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public int getLength() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoFullPath.getLengthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

