/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.devices.SoGLContext;

public class SoGLRenderToBuffer
extends Inventor {
    @Deprecated
    public static final int TEXTURE_RGB = TextureFormats.access$000();
    @Deprecated
    public static final int TEXTURE_RGBA = TextureFormats.access$100();
    @Deprecated
    public static final int TEXTURE_DEPTH = TextureFormats.access$200();
    @Deprecated
    public static final int TEXTURE_DEPTH16 = TextureFormats.access$300();
    @Deprecated
    public static final int TEXTURE_DEPTH_RGBA = TextureFormats.access$400();
    @Deprecated
    public static final int TEXTURE_RGB_FLOAT16 = TextureFormats.access$500();
    @Deprecated
    public static final int TEXTURE_RGBA_FLOAT16 = TextureFormats.access$600();
    @Deprecated
    public static final int TEXTURE_RGB_FLOAT32 = TextureFormats.access$700();
    @Deprecated
    public static final int TEXTURE_RGBA_FLOAT32 = TextureFormats.access$800();
    @Deprecated
    public static final int TEXTURE_STENCIL_INDEX8 = TextureFormats.access$900();
    @Deprecated
    public static final int TEXTURE_STENCIL_INDEX = TextureFormats.access$1000();
    @Deprecated
    public static final int TEXTURE_DEPTH_STENCIL = TextureFormats.access$1100();
    @Deprecated
    public static final int TEXTURE_UNKNOW = TextureFormats.access$1200();
    @Deprecated
    public static final int TEXTURE_1D = TextureTargets.access$1300();
    @Deprecated
    public static final int TEXTURE_2D = TextureTargets.access$1400();
    @Deprecated
    public static final int TEXTURE_3D = TextureTargets.access$1500();
    @Deprecated
    public static final int TEXTURE_CUBE_MAP = TextureTargets.access$1600();
    @Deprecated
    public static final int TEXTURE_RECTANGLE = TextureTargets.access$1700();
    @Deprecated
    public static final int TEXTURE_CUBE_MAP_POSITIVE_X = CubeMapTextureFaces.access$1800();
    @Deprecated
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Y = CubeMapTextureFaces.access$1900();
    @Deprecated
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Z = CubeMapTextureFaces.access$2000();
    @Deprecated
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_X = CubeMapTextureFaces.access$2100();
    @Deprecated
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Y = CubeMapTextureFaces.access$2200();
    @Deprecated
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Z = CubeMapTextureFaces.access$2300();
    private SoGLContext m_name_15304_setContextForSharing;

    private static native void shareCurrentContextImpl(long var0);

    private static native int getPixelFormatImpl(long var0);

    private static native void getSizeImpl(long var0, short[] var2);

    private static native void setRenderToTextureImpl(long var0, boolean var2, int var3, int var4, boolean var5, boolean var6);

    private static native void setContextForSharingImpl(long var0, long var2);

    private static native void getSizei32Impl(long var0, int[] var2);

    private static native boolean resizeImpl1(long var0, int[] var2);

    private static native void setPixelFormatImpl(long var0, int var2);

    private static native boolean resizeImpl(long var0, short[] var2);

    private static native boolean createImpl(long var0, short[] var2);

    private static native boolean selectCubeMapFaceImpl(long var0, int var2);

    private static native boolean isPBufferImpl(long var0);

    private static native void disableImpl(long var0);

    private static native boolean makeCurrentImpl(long var0);

    private static native boolean bindToTextureImpl(long var0, boolean var2, int var3);

    private static native boolean releaseTexImageImpl(long var0, boolean var2);

    private static native boolean createImpl1(long var0, int[] var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoGLRenderToBuffer(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean bindToTexture() {
        return this.bindToTexture(false, -1);
    }

    public void setRenderToTexture(boolean bl, TextureFormats textureFormats, TextureTargets textureTargets, boolean bl2) {
        this.setRenderToTexture(bl, textureFormats, textureTargets, bl2, false);
    }

    public boolean releaseTexImage() {
        return this.releaseTexImage(false);
    }

    public boolean bindToTexture(boolean bl) {
        return this.bindToTexture(bl, -1);
    }

    public void setRenderToTexture(boolean bl) {
        this.setRenderToTexture(bl, TextureFormats.valueOf(TextureFormats.TEXTURE_RGB.getValue()), TextureTargets.valueOf(TextureTargets.TEXTURE_2D.getValue()), false, false);
    }

    public void setRenderToTexture(boolean bl, TextureFormats textureFormats, TextureTargets textureTargets) {
        this.setRenderToTexture(bl, textureFormats, textureTargets, false, false);
    }

    public void setRenderToTexture(boolean bl, TextureFormats textureFormats) {
        this.setRenderToTexture(bl, textureFormats, TextureTargets.valueOf(TextureTargets.TEXTURE_2D.getValue()), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderToTexture(boolean bl, TextureFormats textureFormats, TextureTargets textureTargets, boolean bl2, boolean bl3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderToBuffer.setRenderToTextureImpl(this.getNativeResourceHandle(), bl, textureFormats.getValue(), textureTargets.getValue(), bl2, bl3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getPixelFormat() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGLRenderToBuffer.getPixelFormatImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean resize(SbVec2s sbVec2s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderToBuffer.resizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void shareCurrentContext() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderToBuffer.shareCurrentContextImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setContextForSharing(SoGLContext soGLContext) {
        this.m_name_15304_setContextForSharing = soGLContext;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderToBuffer.setContextForSharingImpl(this.getNativeResourceHandle(), soGLContext != null ? soGLContext.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2i32 getSizei32() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderToBuffer.getSizei32Impl(this.getNativeResourceHandle(), sbVec2i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2i32;
    }

    public SbVec2s getSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderToBuffer.getSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public void setPixelFormat(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderToBuffer.setPixelFormatImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean resize(SbVec2i32 sbVec2i32) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderToBuffer.resizeImpl1(this.getNativeResourceHandle(), sbVec2i32 != null ? sbVec2i32.array : null);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean create(SbVec2i32 sbVec2i32) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderToBuffer.createImpl1(this.getNativeResourceHandle(), sbVec2i32 != null ? sbVec2i32.array : null);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean selectCubeMapFace(CubeMapTextureFaces cubeMapTextureFaces) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderToBuffer.selectCubeMapFaceImpl(this.getNativeResourceHandle(), cubeMapTextureFaces.getValue());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean create(SbVec2s sbVec2s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderToBuffer.createImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isPBuffer() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderToBuffer.isPBufferImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disable() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderToBuffer.disableImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bindToTexture(boolean bl, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoGLRenderToBuffer.bindToTextureImpl(this.getNativeResourceHandle(), bl, n);
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean makeCurrent() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderToBuffer.makeCurrentImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean releaseTexImage(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoGLRenderToBuffer.releaseTexImageImpl(this.getNativeResourceHandle(), bl);
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum CubeMapTextureFaces implements IntegerValuedEnum
    {
        TEXTURE_CUBE_MAP_POSITIVE_X(CubeMapTextureFaces.getTEXTURECUBEMAPPOSITIVEX()),
        TEXTURE_CUBE_MAP_POSITIVE_Y(CubeMapTextureFaces.getTEXTURECUBEMAPPOSITIVEY()),
        TEXTURE_CUBE_MAP_POSITIVE_Z(CubeMapTextureFaces.getTEXTURECUBEMAPPOSITIVEZ()),
        TEXTURE_CUBE_MAP_NEGATIVE_X(CubeMapTextureFaces.getTEXTURECUBEMAPNEGATIVEX()),
        TEXTURE_CUBE_MAP_NEGATIVE_Y(CubeMapTextureFaces.getTEXTURECUBEMAPNEGATIVEY()),
        TEXTURE_CUBE_MAP_NEGATIVE_Z(CubeMapTextureFaces.getTEXTURECUBEMAPNEGATIVEZ());

        private int value;

        private static native int getTEXTURECUBEMAPNEGATIVEY();

        private static native int getTEXTURECUBEMAPNEGATIVEZ();

        private CubeMapTextureFaces(int n2) {
            this.value = n2;
        }

        private static native int getTEXTURECUBEMAPNEGATIVEX();

        private static native int getTEXTURECUBEMAPPOSITIVEX();

        private static native int getTEXTURECUBEMAPPOSITIVEY();

        private static native int getTEXTURECUBEMAPPOSITIVEZ();

        @Deprecated
        public static CubeMapTextureFaces fromValue(int n) {
            return CubeMapTextureFaces.valueOf(n);
        }

        public static CubeMapTextureFaces valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CubeMapTextureFaces.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$1800() {
            return CubeMapTextureFaces.getTEXTURECUBEMAPPOSITIVEX();
        }

        static /* synthetic */ int access$1900() {
            return CubeMapTextureFaces.getTEXTURECUBEMAPPOSITIVEY();
        }

        static /* synthetic */ int access$2000() {
            return CubeMapTextureFaces.getTEXTURECUBEMAPPOSITIVEZ();
        }

        static /* synthetic */ int access$2100() {
            return CubeMapTextureFaces.getTEXTURECUBEMAPNEGATIVEX();
        }

        static /* synthetic */ int access$2200() {
            return CubeMapTextureFaces.getTEXTURECUBEMAPNEGATIVEY();
        }

        static /* synthetic */ int access$2300() {
            return CubeMapTextureFaces.getTEXTURECUBEMAPNEGATIVEZ();
        }
    }

    public static enum TextureTargets implements IntegerValuedEnum
    {
        TEXTURE_1D(TextureTargets.getTEXTURE1D()),
        TEXTURE_2D(TextureTargets.getTEXTURE2D()),
        TEXTURE_3D(TextureTargets.getTEXTURE3D()),
        TEXTURE_CUBE_MAP(TextureTargets.getTEXTURECUBEMAP()),
        TEXTURE_RECTANGLE(TextureTargets.getTEXTURERECTANGLE());

        private int value;

        private static native int getTEXTURECUBEMAP();

        private static native int getTEXTURERECTANGLE();

        private TextureTargets(int n2) {
            this.value = n2;
        }

        private static native int getTEXTURE1D();

        private static native int getTEXTURE2D();

        private static native int getTEXTURE3D();

        @Deprecated
        public static TextureTargets fromValue(int n) {
            return TextureTargets.valueOf(n);
        }

        public static TextureTargets valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(TextureTargets.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$1300() {
            return TextureTargets.getTEXTURE1D();
        }

        static /* synthetic */ int access$1400() {
            return TextureTargets.getTEXTURE2D();
        }

        static /* synthetic */ int access$1500() {
            return TextureTargets.getTEXTURE3D();
        }

        static /* synthetic */ int access$1600() {
            return TextureTargets.getTEXTURECUBEMAP();
        }

        static /* synthetic */ int access$1700() {
            return TextureTargets.getTEXTURERECTANGLE();
        }
    }

    public static enum TextureFormats implements IntegerValuedEnum
    {
        TEXTURE_RGB(TextureFormats.getTEXTURERGB()),
        TEXTURE_RGBA(TextureFormats.getTEXTURERGBA()),
        TEXTURE_DEPTH(TextureFormats.getTEXTUREDEPTH()),
        TEXTURE_DEPTH16(TextureFormats.getTEXTUREDEPTH16()),
        TEXTURE_DEPTH_RGBA(TextureFormats.getTEXTUREDEPTHRGBA()),
        TEXTURE_RGB_FLOAT16(TextureFormats.getTEXTURERGBFLOAT16()),
        TEXTURE_RGBA_FLOAT16(TextureFormats.getTEXTURERGBAFLOAT16()),
        TEXTURE_RGB_FLOAT32(TextureFormats.getTEXTURERGBFLOAT32()),
        TEXTURE_RGBA_FLOAT32(TextureFormats.getTEXTURERGBAFLOAT32()),
        TEXTURE_STENCIL_INDEX8(TextureFormats.getTEXTURESTENCILINDEX8()),
        TEXTURE_STENCIL_INDEX(TextureFormats.getTEXTURESTENCILINDEX()),
        TEXTURE_DEPTH_STENCIL(TextureFormats.getTEXTUREDEPTHSTENCIL()),
        TEXTURE_UNKNOW(TextureFormats.getTEXTUREUNKNOW());

        private int value;

        private static native int getTEXTURESTENCILINDEX8();

        private static native int getTEXTURERGBAFLOAT32();

        private static native int getTEXTURERGBFLOAT32();

        private static native int getTEXTURESTENCILINDEX();

        private TextureFormats(int n2) {
            this.value = n2;
        }

        private static native int getTEXTUREUNKNOW();

        private static native int getTEXTUREDEPTHSTENCIL();

        private static native int getTEXTUREDEPTH();

        private static native int getTEXTURERGBA();

        private static native int getTEXTURERGB();

        private static native int getTEXTUREDEPTH16();

        private static native int getTEXTURERGBAFLOAT16();

        private static native int getTEXTURERGBFLOAT16();

        private static native int getTEXTUREDEPTHRGBA();

        @Deprecated
        public static TextureFormats fromValue(int n) {
            return TextureFormats.valueOf(n);
        }

        public static TextureFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(TextureFormats.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return TextureFormats.getTEXTURERGB();
        }

        static /* synthetic */ int access$100() {
            return TextureFormats.getTEXTURERGBA();
        }

        static /* synthetic */ int access$200() {
            return TextureFormats.getTEXTUREDEPTH();
        }

        static /* synthetic */ int access$300() {
            return TextureFormats.getTEXTUREDEPTH16();
        }

        static /* synthetic */ int access$400() {
            return TextureFormats.getTEXTUREDEPTHRGBA();
        }

        static /* synthetic */ int access$500() {
            return TextureFormats.getTEXTURERGBFLOAT16();
        }

        static /* synthetic */ int access$600() {
            return TextureFormats.getTEXTURERGBAFLOAT16();
        }

        static /* synthetic */ int access$700() {
            return TextureFormats.getTEXTURERGBFLOAT32();
        }

        static /* synthetic */ int access$800() {
            return TextureFormats.getTEXTURERGBAFLOAT32();
        }

        static /* synthetic */ int access$900() {
            return TextureFormats.getTEXTURESTENCILINDEX8();
        }

        static /* synthetic */ int access$1000() {
            return TextureFormats.getTEXTURESTENCILINDEX();
        }

        static /* synthetic */ int access$1100() {
            return TextureFormats.getTEXTUREDEPTHSTENCIL();
        }

        static /* synthetic */ int access$1200() {
            return TextureFormats.getTEXTUREUNKNOW();
        }
    }
}

