/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoInputParameters;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class SoInput
extends Inventor {
    public static final String DIRECTORIES_SEPARATOR = File.pathSeparator;
    private long nativBuff = 0L;
    @Deprecated
    public static final int OpenInventor = FileTypes.access$000();
    @Deprecated
    public static final int OpenFlight = FileTypes.access$100();
    @Deprecated
    public static final int DXF = FileTypes.access$200();
    @Deprecated
    public static final int IGES = FileTypes.access$300();
    @Deprecated
    public static final int STEP = FileTypes.access$400();
    @Deprecated
    public static final int CATIA5 = FileTypes.access$500();
    @Deprecated
    public static final int ALL = FileTypes.access$600();
    private SoInputParameters m_parameters_setInputParameters;

    public void setBuffer(byte[] byArray) {
        this.setBufferImpl(this.getNativeResourceHandle(), byArray, byArray.length);
    }

    public void setBuffer(byte[] byArray, int n) {
        this.setBufferImpl(this.getNativeResourceHandle(), byArray, n);
    }

    private native void setBufferImpl(long var1, byte[] var3, int var4);

    public void setBuffer(String string, int n) {
        this.setBufferImpl2(this.getNativeResourceHandle(), string, n);
    }

    private native void setBufferImpl2(long var1, String var3, int var4);

    public boolean openURL(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                return false;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n2 = 4096;
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[2 * n2];
            int n3 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, n2)) > 0) {
                int n4 = n3 + n;
                if (n4 > byArray2.length) {
                    byte[] byArray3 = new byte[Math.max(byArray2.length << 1, n4)];
                    System.arraycopy(byArray2, 0, byArray3, 0, n3);
                    byArray2 = byArray3;
                }
                System.arraycopy(byArray, 0, byArray2, n3, n);
                n3 = n4;
            }
            if (n3 <= 0) {
                return false;
            }
            this.setBuffer(byArray2, n3);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getClass().getName() + " in " + this.getClass().getName() + ".openURL(" + uRL + ")");
            System.err.println(iOException.getMessage());
            return false;
        }
        return this.isValidBuffer();
    }

    private static native void setInputParametersImpl(long var0, long var2);

    private static native void updateReadPercentImpl(long var0, double var2);

    private static native long getInputParametersImpl(long var0);

    private static native int getCurFileTypeImpl(long var0);

    private static native boolean findAbsolutePathImpl(String var0, String[] var1);

    private static native float getIVVersionImpl(long var0);

    private static native String getCurStringFileNameImpl(long var0);

    private static native String getCurFileNameImpl(long var0);

    private static native int getNumBytesReadImpl(long var0);

    private static native String getHeaderImpl(long var0);

    private static native void addEnvDirectoriesLastImpl(String var0, String var1);

    private static native void addEnvDirectoriesFirstImpl1(String var0, String var1);

    private static native void removeDirectoryImpl1(String var0);

    private static native void setCurFileTypeImpl(long var0, int var2);

    private static native void clearDirectoriesImpl();

    private static native void addDirectoryLastImpl(String var0);

    private static native void addDirectoryFirstImpl1(String var0);

    private static native void closeFileImpl(long var0);

    private static native boolean pushFileImpl1(long var0, String var2);

    private static native boolean openFileImpl(long var0, String var2, boolean var3, boolean var4);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoInput.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean isValidBufferImpl(long var0);

    private static native boolean isValidFileImpl(long var0);

    private static native long ctorImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoInput(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean openFile(String string) {
        return this.openFile(string, false, false);
    }

    public boolean openFile(String string, boolean bl) {
        return this.openFile(string, bl, false);
    }

    public static void addEnvDirectoriesLast(String string) {
        SoInput.addEnvDirectoriesLast(string, DIRECTORIES_SEPARATOR);
    }

    public static void addEnvDirectoriesFirst(String string) {
        SoInput.addEnvDirectoriesFirst(string, DIRECTORIES_SEPARATOR);
    }

    public void closeFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoInput.closeFileImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isValidFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoInput.isValidFileImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public void setCurFileType(FileTypes fileTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoInput.setCurFileTypeImpl(this.getNativeResourceHandle(), fileTypes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isValidBuffer() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoInput.isValidBufferImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openFile(String string, boolean bl, boolean bl2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl3 = SoInput.openFileImpl(this.getNativeResourceHandle(), string, bl, bl2);
            return bl3;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoInput() {
        this(Inventor.ConstructorCommand.CreateInstance, SoInput.ctorImplSync());
    }

    public boolean pushFile(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoInput.pushFileImpl1(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void addEnvDirectoriesFirst(String string, String string2) {
        ObjectManager.globalLock.lock();
        try {
            SoInput.addEnvDirectoriesFirstImpl1(string, string2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void addEnvDirectoriesLast(String string, String string2) {
        ObjectManager.globalLock.lock();
        try {
            SoInput.addEnvDirectoriesLastImpl(string, string2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void addDirectoryLast(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoInput.addDirectoryLastImpl(string);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void clearDirectories() {
        ObjectManager.globalLock.lock();
        try {
            SoInput.clearDirectoriesImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static String findAbsolutePath(String string) {
        String[] stringArray = new String[1];
        boolean bl = false;
        ObjectManager.globalLock.lock();
        try {
            bl = SoInput.findAbsolutePathImpl(string, stringArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        if (bl) {
            return stringArray[0];
        }
        return null;
    }

    public static void removeDirectory(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoInput.removeDirectoryImpl1(string);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void addDirectoryFirst(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoInput.addDirectoryFirstImpl1(string);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public String getHeader() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoInput.getHeaderImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getIVVersion() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoInput.getIVVersionImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumBytesRead() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoInput.getNumBytesReadImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getCurFileName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoInput.getCurFileNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getCurStringFileName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoInput.getCurStringFileNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public FileTypes getCurFileType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            FileTypes fileTypes = IntegerValuedEnumHelper.fromIntValue(FileTypes.class, SoInput.getCurFileTypeImpl(this.getNativeResourceHandle()));
            return fileTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoInputParameters getInputParameters() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoInputParameters soInputParameters = ObjectManager.getManagedObjectFor(SoInputParameters.class, SoInput.getInputParametersImpl(this.getNativeResourceHandle()));
            return soInputParameters;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void updateReadPercent(double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoInput.updateReadPercentImpl(this.getNativeResourceHandle(), d);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setInputParameters(SoInputParameters soInputParameters) {
        this.m_parameters_setInputParameters = soInputParameters;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoInput.setInputParametersImpl(this.getNativeResourceHandle(), soInputParameters != null ? soInputParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum FileTypes implements IntegerValuedEnum
    {
        OpenInventor(FileTypes.getOpenInventor()),
        OpenFlight(FileTypes.getOpenFlight()),
        DXF(FileTypes.getDXF()),
        IGES(FileTypes.getIGES()),
        STEP(FileTypes.getSTEP()),
        CATIA5(FileTypes.getCATIA5()),
        ALL(FileTypes.getALL());

        private int value;

        private static native int getCATIA5();

        private static native int getSTEP();

        private FileTypes(int n2) {
            this.value = n2;
        }

        private static native int getALL();

        private static native int getOpenFlight();

        private static native int getOpenInventor();

        private static native int getIGES();

        private static native int getDXF();

        @Deprecated
        public static FileTypes fromValue(int n) {
            return FileTypes.valueOf(n);
        }

        public static FileTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(FileTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return FileTypes.getOpenInventor();
        }

        static /* synthetic */ int access$100() {
            return FileTypes.getOpenFlight();
        }

        static /* synthetic */ int access$200() {
            return FileTypes.getDXF();
        }

        static /* synthetic */ int access$300() {
            return FileTypes.getIGES();
        }

        static /* synthetic */ int access$400() {
            return FileTypes.getSTEP();
        }

        static /* synthetic */ int access$500() {
            return FileTypes.getCATIA5();
        }

        static /* synthetic */ int access$600() {
            return FileTypes.getALL();
        }
    }
}

