/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoOffscreenTileObserver;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.helpers.SbGLShareContext;
import com.openinventor.inventor.image.SoRasterImageRW;
import com.openinventor.inventor.nodes.SoFullSceneAntialiasing;
import com.openinventor.inventor.nodes.SoNode;

public class SoOffscreenRenderer
extends Inventor {
    @Deprecated
    public static final int LUMINANCE = Components.access$000();
    @Deprecated
    public static final int LUMINANCE_TRANSPARENCY = Components.access$100();
    @Deprecated
    public static final int RGB = Components.access$200();
    @Deprecated
    public static final int RGBA = Components.access$300();
    @Deprecated
    public static final int RGB_TRANSPARENCY = Components.access$400();
    @Deprecated
    public static final int NO_COMPRESSION = TIFFCompressionModes.access$500();
    @Deprecated
    public static final int PACKBITS_COMPRESSION = TIFFCompressionModes.access$600();
    @Deprecated
    public static final int RGB_BUFFER = BufferTypes.access$700();
    @Deprecated
    public static final int JPEG_BUFFER = BufferTypes.access$800();
    @Deprecated
    public static final int CONTINUE = AbortCodes.access$900();
    @Deprecated
    public static final int ABORT = AbortCodes.access$1000();
    private SoGLRenderAction m_ra_setGLRenderAction;
    private SoOffscreenTileObserver m_tileObserver_setTileObserver;

    public boolean writeToJPEGBuffer(float f) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoOffscreenRenderer.writeToJPEGBufferImpl(this.getNativeResourceHandle(), f);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean writeToJPEGBufferImpl(long var0, float var2);

    private static native long getBufferSizeImpl(long var0, int var2);

    private static native byte[] getBufferImpl(long var0, int var2);

    private static native void setRegioni32Impl(long var0, int[] var2, int[] var3);

    private static native boolean writeToRGBImpl(long var0, String var2);

    private static native float getScreenPixelsPerInchImpl();

    private static native boolean writeToPostScriptImpl(long var0, String var2);

    private static native void getMaximumResolutionImpl(short[] var0);

    private static native void setRegionImpl(long var0, short[] var2, short[] var3);

    private static native void setGLRenderActionImpl(long var0, long var2);

    private static native void getBackgroundColorImpl(long var0, float[] var2);

    private static native void setBackgroundColorImpl(long var0, float[] var2);

    private static native boolean renderImpl1(long var0, long var2);

    private static native boolean renderImpl(long var0, long var2);

    private static native long getGLRenderActionImpl(long var0);

    private static native void getShareContextImpl(long var0, long var2);

    private static native int getColorDepthImpl(long var0);

    private static native boolean writeToPNGImpl(long var0, String var2);

    private static native void setPbufferEnableImpl(long var0, boolean var2);

    private static native void setColorDepthImpl(long var0, int var2);

    private static native boolean writeToRasterImpl(long var0, String var2, long var3);

    private static native void setTileObserverImpl(long var0, long var2);

    private static native boolean writeToBMPImpl(long var0, String var2);

    private static native boolean getPbufferEnableImpl(long var0);

    private static native boolean isFullSceneAntialiasingImpl(long var0);

    private static native void setShareContextImpl(long var0, long var2);

    private static native boolean writeToPostScriptImpl1(long var0, String var2, float[] var3);

    private static native boolean writeToTIFFImpl(long var0, String var2, int var3);

    private static native boolean writeToJPEGImpl(long var0, String var2, float var3);

    private static native void setFullSceneAntialiasingImpl(long var0, boolean var2, float var3, int var4);

    private static native void setMaxTileSizeImpl(long var0, short[] var2);

    private static native int getComponentsImpl(long var0);

    private static native int getNumEdgePixelsImpl(long var0);

    private static native void getMaxTileSizeImpl(long var0, short[] var2);

    private static native void getMaxSubimageImpl(long var0, short[] var2);

    private static native void setMaxSubimageImpl(long var0, short[] var2);

    private static long ctorImpl1Sync(SoGLRenderAction soGLRenderAction) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoOffscreenRenderer.ctorImpl1(soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setBackgroundColorRGBAImpl(long var0, float[] var2);

    private static native long ctorImpl(long var0);

    private static native void setNumEdgePixelsImpl(long var0, int var2);

    private static native void getBackgroundColorRGBAImpl(long var0, float[] var2);

    private static native boolean getFullSceneAntialiasingQualityImpl(long var0, float[] var2);

    private static long ctorImplSync(SbViewportRegion sbViewportRegion) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoOffscreenRenderer.ctorImpl(sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setViewportRegionImpl(long var0, long var2);

    private static native void setComponentsImpl(long var0, int var2);

    private static native void getViewportRegionImpl(long var0, long var2);

    private static native long ctorImpl1(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoOffscreenRenderer(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public byte[] getBuffer() {
        return this.getBuffer(BufferTypes.valueOf(BufferTypes.RGB_BUFFER.getValue()));
    }

    public boolean writeToJPEG(String string) {
        return this.writeToJPEG(string, 1.0f);
    }

    public boolean writeToTIFF(String string) {
        return this.writeToTIFF(string, TIFFCompressionModes.valueOf(TIFFCompressionModes.PACKBITS_COMPRESSION.getValue()));
    }

    public void setFullSceneAntialiasing(boolean bl, float f) {
        this.setFullSceneAntialiasing(bl, f, SoFullSceneAntialiasing.ALL);
    }

    public void setFullSceneAntialiasing(boolean bl) {
        this.setFullSceneAntialiasing(bl, -1.0f, SoFullSceneAntialiasing.ALL);
    }

    public long getBufferSize() {
        return this.getBufferSize(BufferTypes.valueOf(BufferTypes.RGB_BUFFER.getValue()));
    }

    public void setBackgroundColor(SbColor sbColor) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setBackgroundColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_ra_setGLRenderAction = soGLRenderAction;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setGLRenderActionImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColor getBackgroundColor() {
        SbColor sbColor = new SbColor();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.getBackgroundColorImpl(this.getNativeResourceHandle(), sbColor.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColor;
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbViewportRegion;
    }

    public void setBackgroundColorRGBA(SbColorRGBA sbColorRGBA) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setBackgroundColorRGBAImpl(this.getNativeResourceHandle(), sbColorRGBA != null ? sbColorRGBA.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColorRGBA getBackgroundColorRGBA() {
        SbColorRGBA sbColorRGBA = new SbColorRGBA();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.getBackgroundColorRGBAImpl(this.getNativeResourceHandle(), sbColorRGBA.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColorRGBA;
    }

    public int getNumEdgePixels() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoOffscreenRenderer.getNumEdgePixelsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoOffscreenRenderer(SoGLRenderAction soGLRenderAction) {
        this(Inventor.ConstructorCommand.CreateInstance, SoOffscreenRenderer.ctorImpl1Sync(soGLRenderAction));
    }

    public void setComponents(Components components) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setComponentsImpl(this.getNativeResourceHandle(), components.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoOffscreenRenderer(SbViewportRegion sbViewportRegion) {
        this(Inventor.ConstructorCommand.CreateInstance, SoOffscreenRenderer.ctorImplSync(sbViewportRegion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToRaster(String string, SoRasterImageRW soRasterImageRW) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToRasterImpl(this.getNativeResourceHandle(), string, soRasterImageRW != null ? soRasterImageRW.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getFullSceneAntialiasingQuality() {
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoOffscreenRenderer.getFullSceneAntialiasingQualityImpl(this.getNativeResourceHandle(), fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        throw new UnsupportedOperationException();
    }

    public Components getComponents() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Components components = IntegerValuedEnumHelper.fromIntValue(Components.class, SoOffscreenRenderer.getComponentsImpl(this.getNativeResourceHandle()));
            return components;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2s getMaxSubimage() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.getMaxSubimageImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public void setNumEdgePixels(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setNumEdgePixelsImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2s getMaxTileSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.getMaxTileSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public void setMaxTileSize(SbVec2s sbVec2s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setMaxTileSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setMaxSubimage(SbVec2s sbVec2s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setMaxSubimageImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToJPEG(String string, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToJPEGImpl(this.getNativeResourceHandle(), string, f);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFullSceneAntialiasing(boolean bl, float f, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setFullSceneAntialiasingImpl(this.getNativeResourceHandle(), bl, f, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getPbufferEnable() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.getPbufferEnableImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToTIFF(String string, TIFFCompressionModes tIFFCompressionModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToTIFFImpl(this.getNativeResourceHandle(), string, tIFFCompressionModes.getValue());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isFullSceneAntialiasing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.isFullSceneAntialiasingImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean writeToPNG(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToPNGImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setColorDepth(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setColorDepthImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTileObserver(SoOffscreenTileObserver soOffscreenTileObserver) {
        this.m_tileObserver_setTileObserver = soOffscreenTileObserver;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setTileObserverImpl(this.getNativeResourceHandle(), soOffscreenTileObserver != null ? soOffscreenTileObserver.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPbufferEnable(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setPbufferEnableImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getColorDepth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoOffscreenRenderer.getColorDepthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean writeToBMP(String string) {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new UnsupportedOperationException("Unsupported platform.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToBMPImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setShareContext(SbGLShareContext sbGLShareContext) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext != null ? sbGLShareContext.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRegion(SbVec2s sbVec2s, SbVec2s sbVec2s2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setRegionImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null, sbVec2s2 != null ? sbVec2s2.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRegioni32(SbVec2i32 sbVec2i32, SbVec2i32 sbVec2i322) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.setRegioni32Impl(this.getNativeResourceHandle(), sbVec2i32 != null ? sbVec2i32.array : null, sbVec2i322 != null ? sbVec2i322.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public byte[] getBuffer(BufferTypes bufferTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            byte[] byArray = SoOffscreenRenderer.getBufferImpl(this.getNativeResourceHandle(), bufferTypes.getValue());
            return byArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoGLRenderAction getGLRenderAction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderAction soGLRenderAction = ObjectManager.getManagedObjectFor(SoGLRenderAction.class, SoOffscreenRenderer.getGLRenderActionImpl(this.getNativeResourceHandle()));
            return soGLRenderAction;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean render(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.renderImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean render(SoPath soPath) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.renderImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBufferSize(BufferTypes bufferTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoOffscreenRenderer.getBufferSizeImpl(this.getNativeResourceHandle(), bufferTypes.getValue());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static float getScreenPixelsPerInch() {
        ObjectManager.globalLock.lock();
        try {
            float f = SoOffscreenRenderer.getScreenPixelsPerInchImpl();
            return f;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToPostScript(String string, SbVec2f sbVec2f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToPostScriptImpl1(this.getNativeResourceHandle(), string, sbVec2f != null ? sbVec2f.array : null);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbGLShareContext getShareContext() {
        SbGLShareContext sbGLShareContext = new SbGLShareContext();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOffscreenRenderer.getShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbGLShareContext;
    }

    public boolean writeToRGB(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToRGBImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean writeToPostScript(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoOffscreenRenderer.writeToPostScriptImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SbVec2s getMaximumResolution() {
        SbVec2s sbVec2s = new SbVec2s();
        ObjectManager.globalLock.lock();
        try {
            SoOffscreenRenderer.getMaximumResolutionImpl(sbVec2s.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbVec2s;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum AbortCodes implements IntegerValuedEnum
    {
        CONTINUE(AbortCodes.getCONTINUE()),
        ABORT(AbortCodes.getABORT());

        private int value;

        private AbortCodes(int n2) {
            this.value = n2;
        }

        private static native int getABORT();

        private static native int getCONTINUE();

        @Deprecated
        public static AbortCodes fromValue(int n) {
            return AbortCodes.valueOf(n);
        }

        public static AbortCodes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(AbortCodes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$900() {
            return AbortCodes.getCONTINUE();
        }

        static /* synthetic */ int access$1000() {
            return AbortCodes.getABORT();
        }
    }

    public static enum BufferTypes implements IntegerValuedEnum
    {
        RGB_BUFFER(BufferTypes.getRGBBUFFER()),
        JPEG_BUFFER(BufferTypes.getJPEGBUFFER());

        private int value;

        private BufferTypes(int n2) {
            this.value = n2;
        }

        private static native int getJPEGBUFFER();

        private static native int getRGBBUFFER();

        @Deprecated
        public static BufferTypes fromValue(int n) {
            return BufferTypes.valueOf(n);
        }

        public static BufferTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(BufferTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$700() {
            return BufferTypes.getRGBBUFFER();
        }

        static /* synthetic */ int access$800() {
            return BufferTypes.getJPEGBUFFER();
        }
    }

    public static enum TIFFCompressionModes implements IntegerValuedEnum
    {
        NO_COMPRESSION(TIFFCompressionModes.getNOCOMPRESSION()),
        PACKBITS_COMPRESSION(TIFFCompressionModes.getPACKBITSCOMPRESSION());

        private int value;

        private TIFFCompressionModes(int n2) {
            this.value = n2;
        }

        private static native int getPACKBITSCOMPRESSION();

        private static native int getNOCOMPRESSION();

        @Deprecated
        public static TIFFCompressionModes fromValue(int n) {
            return TIFFCompressionModes.valueOf(n);
        }

        public static TIFFCompressionModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(TIFFCompressionModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$500() {
            return TIFFCompressionModes.getNOCOMPRESSION();
        }

        static /* synthetic */ int access$600() {
            return TIFFCompressionModes.getPACKBITSCOMPRESSION();
        }
    }

    public static enum Components implements IntegerValuedEnum
    {
        LUMINANCE(Components.getLUMINANCE()),
        LUMINANCE_TRANSPARENCY(Components.getLUMINANCETRANSPARENCY()),
        RGB(Components.getRGB()),
        RGBA(Components.getRGBA()),
        RGB_TRANSPARENCY(Components.getRGBTRANSPARENCY());

        private int value;

        private static native int getRGBA();

        private static native int getRGBTRANSPARENCY();

        private Components(int n2) {
            this.value = n2;
        }

        private static native int getLUMINANCE();

        private static native int getLUMINANCETRANSPARENCY();

        private static native int getRGB();

        @Deprecated
        public static Components fromValue(int n) {
            return Components.valueOf(n);
        }

        public static Components valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Components.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return Components.getLUMINANCE();
        }

        static /* synthetic */ int access$100() {
            return Components.getLUMINANCETRANSPARENCY();
        }

        static /* synthetic */ int access$200() {
            return Components.getRGB();
        }

        static /* synthetic */ int access$300() {
            return Components.getRGBA();
        }

        static /* synthetic */ int access$400() {
            return Components.getRGBTRANSPARENCY();
        }
    }
}

