/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec4f;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.details.SoDetail;
import com.openinventor.inventor.nodes.SoNode;

public class SoPickedPoint
extends Inventor {
    private SoDetail m_detail_setDetail;

    private static native boolean isOnGeometryImpl(long var0);

    private static native void setObjectTextureCoordsImpl(long var0, float[] var2);

    private static native long getDetailImpl(long var0, long var2);

    private static native void setMaterialIndexImpl(long var0, int var2);

    private static native int getMaterialIndexImpl(long var0);

    private static native void setDetailImpl(long var0, long var2, long var4);

    private static native long getPathImpl(long var0);

    private static native void setObjectNormalImpl(long var0, float[] var2);

    private static native void getObjectToImageImpl(long var0, long var2, float[] var4);

    private static native void getImageToObjectImpl(long var0, long var2, float[] var4);

    private static native void getObjectPointImpl(long var0, long var2, float[] var4);

    private static native void getObjectNormalImpl(long var0, long var2, float[] var4);

    private static native void getObjectToWorldImpl(long var0, long var2, float[] var4);

    private static native void getObjectTextureCoordsImpl(long var0, long var2, float[] var4);

    private static native void getWorldToObjectImpl(long var0, long var2, float[] var4);

    private static native long ctorImpl1(long var0);

    private static long ctorImpl1Sync(SoPickedPoint soPickedPoint) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoPickedPoint.ctorImpl1(soPickedPoint != null ? soPickedPoint.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoPickedPoint.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native long copyImpl(long var0);

    private static native void getTextureCoordsImpl(long var0, float[] var2);

    private static native void getNormalImpl(long var0, float[] var2);

    private static native void getPointImpl(long var0, float[] var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoPickedPoint(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoDetail getDetail() {
        return this.getDetail(null);
    }

    public SbMatrix getObjectToWorld() {
        return this.getObjectToWorld(null);
    }

    public SbVec3f getObjectPoint() {
        return this.getObjectPoint(null);
    }

    public SbMatrix getImageToObject() {
        return this.getImageToObject(null);
    }

    public SbVec4f getObjectTextureCoords() {
        return this.getObjectTextureCoords(null);
    }

    public SbVec3f getObjectNormal() {
        return this.getObjectNormal(null);
    }

    public SbMatrix getObjectToImage() {
        return this.getObjectToImage(null);
    }

    public SbMatrix getWorldToObject() {
        return this.getWorldToObject(null);
    }

    public SbVec3f getPoint() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getPointImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SbVec3f getObjectNormal(SoNode soNode) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getObjectNormalImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SoPickedPoint copy() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint soPickedPoint = ObjectManager.getManagedObjectFor(SoPickedPoint.class, SoPickedPoint.copyImpl(this.getNativeResourceHandle()));
            return soPickedPoint;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPickedPoint() {
        this(Inventor.ConstructorCommand.CreateInstance, SoPickedPoint.ctorImplSync());
    }

    public SoPickedPoint(SoPickedPoint soPickedPoint) {
        this(Inventor.ConstructorCommand.CreateInstance, SoPickedPoint.ctorImpl1Sync(soPickedPoint));
    }

    public void setObjectNormal(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.setObjectNormalImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbMatrix getWorldToObject(SoNode soNode) {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getWorldToObjectImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public void setObjectTextureCoords(SbVec4f sbVec4f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.setObjectTextureCoordsImpl(this.getNativeResourceHandle(), sbVec4f != null ? sbVec4f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbMatrix getObjectToWorld(SoNode soNode) {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getObjectToWorldImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public SbMatrix getImageToObject(SoNode soNode) {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getImageToObjectImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public SbVec3f getObjectPoint(SoNode soNode) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getObjectPointImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SbVec4f getObjectTextureCoords(SoNode soNode) {
        SbVec4f sbVec4f = new SbVec4f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getObjectTextureCoordsImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec4f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec4f;
    }

    public SbMatrix getObjectToImage(SoNode soNode) {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getObjectToImageImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public int getMaterialIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoPickedPoint.getMaterialIndexImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getPath() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoPickedPoint.getPathImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f getNormal() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getNormalImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SbVec4f getTextureCoords() {
        SbVec4f sbVec4f = new SbVec4f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.getTextureCoordsImpl(this.getNativeResourceHandle(), sbVec4f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec4f;
    }

    public void setMaterialIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.setMaterialIndexImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoDetail getDetail(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDetail soDetail = ObjectManager.getManagedObjectFor(SoDetail.class, SoPickedPoint.getDetailImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soDetail;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setDetail(SoDetail soDetail, SoNode soNode) {
        this.m_detail_setDetail = soDetail;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint.setDetailImpl(this.getNativeResourceHandle(), soDetail != null ? soDetail.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isOnGeometry() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoPickedPoint.isOnGeometryImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

