/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.nodes.SoNode;

public class SoProgressIndicator
extends Inventor {
    public final SbEventHandler<TaskEventArg> onBeginTask;
    public final SbEventHandler<TaskEventArg> onEndTask;
    public final SbEventHandler<SubTaskEventArg> onBeginSubTask;
    public final SbEventHandler<SubTaskEventArg> onEndSubTask;
    public final SbEventHandler<StepEventArg> onEndStep;

    private static native long addOnEndStepEventHandler(long var0, OnEndStepEventHandler var2, String var3);

    private static native boolean removeOnEndSubTaskEventHandler(long var0, long var2);

    private static native boolean removeOnBeginSubTaskEventHandler(long var0, long var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoProgressIndicator.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean removeOnEndStepEventHandler(long var0, long var2);

    private static native boolean removeOnBeginTaskEventHandler(long var0, long var2);

    private static native long addOnBeginTaskEventHandler(long var0, OnBeginTaskEventHandler var2, String var3);

    private static native long addOnEndSubTaskEventHandler(long var0, OnEndSubTaskEventHandler var2, String var3);

    private static native long addOnEndTaskEventHandler(long var0, OnEndTaskEventHandler var2, String var3);

    private static native long addOnBeginSubTaskEventHandler(long var0, OnBeginSubTaskEventHandler var2, String var3);

    private static native boolean removeOnEndTaskEventHandler(long var0, long var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoProgressIndicator(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.onBeginTask = new OnBeginTaskEventHandler();
        this.onEndTask = new OnEndTaskEventHandler();
        this.onBeginSubTask = new OnBeginSubTaskEventHandler();
        this.onEndSubTask = new OnEndSubTaskEventHandler();
        this.onEndStep = new OnEndStepEventHandler();
    }

    public SoProgressIndicator() {
        this(Inventor.ConstructorCommand.CreateInstance, SoProgressIndicator.ctorImplSync());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    private class OnEndStepEventHandler
    extends SbEventHandler<StepEventArg> {
        private OnEndStepEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoProgressIndicator.removeOnEndStepEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = StepEventArg.class.getName();
            this.m_nativeEventHandler = SoProgressIndicator.addOnEndStepEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnEndSubTaskEventHandler
    extends SbEventHandler<SubTaskEventArg> {
        private OnEndSubTaskEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoProgressIndicator.removeOnEndSubTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = SubTaskEventArg.class.getName();
            this.m_nativeEventHandler = SoProgressIndicator.addOnEndSubTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnBeginSubTaskEventHandler
    extends SbEventHandler<SubTaskEventArg> {
        private OnBeginSubTaskEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoProgressIndicator.removeOnBeginSubTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = SubTaskEventArg.class.getName();
            this.m_nativeEventHandler = SoProgressIndicator.addOnBeginSubTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnEndTaskEventHandler
    extends SbEventHandler<TaskEventArg> {
        private OnEndTaskEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoProgressIndicator.removeOnEndTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = TaskEventArg.class.getName();
            this.m_nativeEventHandler = SoProgressIndicator.addOnEndTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnBeginTaskEventHandler
    extends SbEventHandler<TaskEventArg> {
        private OnBeginTaskEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoProgressIndicator.removeOnBeginTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = TaskEventArg.class.getName();
            this.m_nativeEventHandler = SoProgressIndicator.addOnBeginTaskEventHandler(SoProgressIndicator.this.getNativeResourceHandle(), this, string);
        }
    }

    public static class StepEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        private static native int getNumStepsDoneImpl(long var0);

        private static native int getNumStepsImpl(long var0);

        private static native String getEventNameImpl(long var0);

        private static native long ctorImpl(long var0, String var2, int var3, int var4);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected StepEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public void setValue(StepEventArg stepEventArg) {
            StepEventArg.setValueImpl(this.getNativeResourceHandle(), stepEventArg.getNativeResourceHandle());
        }

        @Override
        public SoNode getSource() {
            return ObjectManager.getManagedObjectFor(SoNode.class, StepEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public int getNumSteps() {
            return StepEventArg.getNumStepsImpl(this.getNativeResourceHandle());
        }

        public String getEventName() {
            return StepEventArg.getEventNameImpl(this.getNativeResourceHandle());
        }

        public int getNumStepsDone() {
            return StepEventArg.getNumStepsDoneImpl(this.getNativeResourceHandle());
        }

        public StepEventArg(SoNode soNode, String string, int n, int n2) {
            this(Inventor.ConstructorCommand.CreateInstance, StepEventArg.ctorImpl(soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, string, n, n2));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class SubTaskEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native int getNumSubTasksDoneImpl(long var0);

        private static native String getEventNameImpl(long var0);

        private static native int getNumSubTasksImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, String var2, int var3, int var4, int var5);

        private static native int getNumStepsImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected SubTaskEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public int getNumSubTasks() {
            return SubTaskEventArg.getNumSubTasksImpl(this.getNativeResourceHandle());
        }

        public SubTaskEventArg(SoNode soNode, String string, int n, int n2, int n3) {
            this(Inventor.ConstructorCommand.CreateInstance, SubTaskEventArg.ctorImpl(soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, string, n, n2, n3));
        }

        public void setValue(SubTaskEventArg subTaskEventArg) {
            SubTaskEventArg.setValueImpl(this.getNativeResourceHandle(), subTaskEventArg.getNativeResourceHandle());
        }

        public int getNumSubTasksDone() {
            return SubTaskEventArg.getNumSubTasksDoneImpl(this.getNativeResourceHandle());
        }

        public String getEventName() {
            return SubTaskEventArg.getEventNameImpl(this.getNativeResourceHandle());
        }

        public int getNumSteps() {
            return SubTaskEventArg.getNumStepsImpl(this.getNativeResourceHandle());
        }

        @Override
        public SoNode getSource() {
            return ObjectManager.getManagedObjectFor(SoNode.class, SubTaskEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class TaskEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native int getNumTasksDoneImpl(long var0);

        private static native String getEventNameImpl(long var0);

        private static native int getNumTasksImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, String var2, int var3, int var4, int var5);

        private static native int getNumSubTasksImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected TaskEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public int getNumTasks() {
            return TaskEventArg.getNumTasksImpl(this.getNativeResourceHandle());
        }

        public TaskEventArg(SoNode soNode, String string, int n, int n2, int n3) {
            this(Inventor.ConstructorCommand.CreateInstance, TaskEventArg.ctorImpl(soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, string, n, n2, n3));
        }

        public void setValue(TaskEventArg taskEventArg) {
            TaskEventArg.setValueImpl(this.getNativeResourceHandle(), taskEventArg.getNativeResourceHandle());
        }

        public int getNumTasksDone() {
            return TaskEventArg.getNumTasksDoneImpl(this.getNativeResourceHandle());
        }

        public String getEventName() {
            return TaskEventArg.getEventNameImpl(this.getNativeResourceHandle());
        }

        public int getNumSubTasks() {
            return TaskEventArg.getNumSubTasksImpl(this.getNativeResourceHandle());
        }

        @Override
        public SoNode getSource() {
            return ObjectManager.getManagedObjectFor(SoNode.class, TaskEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }
}

