/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.antialiasing.SiAntialiasingEventListener;
import com.openinventor.inventor.antialiasing.SoAntialiasingParameters;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.helpers.SbGLShareContext;
import com.openinventor.inventor.nodes.SoNode;
import java.util.Hashtable;

public class SoSceneManager
extends Inventor {
    private SoNode m_sceneGraph;
    private boolean m_nativeRenderCallbackInitialized = false;
    private static Hashtable<Long, Runnable> s_renderTasks = new Hashtable();
    private boolean m_nativeAbortRenderCallbackInitialized = false;
    private static Hashtable<Long, AbortRenderTask> s_abortRenderTasks = new Hashtable();
    private boolean m_isFloatingPointRendering;
    private int m_floatingPointRenderingPrecision;
    @Deprecated
    public static final int AUTO = AntialiasingModes.access$000();
    @Deprecated
    public static final int FXAA = AntialiasingModes.access$100();
    @Deprecated
    public static final int SMAA = AntialiasingModes.access$200();
    @Deprecated
    public static final int FSAA = AntialiasingModes.access$300();
    @Deprecated
    public static final int SUPERSAMPLING = AntialiasingModes.access$400();
    @Deprecated
    public static final int ACCUM_BUFFERS = AntialiasingModes.access$500();
    @Deprecated
    public static final int NUM_ANTIALIASING_MODE = AntialiasingModes.access$600();
    @Deprecated
    public static final int NO_ANTIALIASING = AntialiasingModes.access$700();
    private SoAntialiasingParameters m_advancedParameters_setAntialiasing;
    private SiAntialiasingEventListener m_listener_setAntialiasingEventListener;
    private SoHandleEventAction m_hea_setHandleEventAction;
    private SoGLRenderAction m_ra_setGLRenderAction;

    private void onSetSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
    }

    public void setRenderTask(Runnable runnable) {
        SoSceneManager.delRenderTask(this.getNativeResourceHandle());
        if (runnable != null) {
            SoSceneManager.addRenderTask(runnable, this.getNativeResourceHandle());
            if (!this.m_nativeRenderCallbackInitialized) {
                SoSceneManager.initNativeRenderCallback(this.getNativeResourceHandle());
                this.m_nativeRenderCallbackInitialized = true;
            }
        }
    }

    private static native void initNativeRenderCallback(long var0);

    private static void addRenderTask(Runnable runnable, long l) {
        s_renderTasks.put(l, runnable);
    }

    private static void delRenderTask(long l) {
        s_renderTasks.remove(l);
    }

    private static void invokeRenderTask(long l) {
        Runnable runnable = s_renderTasks.get(l);
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setAbortRenderTask(AbortRenderTask abortRenderTask) {
        SoSceneManager.removeAbortRenderTask(this.getNativeResourceHandle());
        if (abortRenderTask != null) {
            SoSceneManager.setAbortRenderTask(abortRenderTask, this.getNativeResourceHandle());
            if (!this.m_nativeAbortRenderCallbackInitialized) {
                SoSceneManager.initNativeAbortRenderCallback(this.getNativeResourceHandle());
                this.m_nativeAbortRenderCallbackInitialized = true;
            }
        }
    }

    private static native void initNativeAbortRenderCallback(long var0);

    private static void setAbortRenderTask(AbortRenderTask abortRenderTask, long l) {
        s_abortRenderTasks.put(l, abortRenderTask);
    }

    private static void removeAbortRenderTask(long l) {
        s_abortRenderTasks.remove(l);
    }

    private static boolean invokeAbortRenderTask(long l, long l2) {
        AbortRenderTask abortRenderTask = s_abortRenderTasks.get(l);
        if (abortRenderTask == null) {
            return false;
        }
        return abortRenderTask.run(ObjectManager.getManagedObjectFor(SoAction.class, l2));
    }

    @Deprecated
    public void allowRedraw(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void scheduleForcedRedraw() {
        ObjectManager.globalLock.lock();
        try {
            SoSceneManager.scheduleForcedRedrawImpl(this.getNativeResourceHandle());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void scheduleForcedRedrawImpl(long var0);

    public void setFloatingColorBuffer(boolean bl, int n) {
        ObjectManager.globalLock.lock();
        try {
            this.m_isFloatingPointRendering = bl;
            this.m_floatingPointRenderingPrecision = n;
            SoSceneManager.setFloatingColorBufferImpl(this.getNativeResourceHandle(), bl, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setFloatingColorBufferImpl(long var0, boolean var2, int var3);

    public int getFloatingPointRenderingPrecision() {
        return this.m_floatingPointRenderingPrecision;
    }

    public void updateRealTimeSensor() {
        SoSceneManager.updateRealTimeSensorImpl(this.getNativeResourceHandle());
    }

    private static native void updateRealTimeSensorImpl(long var0);

    private static native void setAntialiasingImpl1(long var0, long var2);

    private static native void setBackgroundColorRGBAImpl(long var0, float[] var2);

    private static native float getAntialiasingQualityImpl(long var0);

    private static native void getBackgroundColorRGBAImpl(long var0, float[] var2);

    private static native float getStillSuperSamplingDelayImpl(long var0);

    private static native void setBackgroundIndexImpl(long var0, int var2);

    private static native void setAntialiasingImpl(long var0, float var2, int var3);

    private static native void getViewportRegionImpl(long var0, long var2);

    private static native void setAntialiasingEventListenerImpl(long var0, long var2);

    private static native void setViewportRegionImpl(long var0, long var2);

    private static native int getAntialiasingModeImpl(long var0);

    private static native void getBackgroundColorImpl(long var0, float[] var2);

    private static native long getAntialiasingParametersImpl(long var0);

    private static native void setBackgroundColorImpl(long var0, float[] var2);

    private static native int getBackgroundIndexImpl(long var0);

    private static native boolean isAutoRedrawImpl(long var0);

    private static native void activateImpl(long var0);

    private static native float getClearDepthImpl(long var0);

    private static native void deactivateImpl(long var0);

    private static native boolean isAutoInteractiveModeImpl(long var0);

    private static native void setAutoInteractiveModeImpl(long var0, boolean var2);

    private static native void setInteractiveImpl(long var0, boolean var2);

    private static native void setStillSuperSamplingImpl(long var0, float var2, float var3);

    private static native void setRGBModeImpl(long var0, boolean var2);

    private static native float getStillSuperSamplingQualityImpl(long var0);

    private static native boolean isRGBModeImpl(long var0);

    private static native int getRedrawPriorityImpl(long var0);

    private static native void setClearDepthImpl(long var0, float var2);

    private static native void setShareContextImpl(long var0, long var2, boolean var4);

    private static native void enableRealTimeUpdateImpl(boolean var0);

    private static native void scheduleRedrawImpl(long var0);

    private static native boolean isRealTimeUpdateEnabledImpl();

    private static native long getSceneGraphImpl(long var0);

    private static native int getDefaultRedrawPriorityImpl();

    private static native void setSceneGraphImpl(long var0, long var2);

    private static long ctorImplSync(int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSceneManager.ctorImpl(n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl(int var0);

    private static native void setRedrawPriorityImpl(long var0, int var2);

    private static native void reinitializeImpl(long var0);

    private static native boolean processEventImpl(long var0, long var2);

    private static native void renderImpl(long var0, boolean var2, boolean var3, int var4, boolean var5);

    private static native void setOriginImpl(long var0, short[] var2);

    private static native long getHandleEventActionImpl(long var0);

    private static native void getSizeImpl(long var0, short[] var2);

    private static native long getAntialiasingEventListenerImpl(long var0);

    private static native void getOriginImpl(long var0, short[] var2);

    private static native void setHandleEventActionImpl(long var0, long var2);

    private static native void getWindowSizeImpl(long var0, short[] var2);

    private static native long getGLRenderActionImpl(long var0);

    private static native void setWindowSizeImpl(long var0, short[] var2, float var3);

    private static native void setAntialiasingImpl2(long var0, boolean var2, int var3);

    private static native void setGLRenderActionImpl(long var0, long var2);

    private static native void setSizeImpl(long var0, short[] var2, float var3);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoSceneManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setWindowSize(SbVec2s sbVec2s) {
        this.setWindowSize(sbVec2s, 1.0f);
    }

    public void render(boolean bl, boolean bl2, int n) {
        this.render(bl, bl2, n, false);
    }

    public void render(boolean bl, boolean bl2) {
        this.render(bl, bl2, 0, false);
    }

    public void setAntialiasing(float f) {
        this.setAntialiasing(f, AntialiasingModes.valueOf(AntialiasingModes.AUTO.getValue()));
    }

    public void setShareContext(SbGLShareContext sbGLShareContext) {
        this.setShareContext(sbGLShareContext, true);
    }

    public void setSize(SbVec2s sbVec2s) {
        this.setSize(sbVec2s, 1.0f);
    }

    public SoSceneManager() {
        this(1);
    }

    public void render() {
        this.render(true, true, 0, false);
    }

    public void render(boolean bl) {
        this.render(bl, true, 0, false);
    }

    public SoNode getSceneGraph() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoSceneManager.getSceneGraphImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setWindowSize(SbVec2s sbVec2s, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setWindowSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null, f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static int getDefaultRedrawPriority() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoSceneManager.getDefaultRedrawPriorityImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void setSize(SbVec2s sbVec2s, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null, f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoGLRenderAction getGLRenderAction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderAction soGLRenderAction = ObjectManager.getManagedObjectFor(SoGLRenderAction.class, SoSceneManager.getGLRenderActionImpl(this.getNativeResourceHandle()));
            return soGLRenderAction;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2s getWindowSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.getWindowSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    @Deprecated
    public void setAntialiasing(boolean bl, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setAntialiasingImpl2(this.getNativeResourceHandle(), bl, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void reinitialize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.reinitializeImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSceneManager(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSceneManager.ctorImplSync(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(boolean bl, boolean bl2, int n, boolean bl3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.renderImpl(this.getNativeResourceHandle(), bl, bl2, n, bl3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean processEvent(SoEvent soEvent) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSceneManager.processEventImpl(this.getNativeResourceHandle(), soEvent != null ? soEvent.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSceneGraph(SoNode soNode) {
        this.onSetSceneGraph(soNode);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableRealTimeUpdate(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoSceneManager.enableRealTimeUpdateImpl(bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void scheduleRedraw() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.scheduleRedrawImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean isRealTimeUpdateEnabled() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoSceneManager.isRealTimeUpdateEnabledImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SbVec2s getSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.getSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public void setStillSuperSampling(float f, float f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setStillSuperSamplingImpl(this.getNativeResourceHandle(), f, f2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isRGBMode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSceneManager.isRGBModeImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setShareContext(SbGLShareContext sbGLShareContext, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext != null ? sbGLShareContext.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setClearDepth(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setClearDepthImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getStillSuperSamplingQuality() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoSceneManager.getStillSuperSamplingQualityImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getBackgroundIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSceneManager.getBackgroundIndexImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setAntialiasing(float f, AntialiasingModes antialiasingModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setAntialiasingImpl(this.getNativeResourceHandle(), f, antialiasingModes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRGBMode(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setRGBModeImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getStillSuperSamplingDelay() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoSceneManager.getStillSuperSamplingDelayImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setAutoInteractiveMode(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setAutoInteractiveModeImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isAutoRedraw() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSceneManager.isAutoRedrawImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isAutoInteractiveMode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSceneManager.isAutoInteractiveModeImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setInteractive(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setInteractiveImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void deactivate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.deactivateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getRedrawPriority() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSceneManager.getRedrawPriorityImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getClearDepth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoSceneManager.getClearDepthImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRedrawPriority(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setRedrawPriorityImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void activate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.activateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SiAntialiasingEventListener getAntialiasingEventListener() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiAntialiasingEventListener siAntialiasingEventListener = ObjectManager.getManagedObjectFor(SiAntialiasingEventListener.class, SoSceneManager.getAntialiasingEventListenerImpl(this.getNativeResourceHandle()));
            return siAntialiasingEventListener;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setAntialiasingEventListener(SiAntialiasingEventListener siAntialiasingEventListener) {
        this.m_listener_setAntialiasingEventListener = siAntialiasingEventListener;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setAntialiasingEventListenerImpl(this.getNativeResourceHandle(), siAntialiasingEventListener != null ? siAntialiasingEventListener.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbViewportRegion;
    }

    public void setHandleEventAction(SoHandleEventAction soHandleEventAction) {
        this.m_hea_setHandleEventAction = soHandleEventAction;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setHandleEventActionImpl(this.getNativeResourceHandle(), soHandleEventAction != null ? soHandleEventAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setOrigin(SbVec2s sbVec2s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setOriginImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_ra_setGLRenderAction = soGLRenderAction;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setGLRenderActionImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2s getOrigin() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.getOriginImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public SoHandleEventAction getHandleEventAction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction soHandleEventAction = ObjectManager.getManagedObjectFor(SoHandleEventAction.class, SoSceneManager.getHandleEventActionImpl(this.getNativeResourceHandle()));
            return soHandleEventAction;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColorRGBA getBackgroundColorRGBA() {
        SbColorRGBA sbColorRGBA = new SbColorRGBA();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.getBackgroundColorRGBAImpl(this.getNativeResourceHandle(), sbColorRGBA.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColorRGBA;
    }

    public float getAntialiasingQuality() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoSceneManager.getAntialiasingQualityImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setBackgroundIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setBackgroundIndexImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setAntialiasing(SoAntialiasingParameters soAntialiasingParameters) {
        this.m_advancedParameters_setAntialiasing = soAntialiasingParameters;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setAntialiasingImpl1(this.getNativeResourceHandle(), soAntialiasingParameters != null ? soAntialiasingParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setBackgroundColorRGBA(SbColorRGBA sbColorRGBA) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setBackgroundColorRGBAImpl(this.getNativeResourceHandle(), sbColorRGBA != null ? sbColorRGBA.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public AntialiasingModes getAntialiasingMode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            AntialiasingModes antialiasingModes = IntegerValuedEnumHelper.fromIntValue(AntialiasingModes.class, SoSceneManager.getAntialiasingModeImpl(this.getNativeResourceHandle()));
            return antialiasingModes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setBackgroundColor(SbColor sbColor) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.setBackgroundColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoAntialiasingParameters getAntialiasingParameters() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAntialiasingParameters soAntialiasingParameters = ObjectManager.getManagedObjectFor(SoAntialiasingParameters.class, SoSceneManager.getAntialiasingParametersImpl(this.getNativeResourceHandle()));
            return soAntialiasingParameters;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColor getBackgroundColor() {
        SbColor sbColor = new SbColor();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.getBackgroundColorImpl(this.getNativeResourceHandle(), sbColor.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColor;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum AntialiasingModes implements IntegerValuedEnum
    {
        AUTO(AntialiasingModes.getAUTO()),
        FXAA(AntialiasingModes.getFXAA()),
        SMAA(AntialiasingModes.getSMAA()),
        FSAA(AntialiasingModes.getFSAA()),
        SUPERSAMPLING(AntialiasingModes.getSUPERSAMPLING()),
        ACCUM_BUFFERS(AntialiasingModes.getACCUMBUFFERS()),
        NUM_ANTIALIASING_MODE(AntialiasingModes.getNUMANTIALIASINGMODE()),
        NO_ANTIALIASING(AntialiasingModes.getNOANTIALIASING());

        private int value;

        private static native int getNUMANTIALIASINGMODE();

        private static native int getACCUMBUFFERS();

        private AntialiasingModes(int n2) {
            this.value = n2;
        }

        private static native int getNOANTIALIASING();

        private static native int getSUPERSAMPLING();

        private static native int getFXAA();

        private static native int getAUTO();

        private static native int getFSAA();

        private static native int getSMAA();

        @Deprecated
        public static AntialiasingModes fromValue(int n) {
            return AntialiasingModes.valueOf(n);
        }

        public static AntialiasingModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(AntialiasingModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return AntialiasingModes.getAUTO();
        }

        static /* synthetic */ int access$100() {
            return AntialiasingModes.getFXAA();
        }

        static /* synthetic */ int access$200() {
            return AntialiasingModes.getSMAA();
        }

        static /* synthetic */ int access$300() {
            return AntialiasingModes.getFSAA();
        }

        static /* synthetic */ int access$400() {
            return AntialiasingModes.getSUPERSAMPLING();
        }

        static /* synthetic */ int access$500() {
            return AntialiasingModes.getACCUMBUFFERS();
        }

        static /* synthetic */ int access$600() {
            return AntialiasingModes.getNUMANTIALIASINGMODE();
        }

        static /* synthetic */ int access$700() {
            return AntialiasingModes.getNOANTIALIASING();
        }
    }

    public static interface AbortRenderTask {
        public boolean run(SoAction var1);
    }
}

