/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Vector;

public abstract class SoAction
extends Inventor {
    @Deprecated
    public static final int LOCAL_ONLY = DistribModes.access$000();
    @Deprecated
    public static final int CLUSTER_ONLY = DistribModes.access$100();
    @Deprecated
    public static final int ALL = DistribModes.access$200();
    @Deprecated
    public static final int NODE = AppliedCodes.access$300();
    @Deprecated
    public static final int PATH = AppliedCodes.access$400();
    @Deprecated
    public static final int PATH_LIST = AppliedCodes.access$500();
    @Deprecated
    public static final int NO_PATH = PathCodes.access$600();
    @Deprecated
    public static final int IN_PATH = PathCodes.access$700();
    @Deprecated
    public static final int BELOW_PATH = PathCodes.access$800();
    @Deprecated
    public static final int OFF_PATH = PathCodes.access$900();
    private SoSceneManager m_mgr_setSceneManager;

    private static native void setUpStateImpl(long var0);

    private static native void forwardTraversalImpl(long var0, long var2);

    private static native void nullActionImpl(long var0, long var2);

    private static native int getWhatAppliedToImpl(long var0);

    private static native long getStateImpl(long var0);

    private static native void setSceneManagerImpl(long var0, long var2);

    private static native boolean isBeingAppliedImpl(long var0);

    private static native int getPipeIdImpl(long var0);

    private static native void setPipeIdImpl(long var0, int var2);

    private static native long getSceneManagerImpl(long var0);

    private static native long[] getPathListAppliedToImpl(long var0);

    private static native long[] getOriginalPathListAppliedToImpl(long var0);

    private static native boolean isLastPathListAppliedToImpl(long var0);

    private static native int getPathCodeImpl(long var0, Object[] var2);

    private static native long getNodeAppliedToImpl(long var0);

    private static native long getCurPathImpl(long var0);

    private static native boolean hasTerminatedImpl(long var0);

    private static native void traverseImpl(long var0, long var2);

    private static native long getPathAppliedToImpl(long var0);

    private static native boolean isUsingAlternateRepImpl(long var0);

    private static native void clearApplyResultImpl(long var0);

    private static native void applyImpl1(long var0, long var2);

    private static native void stopActionInBranchImpl(long var0);

    private static native void invalidateStateImpl(long var0);

    private static native void applyImpl(long var0, long var2);

    private static native void postDelayedTraversalImpl(long var0);

    private static native boolean getContinueActionInBranchFlagImpl(long var0);

    private static native void resetContinueActionInBranchFlagImpl(long var0);

    private static native boolean preDelayedTraversalImpl(long var0);

    private static native void useAlternateRepImpl(long var0, boolean var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void resetContinueActionInBranchFlag() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.resetContinueActionInBranchFlagImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getContinueActionInBranchFlag() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoAction.getContinueActionInBranchFlagImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void traverse(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.traverseImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Vector<SoPath> getPathListAppliedTo() {
        Vector<SoPath> vector = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            vector = SoAction.toVector(SoPath.class, SoAction.getPathListAppliedToImpl(this.getNativeResourceHandle()));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return vector;
    }

    public Vector<SoPath> getOriginalPathListAppliedTo() {
        Vector<SoPath> vector = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            vector = SoAction.toVector(SoPath.class, SoAction.getOriginalPathListAppliedToImpl(this.getNativeResourceHandle()));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return vector;
    }

    public boolean hasTerminated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoAction.hasTerminatedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void apply(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.applyImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isLastPathListAppliedTo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoAction.isLastPathListAppliedToImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public PathIndices getPathCode() {
        PathIndices pathIndices = new PathIndices();
        Object[] objectArray = new ByteBuffer[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            pathIndices.returnedValue = IntegerValuedEnumHelper.fromIntValue(PathCodes.class, SoAction.getPathCodeImpl(this.getNativeResourceHandle(), objectArray));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (objectArray[0] != null) {
            ((ByteBuffer)objectArray[0]).order(ByteOrder.nativeOrder());
        }
        pathIndices.indices = objectArray[0] != null ? ((ByteBuffer)objectArray[0]).asIntBuffer() : null;
        return pathIndices;
    }

    public void apply(SoPath soPath) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.applyImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void stopActionInBranch() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.stopActionInBranchImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void invalidateState() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.invalidateStateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void clearApplyResult() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.clearApplyResultImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getPathAppliedTo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoAction.getPathAppliedToImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isBeingApplied() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoAction.isBeingAppliedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSceneManager(SoSceneManager soSceneManager) {
        this.m_mgr_setSceneManager = soSceneManager;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.setSceneManagerImpl(this.getNativeResourceHandle(), soSceneManager != null ? soSceneManager.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getPipeId() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoAction.getPipeIdImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSceneManager getSceneManager() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager soSceneManager = ObjectManager.getManagedObjectFor(SoSceneManager.class, SoAction.getSceneManagerImpl(this.getNativeResourceHandle()));
            return soSceneManager;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void postDelayedTraversal() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.postDelayedTraversalImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void useAlternateRep(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.useAlternateRepImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean preDelayedTraversal() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoAction.preDelayedTraversalImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isUsingAlternateRep() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoAction.isUsingAlternateRepImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoState getState() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoState soState = ObjectManager.getManagedObjectFor(SoState.class, SoAction.getStateImpl(this.getNativeResourceHandle()));
            return soState;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public AppliedCodes getWhatAppliedTo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            AppliedCodes appliedCodes = IntegerValuedEnumHelper.fromIntValue(AppliedCodes.class, SoAction.getWhatAppliedToImpl(this.getNativeResourceHandle()));
            return appliedCodes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getCurPath() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoAction.getCurPathImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getNodeAppliedTo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoAction.getNodeAppliedToImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPipeId(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.setPipeIdImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void forwardTraversal(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.forwardTraversalImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setUpState() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction.setUpStateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void nullAction(SoAction soAction, SoNode soNode) {
        ObjectManager.globalLock.lock();
        try {
            SoAction.nullActionImpl(soAction != null ? soAction.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static class PathIndices {
        public IntBuffer indices;
        public PathCodes returnedValue;
    }

    public static enum PathCodes implements IntegerValuedEnum
    {
        NO_PATH(PathCodes.getNOPATH()),
        IN_PATH(PathCodes.getINPATH()),
        BELOW_PATH(PathCodes.getBELOWPATH()),
        OFF_PATH(PathCodes.getOFFPATH());

        private int value;

        private static native int getOFFPATH();

        private PathCodes(int n2) {
            this.value = n2;
        }

        private static native int getBELOWPATH();

        private static native int getNOPATH();

        private static native int getINPATH();

        @Deprecated
        public static PathCodes fromValue(int n) {
            return PathCodes.valueOf(n);
        }

        public static PathCodes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(PathCodes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$600() {
            return PathCodes.getNOPATH();
        }

        static /* synthetic */ int access$700() {
            return PathCodes.getINPATH();
        }

        static /* synthetic */ int access$800() {
            return PathCodes.getBELOWPATH();
        }

        static /* synthetic */ int access$900() {
            return PathCodes.getOFFPATH();
        }
    }

    public static enum AppliedCodes implements IntegerValuedEnum
    {
        NODE(AppliedCodes.getNODE()),
        PATH(AppliedCodes.getPATH()),
        PATH_LIST(AppliedCodes.getPATHLIST());

        private int value;

        private static native int getPATHLIST();

        private AppliedCodes(int n2) {
            this.value = n2;
        }

        private static native int getNODE();

        private static native int getPATH();

        @Deprecated
        public static AppliedCodes fromValue(int n) {
            return AppliedCodes.valueOf(n);
        }

        public static AppliedCodes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(AppliedCodes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$300() {
            return AppliedCodes.getNODE();
        }

        static /* synthetic */ int access$400() {
            return AppliedCodes.getPATH();
        }

        static /* synthetic */ int access$500() {
            return AppliedCodes.getPATHLIST();
        }
    }

    public static enum DistribModes implements IntegerValuedEnum
    {
        LOCAL_ONLY(DistribModes.getLOCALONLY()),
        CLUSTER_ONLY(DistribModes.getCLUSTERONLY()),
        ALL(DistribModes.getALL());

        private int value;

        private static native int getALL();

        private DistribModes(int n2) {
            this.value = n2;
        }

        private static native int getLOCALONLY();

        private static native int getCLUSTERONLY();

        @Deprecated
        public static DistribModes fromValue(int n) {
            return DistribModes.valueOf(n);
        }

        public static DistribModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DistribModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return DistribModes.getLOCALONLY();
        }

        static /* synthetic */ int access$100() {
            return DistribModes.getCLUSTERONLY();
        }

        static /* synthetic */ int access$200() {
            return DistribModes.getALL();
        }
    }
}

