/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.nodes.SoGroup;

public class SoBevelAction
extends SoAction {
    private static native void enableOrderingTestImpl(long var0, boolean var2);

    private static native long getSceneGraphImpl(long var0);

    private static native void enableCoplanarTestImpl(long var0, boolean var2);

    private static native boolean isOrderingTestEnabledImpl(long var0);

    private static native void enableDuplicateTestImpl(long var0, boolean var2);

    private static native void enableElementImpl(String var0, int var1);

    private static native float getAngleImpl(long var0);

    private static native float getRadiusImpl(long var0);

    private static native void setRadiusImpl(long var0, float var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoBevelAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setAngleImpl(long var0, float var2);

    private static native void setOutputVRMLImpl(long var0, boolean var2);

    private static native boolean isOutputVRMLImpl(long var0);

    private static native boolean isDuplicateTestEnabledImpl(long var0);

    private static native boolean isCoplanarTestEnabledImpl(long var0);

    private static native void enableAbsoluteRadiusImpl(long var0, boolean var2);

    private static native boolean isAbsoluteRadiusEnabledImpl(long var0);

    protected SoBevelAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void enableOrderingTest() {
        this.enableOrderingTest(true);
    }

    public void enableAbsoluteRadius() {
        this.enableAbsoluteRadius(true);
    }

    public void enableDuplicateTest() {
        this.enableDuplicateTest(true);
    }

    public void enableCoplanarTest() {
        this.enableCoplanarTest(true);
    }

    @Deprecated
    public void setOutputVRML() {
        this.setOutputVRML(true);
    }

    public void setAngle(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBevelAction.setAngleImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getAngle() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoBevelAction.getAngleImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoBevelAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoBevelAction.ctorImplSync());
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoBevelAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoGroup getSceneGraph() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGroup soGroup = ObjectManager.getManagedObjectFor(SoGroup.class, SoBevelAction.getSceneGraphImpl(this.getNativeResourceHandle()));
            return soGroup;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public boolean isOutputVRML() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBevelAction.isOutputVRMLImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRadius(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBevelAction.setRadiusImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isDuplicateTestEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBevelAction.isDuplicateTestEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isCoplanarTestEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBevelAction.isCoplanarTestEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isOrderingTestEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBevelAction.isOrderingTestEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableDuplicateTest(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBevelAction.enableDuplicateTestImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableCoplanarTest(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBevelAction.enableCoplanarTestImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableAbsoluteRadius(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBevelAction.enableAbsoluteRadiusImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getRadius() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoBevelAction.getRadiusImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isAbsoluteRadiusEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBevelAction.isAbsoluteRadiusEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public void setOutputVRML(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBevelAction.setOutputVRMLImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableOrderingTest(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBevelAction.enableOrderingTestImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

