/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.elements.SoDecimationTypeElement;

public class SoGetPrimitiveCountAction
extends SoAction {
    private static native void addNumImageImpl(long var0, int var2);

    private static native void setDecimationValueImpl(long var0, int var2, float var3);

    private static native void addNumTextImpl(long var0, int var2);

    private static native int getDecimationTypeImpl(long var0);

    private static native void incNumLinesImpl(long var0);

    private static native void enableElementImpl(String var0, int var1);

    private static native void incNumTrianglesImpl(long var0);

    private static native boolean containsNonTriangleShapesImpl(long var0);

    private static native void addNumTrianglesImpl(long var0, int var2);

    private static native boolean is3DTextCountedAsTrianglesImpl(long var0);

    private static native boolean canApproximateCountImpl(long var0);

    private static native void setCanApproximateImpl(long var0, boolean var2);

    private static native void addNumPointsImpl(long var0, int var2);

    private static native float getDecimationPercentageImpl(long var0);

    private static native void addNumLinesImpl(long var0, int var2);

    private static native void setCount3DTextAsTrianglesImpl(long var0, boolean var2);

    private static native int getLineCountImpl(long var0);

    private static native boolean containsNoPrimitivesImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoGetPrimitiveCountAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native int getTriangleCountImpl(long var0);

    private static native int getPointCountImpl(long var0);

    private static native int getImageCountImpl(long var0);

    private static native void incNumPointsImpl(long var0);

    private static native void incNumTextImpl(long var0);

    private static native void incNumImageImpl(long var0);

    private static native int getTextCountImpl(long var0);

    protected SoGetPrimitiveCountAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void setDecimationValue(SoDecimationTypeElement.Types types) {
        this.setDecimationValue(types, 1.0f);
    }

    public void incNumText() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.incNumTextImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void incNumImage() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.incNumImageImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getImageCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGetPrimitiveCountAction.getImageCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean containsNonTriangleShapes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGetPrimitiveCountAction.containsNonTriangleShapesImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void incNumPoints() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.incNumPointsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean containsNoPrimitives() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGetPrimitiveCountAction.containsNoPrimitivesImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getTriangleCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGetPrimitiveCountAction.getTriangleCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoGetPrimitiveCountAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoGetPrimitiveCountAction.ctorImplSync());
    }

    public boolean canApproximateCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGetPrimitiveCountAction.canApproximateCountImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getTextCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGetPrimitiveCountAction.getTextCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getPointCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGetPrimitiveCountAction.getPointCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getLineCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGetPrimitiveCountAction.getLineCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean is3DTextCountedAsTriangles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGetPrimitiveCountAction.is3DTextCountedAsTrianglesImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addNumPoints(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.addNumPointsImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setCount3DTextAsTriangles(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.setCount3DTextAsTrianglesImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addNumLines(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.addNumLinesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoGetPrimitiveCountAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void addNumTriangles(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.addNumTrianglesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setCanApproximate(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.setCanApproximateImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void incNumTriangles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.incNumTrianglesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setDecimationValue(SoDecimationTypeElement.Types types, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.setDecimationValueImpl(this.getNativeResourceHandle(), types.getValue(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void incNumLines() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.incNumLinesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoDecimationTypeElement.Types getDecimationType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDecimationTypeElement.Types types = IntegerValuedEnumHelper.fromIntValue(SoDecimationTypeElement.Types.class, SoGetPrimitiveCountAction.getDecimationTypeImpl(this.getNativeResourceHandle()));
            return types;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addNumText(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.addNumTextImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getDecimationPercentage() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoGetPrimitiveCountAction.getDecimationPercentageImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addNumImage(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGetPrimitiveCountAction.addNumImageImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

