/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.nodes.SoNode;
import java.util.Vector;

public class SoHandleEventAction
extends SoAction {
    private SoEvent m_ev_setEvent;
    private SoPickedPoint m_point_setPickedPoint;

    private static native void setPickRadiusImpl(long var0, float var2);

    private static native void setHandledImpl(long var0);

    private static native long getEventImpl(long var0);

    private static native void setEventImpl(long var0, long var2);

    private static native float getPickRadiusImpl(long var0);

    private static native long getGrabberImpl(long var0);

    private static native void releaseGrabberImpl(long var0);

    private static native void setGrabberImpl(long var0, long var2);

    private static native long getPickRootImpl(long var0);

    private static native boolean isHandledImpl(long var0);

    private static native void enableRadiusForTrianglesImpl(long var0, boolean var2);

    private static native long ctorImpl(long var0);

    private static native void setPickedPointImpl(long var0, long var2);

    private static native void setPickRootImpl(long var0, long var2);

    private static long ctorImplSync(SbViewportRegion sbViewportRegion) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoHandleEventAction.ctorImpl(sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void enableElementImpl(String var0, int var1);

    private static native long getPickedPointImpl(long var0);

    private static native void getViewportRegionImpl(long var0, long var2);

    private static native void setViewportRegionImpl(long var0, long var2);

    private static native long[] getPickedPointListImpl(long var0);

    protected SoHandleEventAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void setPickedPoint() {
        this.setPickedPoint(null);
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoHandleEventAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoNode getGrabber() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoHandleEventAction.getGrabberImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPickedPoint(SoPickedPoint soPickedPoint) {
        this.m_point_setPickedPoint = soPickedPoint;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.setPickedPointImpl(this.getNativeResourceHandle(), soPickedPoint != null ? soPickedPoint.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoHandleEventAction(SbViewportRegion sbViewportRegion) {
        this(Inventor.ConstructorCommand.CreateInstance, SoHandleEventAction.ctorImplSync(sbViewportRegion));
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbViewportRegion;
    }

    public SoNode getPickRoot() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoHandleEventAction.getPickRootImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isHandled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoHandleEventAction.isHandledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPickRadius(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.setPickRadiusImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void releaseGrabber() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.releaseGrabberImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPickRoot(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.setPickRootImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setGrabber(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.setGrabberImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setHandled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.setHandledImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setEvent(SoEvent soEvent) {
        this.m_ev_setEvent = soEvent;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.setEventImpl(this.getNativeResourceHandle(), soEvent != null ? soEvent.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPickedPoint getPickedPoint() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint soPickedPoint = ObjectManager.getManagedObjectFor(SoPickedPoint.class, SoHandleEventAction.getPickedPointImpl(this.getNativeResourceHandle()));
            return soPickedPoint;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Vector<SoPickedPoint> getPickedPointList() {
        Vector<SoPickedPoint> vector = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            vector = SoHandleEventAction.toVector(SoPickedPoint.class, SoHandleEventAction.getPickedPointListImpl(this.getNativeResourceHandle()));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return vector;
    }

    public float getPickRadius() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoHandleEventAction.getPickRadiusImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoEvent getEvent() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEvent soEvent = ObjectManager.getManagedObjectFor(SoEvent.class, SoHandleEventAction.getEventImpl(this.getNativeResourceHandle()));
            return soEvent;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableRadiusForTriangles(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction.enableRadiusForTrianglesImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

