/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoGLRenderAction;

public class SoLineHighlightRenderAction
extends SoGLRenderAction {
    private static native void setLineWidthImpl(long var0, float var2);

    private static native void setVisibleImpl(long var0, boolean var2);

    private static native void setPointSizeImpl(long var0, float var2);

    private static native float getLineWidthImpl(long var0);

    private static native short getLinePatternImpl(long var0);

    private static native void setLinePatternImpl(long var0, short var2);

    private static native void getColorImpl(long var0, float[] var2);

    private static native boolean isVisibleImpl(long var0);

    private static native void setColorImpl(long var0, float[] var2);

    private static native long ctorImpl();

    private static long ctorImpl1Sync(SbViewportRegion sbViewportRegion) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLineHighlightRenderAction.ctorImpl1(sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLineHighlightRenderAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void enableElementImpl(String var0, int var1);

    private static native float getPointSizeImpl(long var0);

    private static native long ctorImpl1(long var0);

    protected SoLineHighlightRenderAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoLineHighlightRenderAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLineHighlightRenderAction.ctorImplSync());
    }

    public short getLinePattern() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            short s = SoLineHighlightRenderAction.getLinePatternImpl(this.getNativeResourceHandle());
            return s;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoLineHighlightRenderAction(SbViewportRegion sbViewportRegion) {
        this(Inventor.ConstructorCommand.CreateInstance, SoLineHighlightRenderAction.ctorImpl1Sync(sbViewportRegion));
    }

    public void setLineWidth(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLineHighlightRenderAction.setLineWidthImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setVisible(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLineHighlightRenderAction.setVisibleImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isVisible() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLineHighlightRenderAction.isVisibleImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColor getColor() {
        SbColor sbColor = new SbColor();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLineHighlightRenderAction.getColorImpl(this.getNativeResourceHandle(), sbColor.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColor;
    }

    public void setColor(SbColor sbColor) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLineHighlightRenderAction.setColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setLinePattern(short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLineHighlightRenderAction.setLinePatternImpl(this.getNativeResourceHandle(), s);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoLineHighlightRenderAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public float getPointSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoLineHighlightRenderAction.getPointSizeImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getLineWidth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoLineHighlightRenderAction.getLineWidthImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPointSize(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLineHighlightRenderAction.setPointSizeImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

