/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoAction;

public class SoPickAction
extends SoAction {
    private static native void enableElementImpl(String var0, int var1);

    private static native void enableCullingImpl(long var0, boolean var2);

    private static native boolean isCullingEnabledImpl(long var0);

    private static native void setViewportRegionImpl(long var0, long var2);

    private static native void getViewportRegionImpl(long var0, long var2);

    protected SoPickAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickAction.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoPickAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public boolean isCullingEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoPickAction.isCullingEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableCulling(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickAction.enableCullingImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickAction.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbViewportRegion;
    }
}

