/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoSimplifyAction;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.simplifier.SoSimplifier;

public class SoReorganizeAction
extends SoSimplifyAction {
    private static native void enableElementImpl(String var0, int var1);

    private static native void generateTexCoordsImpl(long var0, boolean var2);

    private static native void generateTriangleStripsImpl(long var0, boolean var2);

    private static native boolean areTriangleStripGeneratedImpl(long var0);

    private static native boolean areIndexArraysMatchedImpl(long var0);

    private static native boolean areVPNodesGeneratedImpl(long var0);

    private static native void matchIndexArraysImpl(long var0, boolean var2);

    private static native boolean areTexCoordsGeneratedImpl(long var0);

    private static native long getSimplifierImpl(long var0);

    private static native void generateVPNodesImpl(long var0, boolean var2);

    private static native long ctorImpl(long var0);

    private static native void finishReportImpl();

    private static long ctorImplSync(SoSimplifier soSimplifier) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoReorganizeAction.ctorImpl(soSimplifier != null ? soSimplifier.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void startReportImpl1(String var0);

    private static native boolean areNormalGeneratedImpl(long var0);

    private static native long getSimplifiedSceneGraphImpl(long var0);

    private static native void generateNormalsImpl(long var0, boolean var2);

    protected SoReorganizeAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoReorganizeAction() {
        this(null);
    }

    public boolean areNormalGenerated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoReorganizeAction.areNormalGeneratedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void generateTriangleStrips(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoReorganizeAction.generateTriangleStripsImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean areTriangleStripGenerated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoReorganizeAction.areTriangleStripGeneratedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void generateNormals(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoReorganizeAction.generateNormalsImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoReorganizeAction(SoSimplifier soSimplifier) {
        this(Inventor.ConstructorCommand.CreateInstance, SoReorganizeAction.ctorImplSync(soSimplifier));
    }

    public SoSimplifier getSimplifier() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier soSimplifier = ObjectManager.getManagedObjectFor(SoSimplifier.class, SoReorganizeAction.getSimplifierImpl(this.getNativeResourceHandle()));
            return soSimplifier;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSeparator getSimplifiedSceneGraph() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSeparator soSeparator = ObjectManager.getManagedObjectFor(SoSeparator.class, SoReorganizeAction.getSimplifiedSceneGraphImpl(this.getNativeResourceHandle()));
            return soSeparator;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void generateTexCoords(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoReorganizeAction.generateTexCoordsImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void startReport(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoReorganizeAction.startReportImpl1(string);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void finishReport() {
        ObjectManager.globalLock.lock();
        try {
            SoReorganizeAction.finishReportImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoReorganizeAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public boolean areIndexArraysMatched() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoReorganizeAction.areIndexArraysMatchedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void generateVPNodes(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoReorganizeAction.generateVPNodesImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean areTexCoordsGenerated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoReorganizeAction.areTexCoordsGeneratedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void matchIndexArrays(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoReorganizeAction.matchIndexArraysImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean areVPNodesGenerated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoReorganizeAction.areVPNodesGeneratedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

