/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoSearchAction;

public class SoSearchPathAction
extends SoSearchAction {
    private static native byte getSeparatorCharImpl(long var0);

    private static native void setDerivedIsOKImpl(long var0, boolean var2);

    private static native String getSearchStringImpl(long var0);

    private static native void setSeparatorCharImpl(long var0, byte var2);

    private static native void enableElementImpl(String var0, int var1);

    private static native void setFoundImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSearchPathAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native int getNumItemsFoundImpl(long var0);

    private static native boolean getDerivedIsOKImpl(long var0);

    private static native void setSearchStringImpl(long var0, String var2);

    private static native long ctorImpl();

    protected SoSearchPathAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public String getSearchString() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoSearchPathAction.getSearchStringImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public byte getSeparatorChar() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            byte by = SoSearchPathAction.getSeparatorCharImpl(this.getNativeResourceHandle());
            return by;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setDerivedIsOK(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSearchPathAction.setDerivedIsOKImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSeparatorChar(byte by) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSearchPathAction.setSeparatorCharImpl(this.getNativeResourceHandle(), by);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSearchString(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSearchPathAction.setSearchStringImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getDerivedIsOK() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSearchPathAction.getDerivedIsOKImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoSearchPathAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    public void setFound() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSearchPathAction.setFoundImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumItemsFound() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSearchPathAction.getNumItemsFoundImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSearchPathAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSearchPathAction.ctorImplSync());
    }
}

