/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.simplifier.SoSimplifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoSimplifyAction
extends SoAction {
    private static native void setInlineLODImpl(long var0, boolean var2);

    private static native float getSizeFactorImpl(long var0);

    private static native void setUrlNameImpl(long var0, String var2);

    private static long ctorImplSync(SoSimplifier soSimplifier) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSimplifyAction.ctorImpl(soSimplifier != null ? soSimplifier.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native float[] getRangesImpl(long var0);

    private static native Object getDirectRangesImpl(long var0);

    private static native void setSizeFactorImpl(long var0, float var2);

    private static native int getNumRangesImpl(long var0);

    private static native void setRenderCullingImpl(long var0, boolean var2);

    private static native int getMinTrianglesImpl(long var0);

    private static native void enableElementImpl(String var0, int var1);

    private static native int isRenderCullingImpl(long var0);

    private static native void setVerbosityImpl(long var0, boolean var2);

    private static native String getUrlNameImpl(long var0);

    private static native void setMinTrianglesImpl(long var0, int var2);

    private static native boolean isVerboseImpl(long var0);

    private static native Object getDirectSimplificationLevelsImpl(long var0);

    private static native int getNumSimplificationLevelsImpl(long var0);

    private static native float[] getSimplificationLevelsImpl(long var0);

    private static native boolean isInlineLODImpl(long var0);

    private static native void setSimplificationLevelsImpl(long var0, int var2, float[] var3);

    private static native long ctorImpl(long var0);

    private static native void setRangesImpl(long var0, int var2, float[] var3);

    protected SoSimplifyAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoSimplifyAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void setRenderCulling(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setRenderCullingImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectRanges() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoSimplifyAction.getDirectRangesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public int isRenderCulling() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSimplifyAction.isRenderCullingImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSimplifyAction(SoSimplifier soSimplifier) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSimplifyAction.ctorImplSync(soSimplifier));
    }

    public int getNumSimplificationLevels() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSimplifyAction.getNumSimplificationLevelsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getSizeFactor() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoSimplifyAction.getSizeFactorImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isInlineLOD() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSimplifyAction.isInlineLODImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setInlineLOD(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setInlineLODImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumRanges() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSimplifyAction.getNumRangesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float[] getRanges() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float[] fArray = SoSimplifyAction.getRangesImpl(this.getNativeResourceHandle());
            return fArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSizeFactor(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setSizeFactorImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRanges(float[] fArray) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setRangesImpl(this.getNativeResourceHandle(), fArray.length, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float[] getSimplificationLevels() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float[] fArray = SoSimplifyAction.getSimplificationLevelsImpl(this.getNativeResourceHandle());
            return fArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSimplificationLevels(float[] fArray) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setSimplificationLevelsImpl(this.getNativeResourceHandle(), fArray.length, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isVerbose() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSimplifyAction.isVerboseImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMinTriangles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSimplifyAction.getMinTrianglesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setMinTriangles(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setMinTrianglesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getUrlName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoSimplifyAction.getUrlNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setUrlName(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setUrlNameImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setVerbosity(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifyAction.setVerbosityImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectSimplificationLevels() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoSimplifyAction.getDirectSimplificationLevelsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }
}

