/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoAction;

public class SoToHTMLAction
extends SoAction {
    @Deprecated
    public static final int NONE = ShapeTypes.access$000();
    @Deprecated
    public static final int RECTANGLE = ShapeTypes.access$100();
    @Deprecated
    public static final int CIRCLE = ShapeTypes.access$200();
    @Deprecated
    public static final int POLYGON = ShapeTypes.access$300();
    @Deprecated
    public static final int LUMINANCE = Components.access$400();
    @Deprecated
    public static final int LUMINANCE_TRANSPARENCY = Components.access$500();
    @Deprecated
    public static final int RGB = Components.access$600();
    @Deprecated
    public static final int RGB_TRANSPARENCY = Components.access$700();
    @Deprecated
    public static final int BMP_FORMAT = ImageFormats.access$800();
    @Deprecated
    public static final int JPEG_FORMAT = ImageFormats.access$900();

    private static native void enableElementImpl(String var0, int var1);

    private static native boolean isMapHighlightImpl(long var0);

    private static native void setMapHighlightImpl(long var0, boolean var2);

    private static native int getImageFormatImpl(long var0);

    private static native void setImageFormatImpl(long var0, int var2);

    private static native int getImageComponentsImpl(long var0);

    private static native void setImageQualityImpl(long var0, float var2);

    private static native void getViewportRegionImpl(long var0, long var2);

    private static native void setViewportRegionImpl(long var0, long var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoToHTMLAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setImageComponentsImpl(long var0, int var2);

    private static native String getImageURLNameImpl(long var0);

    private static native void setImageBackgroundColorImpl(long var0, float[] var2);

    private static native boolean openHTMLFileImpl1(long var0, String var2);

    private static native int getRegionShapeTypeImpl(long var0);

    private static native void setImageURLNameImpl(long var0, String var2);

    private static native void resetHTMLBufferImpl(long var0);

    private static native float getImageQualityImpl(long var0);

    private static native void setRegionShapeTypeImpl(long var0, int var2);

    private static native void closeHTMLFileImpl(long var0);

    private static native long ctorImpl();

    private static native void getImageBackgroundColorImpl(long var0, float[] var2);

    protected SoToHTMLAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public boolean openHTMLFile(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoToHTMLAction.openHTMLFileImpl1(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void closeHTMLFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.closeHTMLFileImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setImageQuality(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setImageQualityImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColor getImageBackgroundColor() {
        SbColor sbColor = new SbColor();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.getImageBackgroundColorImpl(this.getNativeResourceHandle(), sbColor.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColor;
    }

    public void setImageFormat(ImageFormats imageFormats) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setImageFormatImpl(this.getNativeResourceHandle(), imageFormats.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setImageComponents(Components components) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setImageComponentsImpl(this.getNativeResourceHandle(), components.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Components getImageComponents() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Components components = IntegerValuedEnumHelper.fromIntValue(Components.class, SoToHTMLAction.getImageComponentsImpl(this.getNativeResourceHandle()));
            return components;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ImageFormats getImageFormat() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ImageFormats imageFormats = IntegerValuedEnumHelper.fromIntValue(ImageFormats.class, SoToHTMLAction.getImageFormatImpl(this.getNativeResourceHandle()));
            return imageFormats;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoToHTMLAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoToHTMLAction.ctorImplSync());
    }

    public void setMapHighlight(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setMapHighlightImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ShapeTypes getRegionShapeType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ShapeTypes shapeTypes = IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, SoToHTMLAction.getRegionShapeTypeImpl(this.getNativeResourceHandle()));
            return shapeTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbViewportRegion;
    }

    public void setRegionShapeType(ShapeTypes shapeTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setRegionShapeTypeImpl(this.getNativeResourceHandle(), shapeTypes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoToHTMLAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public boolean isMapHighlight() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoToHTMLAction.isMapHighlightImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setImageBackgroundColor(SbColor sbColor) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setImageBackgroundColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void resetHTMLBuffer() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.resetHTMLBufferImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getImageQuality() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoToHTMLAction.getImageQualityImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getImageURLName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoToHTMLAction.getImageURLNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setImageURLName(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoToHTMLAction.setImageURLNameImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum ImageFormats implements IntegerValuedEnum
    {
        BMP_FORMAT(ImageFormats.getBMPFORMAT()),
        JPEG_FORMAT(ImageFormats.getJPEGFORMAT());

        private int value;

        private ImageFormats(int n2) {
            this.value = n2;
        }

        private static native int getJPEGFORMAT();

        private static native int getBMPFORMAT();

        @Deprecated
        public static ImageFormats fromValue(int n) {
            return ImageFormats.valueOf(n);
        }

        public static ImageFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ImageFormats.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$800() {
            return ImageFormats.getBMPFORMAT();
        }

        static /* synthetic */ int access$900() {
            return ImageFormats.getJPEGFORMAT();
        }
    }

    public static enum Components implements IntegerValuedEnum
    {
        LUMINANCE(Components.getLUMINANCE()),
        LUMINANCE_TRANSPARENCY(Components.getLUMINANCETRANSPARENCY()),
        RGB(Components.getRGB()),
        RGB_TRANSPARENCY(Components.getRGBTRANSPARENCY());

        private int value;

        private static native int getRGBTRANSPARENCY();

        private Components(int n2) {
            this.value = n2;
        }

        private static native int getRGB();

        private static native int getLUMINANCE();

        private static native int getLUMINANCETRANSPARENCY();

        @Deprecated
        public static Components fromValue(int n) {
            return Components.valueOf(n);
        }

        public static Components valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Components.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$400() {
            return Components.getLUMINANCE();
        }

        static /* synthetic */ int access$500() {
            return Components.getLUMINANCETRANSPARENCY();
        }

        static /* synthetic */ int access$600() {
            return Components.getRGB();
        }

        static /* synthetic */ int access$700() {
            return Components.getRGBTRANSPARENCY();
        }
    }

    public static enum ShapeTypes implements IntegerValuedEnum
    {
        NONE(ShapeTypes.getNONE()),
        RECTANGLE(ShapeTypes.getRECTANGLE()),
        CIRCLE(ShapeTypes.getCIRCLE()),
        POLYGON(ShapeTypes.getPOLYGON());

        private int value;

        private static native int getPOLYGON();

        private ShapeTypes(int n2) {
            this.value = n2;
        }

        private static native int getCIRCLE();

        private static native int getNONE();

        private static native int getRECTANGLE();

        @Deprecated
        public static ShapeTypes fromValue(int n) {
            return ShapeTypes.valueOf(n);
        }

        public static ShapeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ShapeTypes.getNONE();
        }

        static /* synthetic */ int access$100() {
            return ShapeTypes.getRECTANGLE();
        }

        static /* synthetic */ int access$200() {
            return ShapeTypes.getCIRCLE();
        }

        static /* synthetic */ int access$300() {
            return ShapeTypes.getPOLYGON();
        }
    }
}

