/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.algorithms;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.algorithms.SoArithmetic;
import com.openinventor.inventor.algorithms.SoConversion;
import com.openinventor.inventor.algorithms.SoConvolution;
import com.openinventor.inventor.algorithms.SoDataExtract;
import com.openinventor.inventor.algorithms.SoSeismic;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.devices.SoDeviceContext;

public class SoAlgorithms
extends Inventor {
    private static native boolean unloadAlgorithmsModuleImpl(String var0);

    private static native long createConversionInterfaceImpl(long var0);

    private static native long loadAlgorithmsModuleImpl(String var0);

    private static native long createSeismicInterfaceImpl(long var0);

    private static native long createContextImpl(long var0);

    private static native long createDataExtractInterfaceImpl(long var0);

    private static native long ctorImpl();

    private static native long createConvolutionInterfaceImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoAlgorithms.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void initImpl();

    private static native long createBufferObjectImpl(long var0);

    private static native void finishImpl();

    private static native long createArithmeticInterfaceImpl(long var0);

    private static native boolean isInitializedImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoAlgorithms(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoArithmetic createArithmeticInterface() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoArithmetic soArithmetic = ObjectManager.getManagedObjectFor(SoArithmetic.class, SoAlgorithms.createArithmeticInterfaceImpl(this.getNativeResourceHandle()));
            return soArithmetic;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoAlgorithms loadAlgorithmsModule(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoAlgorithms soAlgorithms = ObjectManager.getManagedObjectFor(SoAlgorithms.class, SoAlgorithms.loadAlgorithmsModuleImpl(string));
            return soAlgorithms;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoConvolution createConvolutionInterface() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoConvolution soConvolution = ObjectManager.getManagedObjectFor(SoConvolution.class, SoAlgorithms.createConvolutionInterfaceImpl(this.getNativeResourceHandle()));
            return soConvolution;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean isInitialized() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoAlgorithms.isInitializedImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void init() {
        ObjectManager.globalLock.lock();
        try {
            SoAlgorithms.initImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void finish() {
        ObjectManager.globalLock.lock();
        try {
            SoAlgorithms.finishImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoDataExtract createDataExtractInterface() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataExtract soDataExtract = ObjectManager.getManagedObjectFor(SoDataExtract.class, SoAlgorithms.createDataExtractInterfaceImpl(this.getNativeResourceHandle()));
            return soDataExtract;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoBufferObject createBufferObject() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, SoAlgorithms.createBufferObjectImpl(this.getNativeResourceHandle()));
            return soBufferObject;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoDeviceContext createContext() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDeviceContext soDeviceContext = ObjectManager.getManagedObjectFor(SoDeviceContext.class, SoAlgorithms.createContextImpl(this.getNativeResourceHandle()));
            return soDeviceContext;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSeismic createSeismicInterface() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSeismic soSeismic = ObjectManager.getManagedObjectFor(SoSeismic.class, SoAlgorithms.createSeismicInterfaceImpl(this.getNativeResourceHandle()));
            return soSeismic;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean unloadAlgorithmsModule(String string) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoAlgorithms.unloadAlgorithmsModuleImpl(string);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoConversion createConversionInterface() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoConversion soConversion = ObjectManager.getManagedObjectFor(SoConversion.class, SoAlgorithms.createConversionInterfaceImpl(this.getNativeResourceHandle()));
            return soConversion;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoAlgorithms() {
        this(Inventor.ConstructorCommand.CreateInstance, SoAlgorithms.ctorImplSync());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

