/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.antialiasing;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.antialiasing.SoAntialiasingParameters;

public class SiAntialiasingEventListener
extends Inventor {
    private static native boolean onAntialiasingSwitchImpl(long var0, int var2, float var3, long var4);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SiAntialiasingEventListener(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAntialiasingSwitch(SoSceneManager.AntialiasingModes antialiasingModes, float f, SoAntialiasingParameters soAntialiasingParameters) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SiAntialiasingEventListener.onAntialiasingSwitchImpl(this.getNativeResourceHandle(), antialiasingModes.getValue(), f, soAntialiasingParameters != null ? soAntialiasingParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

