/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.awt.CheckboxMenuGroup;
import com.openinventor.awt.GroupedCheckboxMenuItem;
import com.openinventor.awt.event.SliderEvent;
import com.openinventor.awt.event.SliderListener;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.awt.SwColorPatch;
import com.openinventor.inventor.awt.SwColorSlider;
import com.openinventor.inventor.awt.SwColorWheel;
import com.openinventor.inventor.awt.SwIcons;
import com.openinventor.inventor.awt.SwImageButton;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwResources;
import com.openinventor.inventor.fields.SoMFColor;
import com.openinventor.inventor.fields.SoMFInt32;
import com.openinventor.inventor.fields.SoSFColor;
import com.openinventor.inventor.misc.SoBase;
import com.openinventor.inventor.misc.SoCallbackList;
import com.openinventor.inventor.misc.callbacks.SoCallbackListCB;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoNodeSensor;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

@Deprecated
public class SwColorEditor
extends Frame {
    public static final int NONE = 0;
    public static final int INTENSITY = 1;
    public static final int RGB = 2;
    public static final int HSV = 3;
    public static final int RGB_V = 4;
    public static final int RGB_HSV = 5;
    public static final int CONTINUOUS = 0;
    public static final int AFTER_ACCEPT = 1;
    private static final int DEFAULT_WIDTH = 280;
    private static final int DEFAULT_HEIGHT = 170;
    private static final float TOP_REGION_SIZE = 4.1f;
    private static final int BUTTONS_FORM_RIGHT_POSITION = 50;
    private static final int OFFSET = 5;
    static final int R_SLIDER_ID = 0;
    static final int G_SLIDER_ID = 1;
    static final int B_SLIDER_ID = 2;
    static final int H_SLIDER_ID = 3;
    static final int S_SLIDER_ID = 4;
    static final int V_SLIDER_ID = 5;
    static final int COLOR_WHEEL_ID = 6;
    static final int SAVE_ID = 7;
    static final int SWAP_ID = 8;
    static final int RESTORE_ID = 9;
    static final int ACCEPT_ID = 10;
    static final int CONTINUOUS_ID = 11;
    static final int MANUAL_ID = 12;
    static final int NONE_SLIDER_ID = 13;
    static final int INTENSITY_SLIDER_ID = 14;
    static final int RGB_SLIDERS_ID = 15;
    static final int HSV_SLIDERS_ID = 16;
    static final int RGB_V_SLIDERS_ID = 17;
    static final int RGB_HSV_SLIDERS_ID = 18;
    static final int WYSIWYG_ID = 19;
    static final int COPY_ID = 20;
    static final int PASTE_ID = 21;
    static final int HELP_ID = 22;
    static final int CLOSE_ID = 23;
    static final int NUM_IDS = 24;
    private static final int CONTINUOUS_TOGGLE = 0;
    private static final int ACCEPT_TOGGLE = 1;
    private static final int WYSIWYG_TOGGLE = 2;
    private static final int NONE_TOGGLE = 3;
    private static final int INTENSITY_TOGGLE = 4;
    private static final int RGB_TOGGLE = 5;
    private static final int HSV_TOGGLE = 6;
    private static final int RGB_V_TOGGLE = 7;
    private static final int RGB_HSV_TOGGLE = 8;
    private static final int NUM_TOGGLES = 9;
    private SwResources resources;
    private boolean WYSIWYGmode;
    private int whichSliders;
    private SbColor baseRGB = new SbColor();
    private float[] baseHSV = new float[3];
    private boolean ignoreEvent;
    private SwColorSlider[] sliders = new SwColorSlider[6];
    private SwColorWheel wheel;
    private SwColorPatch current;
    private SwColorPatch previous;
    private ColorEditorData[] dataId;
    private Vector menuItems = new Vector(9);
    private int updateFreq;
    private boolean attached;
    private SoBase editNode;
    private SoSFColor colorSF;
    private SoMFColor colorMF;
    private SoNodeSensor colorSensor;
    private SoCallbackList callbackList;
    private int index;
    private SoMFInt32 colorUInt32MF;
    private float transparency;
    private Panel slidersForm;
    private Panel buttonsForm;
    private Panel wheelForm;
    private CheckboxMenuItem menuCheckWys;
    private GroupedCheckboxMenuItem menuCheckCont;
    private GroupedCheckboxMenuItem menuCheckMan;
    private CheckboxMenuGroup groupEdit;
    private CheckboxMenuGroup groupSliders;
    private GroupedCheckboxMenuItem menuCheckNone;
    private GroupedCheckboxMenuItem menuCheckVal;
    private GroupedCheckboxMenuItem menuCheckRGB;
    private GroupedCheckboxMenuItem menuCheckHSV;
    private GroupedCheckboxMenuItem menuCheckRGBV;
    private GroupedCheckboxMenuItem menuCheckRGBHSV;
    private Menu menuEdit;
    private Menu menuSliders;
    private MenuItem menuHelp;
    private MenuItem menuPaste;
    private MenuItem menuCopy;
    private MenuItem menuClose;
    private Button acceptButton;
    private SwImageButton rightButton;
    private SwImageButton switchButton;
    private SwImageButton leftButton;

    public SwColorEditor() {
        this(SwPanel.resources.getString("CE_TITLE"));
    }

    public SwColorEditor(String string) {
        super(string);
        this.resources = (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", SwPanel.defaultLocale);
        this.addComponentListener(new VisibilityChange());
        this.WYSIWYGmode = false;
        this.whichSliders = -1;
        this.baseRGB.setValue(1.0f, 0.0f, 1.0f);
        this.baseRGB.getHSVValue(this.baseHSV);
        this.updateFreq = -1;
        this.attached = false;
        this.colorSensor = new SoNodeSensor(new FieldChanged());
        this.colorUInt32MF = null;
        this.transparency = 0.0f;
        this.dataId = new ColorEditorData[24];
        for (int i = 0; i < 24; ++i) {
            this.dataId[i] = new ColorEditorData();
            this.dataId[i].id = (short)i;
            this.dataId[i].editor = this;
        }
        this.callbackList = new SoCallbackList();
        this.ignoreEvent = false;
        this.buildGUI();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwColorEditor.this.setVisible(false);
            }
        };
        this.addWindowListener(windowAdapter);
        this.setWYSIWYG(true);
        this.setCurrentSliders(1);
        this.setUpdateFrequency(0);
        this.pack();
    }

    protected void finalize() throws Throwable {
        if (this.isAttached()) {
            this.detach();
        }
        super.finalize();
    }

    private void buildGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[]{30, 30, 30, 0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{40, 20, 20, 40, 0};
        gridBagLayout.rowHeights = nArray;
        gridBagLayout.columnWidths = nArray2;
        this.setLayout(gridBagLayout);
        MenuBar menuBar = this.buildMenuBar();
        this.wheel = new SwColorWheel();
        this.wheel.setBaseColor(this.baseHSV);
        this.wheel.addValueChangedCallback(new WheelChanged(), this);
        this.buildControls(gridBagLayout);
        this.buildSlidersPanel(gridBagLayout);
        gridBagLayout.setConstraints(this.wheel, this.constraints(4, 0, 1, 3, 1.0f, 1.0f, 18, 1, 0, 0, 2, 2, 2, 2));
        this.add(this.wheel);
    }

    private MenuBar buildMenuBar() {
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        this.menuEdit = new Menu(this.resources.getString("CE_MENU_EDIT"));
        menuBar.add(this.menuEdit);
        boolean bl = this.updateFreq == 0;
        this.groupEdit = new CheckboxMenuGroup();
        this.menuCheckCont = new GroupedCheckboxMenuItem(this.resources.getString("CE_EDIT_CONTINUOUS"), bl, this.groupEdit);
        this.menuCheckMan = new GroupedCheckboxMenuItem(this.resources.getString("CE_EDIT_MANUAL"), bl, this.groupEdit);
        this.menuCheckCont.addItemListener(new ListenEditItems(11));
        this.menuCheckMan.addItemListener(new ListenEditItems(12));
        this.menuEdit.add(this.menuCheckCont);
        this.menuEdit.add(this.menuCheckMan);
        this.menuEdit.addSeparator();
        this.menuCheckWys = new CheckboxMenuItem(this.resources.getString("CE_EDIT_WYSIWIG"), this.isWYSIWYG());
        this.menuCheckWys.addItemListener(new ListenEditItems(19));
        this.menuEdit.add(this.menuCheckWys);
        this.menuEdit.addSeparator();
        this.menuCopy = new MenuItem(this.resources.getString("CE_EDIT_COPY"));
        this.menuPaste = new MenuItem(this.resources.getString("CE_EDIT_PASTE"));
        this.menuCopy.addActionListener(new ListenEditItems(20));
        this.menuPaste.addActionListener(new ListenEditItems(21));
        this.menuEdit.add(this.menuCopy);
        this.menuEdit.add(this.menuPaste);
        this.menuEdit.addSeparator();
        this.menuHelp = new MenuItem(this.resources.getString("CE_EDIT_HELP"));
        this.menuHelp.addActionListener(new ListenEditItems(22));
        this.menuEdit.add(this.menuHelp);
        this.menuEdit.addSeparator();
        this.menuClose = new MenuItem(this.resources.getString("CE_EDIT_CLOSE"));
        this.menuClose.addActionListener(new ListenEditItems(23));
        this.menuEdit.add(this.menuClose);
        this.menuSliders = new Menu(this.resources.getString("CE_MENU_SLIDERS"));
        menuBar.add(this.menuSliders);
        this.groupSliders = new CheckboxMenuGroup();
        this.menuCheckNone = new GroupedCheckboxMenuItem(this.resources.getString("CE_SLIDER_NONE"), false, this.groupSliders);
        this.menuCheckVal = new GroupedCheckboxMenuItem(this.resources.getString("CE_SLIDER_VAL"), true, this.groupSliders);
        this.menuCheckRGB = new GroupedCheckboxMenuItem(this.resources.getString("CE_SLIDER_RGB"), false, this.groupSliders);
        this.menuCheckHSV = new GroupedCheckboxMenuItem(this.resources.getString("CE_SLIDER_HSV"), false, this.groupSliders);
        this.menuCheckRGBV = new GroupedCheckboxMenuItem(this.resources.getString("CE_SLIDER_RGBV"), false, this.groupSliders);
        this.menuCheckRGBHSV = new GroupedCheckboxMenuItem(this.resources.getString("CE_SLIDER_RGBHSV"), false, this.groupSliders);
        this.menuCheckNone.addItemListener(new ListenEditItems(13));
        this.menuCheckVal.addItemListener(new ListenEditItems(14));
        this.menuCheckRGB.addItemListener(new ListenEditItems(15));
        this.menuCheckHSV.addItemListener(new ListenEditItems(16));
        this.menuCheckRGBV.addItemListener(new ListenEditItems(17));
        this.menuCheckRGBHSV.addItemListener(new ListenEditItems(18));
        this.menuSliders.add(this.menuCheckNone);
        this.menuSliders.add(this.menuCheckVal);
        this.menuSliders.add(this.menuCheckRGB);
        this.menuSliders.add(this.menuCheckHSV);
        this.menuSliders.add(this.menuCheckRGBV);
        this.menuSliders.add(this.menuCheckRGBHSV);
        return menuBar;
    }

    private GridBagConstraints constraints(int n, int n2, int n3, int n4, float f, float f2, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = f;
        gridBagConstraints.weighty = f2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.insets = new Insets(n9, n10, n11, n12);
        return gridBagConstraints;
    }

    private void buildControls(GridBagLayout gridBagLayout) {
        this.current = new SwColorPatch();
        this.previous = new SwColorPatch();
        this.current.setColor(this.baseRGB);
        this.previous.setColor(this.baseRGB);
        this.rightButton = new SwImageButton(SwIcons.RIGHT_ARROW, 24, 12);
        this.switchButton = new SwImageButton(SwIcons.SWITCH_ARROW, 24, 12);
        this.leftButton = new SwImageButton(SwIcons.LEFT_ARROW, 24, 12);
        this.acceptButton = new Button(this.resources.getString("CE_BUTTON_ACCEPT"));
        if (this.updateFreq != 1) {
            this.acceptButton.setVisible(false);
        }
        gridBagLayout.setConstraints(this.current, this.constraints(0, 0, 2, 1, 0.0f, 0.0f, 10, 1, 0, 0, 2, 2, 2, 2));
        this.add(this.current);
        gridBagLayout.setConstraints(this.previous, this.constraints(2, 0, 2, 1, 0.0f, 0.0f, 10, 1, 0, 0, 2, 2, 2, 2));
        this.add(this.previous);
        gridBagLayout.setConstraints(this.rightButton, this.constraints(0, 1, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.rightButton);
        gridBagLayout.setConstraints(this.switchButton, this.constraints(1, 1, 2, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.switchButton);
        gridBagLayout.setConstraints(this.leftButton, this.constraints(3, 1, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.leftButton);
        gridBagLayout.setConstraints(this.acceptButton, this.constraints(0, 2, 4, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.acceptButton);
        this.rightButton.addMouseListener(new ListenButtons(7));
        this.switchButton.addMouseListener(new ListenButtons(8));
        this.leftButton.addMouseListener(new ListenButtons(9));
        this.acceptButton.addMouseListener(new ListenButtons(10));
    }

    private void doSliderLayout() {
        this.ignoreEvent = true;
        switch (this.whichSliders) {
            case 0: {
                break;
            }
            case 1: {
                this.sliders[5].setBaseColor(this.baseHSV);
                this.sliders[5].setVisible(true);
                break;
            }
            case 2: {
                for (int i = 0; i < 3; ++i) {
                    this.sliders[i].setBaseColor(this.baseRGB.getValue());
                    this.sliders[i].setVisible(true);
                }
                break;
            }
            case 3: {
                for (int i = 3; i < 6; ++i) {
                    this.sliders[i].setBaseColor(this.baseHSV);
                    this.sliders[i].setVisible(true);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < 3; ++i) {
                    this.sliders[i].setBaseColor(this.baseRGB.getValue());
                    this.sliders[i].setVisible(true);
                }
                this.sliders[5].setBaseColor(this.baseHSV);
                this.sliders[5].setVisible(true);
                break;
            }
            case 5: {
                int n;
                for (n = 0; n < 3; ++n) {
                    this.sliders[n].setBaseColor(this.baseRGB.getValue());
                    this.sliders[n].setVisible(true);
                }
                for (n = 3; n < 6; ++n) {
                    this.sliders[n].setBaseColor(this.baseHSV);
                    this.sliders[n].setVisible(true);
                }
                break;
            }
        }
        this.ignoreEvent = false;
    }

    private void buildSlidersPanel(GridBagLayout gridBagLayout) {
        int n;
        this.sliders[0] = new SwColorSlider(0, 30);
        this.sliders[1] = new SwColorSlider(1, 30);
        this.sliders[2] = new SwColorSlider(2, 30);
        this.sliders[3] = new SwColorSlider(3, 30);
        this.sliders[4] = new SwColorSlider(4, 30);
        this.sliders[5] = new SwColorSlider(5, 30);
        for (n = 0; n < 3; ++n) {
            this.sliders[n].setBaseColor(this.baseRGB.getValue());
        }
        for (n = 3; n < 6; ++n) {
            this.sliders[n].setBaseColor(this.baseHSV);
        }
        this.sliders[0].setLabel(this.resources.getString("CE_SLIDER_R"));
        this.sliders[1].setLabel(this.resources.getString("CE_SLIDER_G"));
        this.sliders[2].setLabel(this.resources.getString("CE_SLIDER_B"));
        this.sliders[3].setLabel(this.resources.getString("CE_SLIDER_H"));
        this.sliders[4].setLabel(this.resources.getString("CE_SLIDER_S"));
        this.sliders[5].setLabel(this.resources.getString("CE_SLIDER_V"));
        for (n = 0; n < 6; ++n) {
            this.sliders[n].addSliderListener(new ListenColorSlider(0 + n));
            gridBagLayout.setConstraints(this.sliders[n], this.constraints(0, n + 4, 5, 1, 1.0f, 1.0f, 18, 1, 0, 0, 0, 0, 0, 0));
            this.add(this.sliders[n]);
            this.sliders[n].setVisible(false);
        }
        this.doSliderLayout();
    }

    public void addColorChangedCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.addCallback(soCallbackListCB, object);
    }

    public void removeColorChangedCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.removeCallback(soCallbackListCB, object);
    }

    public void attach(SoSFColor soSFColor, SoBase soBase) {
        if (this.isAttached()) {
            this.detach();
        }
        if (soSFColor != null && soBase != null) {
            this.setColor(soSFColor.getValue());
            this.colorSF = soSFColor;
            this.editNode = soBase;
            this.colorSensor.attach((SoNode)soBase);
            this.attached = true;
        }
    }

    public void attach(SoMFColor soMFColor, int n, SoBase soBase) {
        if (this.isAttached()) {
            this.detach();
        }
        if (soMFColor != null && n >= 0 && soBase != null) {
            this.setColor(soMFColor.getValueAt(n));
            this.colorMF = soMFColor;
            this.editNode = soBase;
            this.colorSensor.attach((SoNode)soBase);
            this.attached = true;
        }
    }

    public void attach(SoMFInt32 soMFInt32, int n, SoBase soBase) {
        if (this.isAttached()) {
            this.detach();
        }
        if (soMFInt32 != null && n >= 0 && soBase != null) {
            SbColor sbColor = new SbColor();
            float[] fArray = new float[1];
            sbColor.setPackedValue((long)soMFInt32.getValueAt(n), fArray);
            this.setColor(sbColor);
            this.colorUInt32MF = soMFInt32;
            this.index = n;
            this.editNode = soBase;
            this.colorSensor.attach((SoNode)soBase);
            this.attached = true;
        }
    }

    public void detach() {
        if (!this.isAttached()) {
            return;
        }
        this.colorSensor.detach();
        this.editNode = null;
        this.colorSF = null;
        this.colorMF = null;
        this.colorUInt32MF = null;
        this.transparency = 0.0f;
        this.attached = true;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setColor(SbColor sbColor) {
        int n;
        if (sbColor.equals(this.baseRGB)) {
            return;
        }
        this.baseRGB.setValue(sbColor);
        this.baseRGB.getHSVValue(this.baseHSV);
        this.ignoreEvent = true;
        for (n = 0; n < 3; ++n) {
            this.sliders[n].setBaseColor(this.baseRGB.getValue());
        }
        for (n = 3; n < 6; ++n) {
            this.sliders[n].setBaseColor(this.baseHSV);
        }
        this.wheel.setBaseColor(this.baseHSV);
        this.current.setColor(this.baseRGB);
        this.ignoreEvent = false;
        if (this.updateFreq == 0) {
            this.doUpdates();
        }
    }

    public SbColor getColor() {
        return this.baseRGB;
    }

    public void setWYSIWYG(boolean bl) {
        if (this.WYSIWYGmode == bl) {
            return;
        }
        this.WYSIWYGmode = bl;
        for (int i = 0; i < 6; ++i) {
            this.sliders[i].setWYSIWYG(this.WYSIWYGmode);
        }
        this.wheel.setWYSIWYG(this.WYSIWYGmode);
        this.menuCheckWys.setState(this.WYSIWYGmode);
    }

    public boolean isWYSIWYG() {
        return this.WYSIWYGmode;
    }

    public void setCurrentSliders(int n) {
        if (this.whichSliders == n) {
            return;
        }
        int n2 = this.numberOfSliders(this.whichSliders);
        int n3 = this.numberOfSliders(n);
        for (int i = 0; i < 6; ++i) {
            this.sliders[i].setVisible(false);
        }
        this.whichSliders = n;
        this.doSliderLayout();
        switch (n) {
            case 0: {
                this.groupSliders.setSelectedCheckbox(this.menuCheckNone);
                break;
            }
            case 1: {
                this.groupSliders.setSelectedCheckbox(this.menuCheckVal);
                break;
            }
            case 2: {
                this.groupSliders.setSelectedCheckbox(this.menuCheckRGB);
                break;
            }
            case 3: {
                this.groupSliders.setSelectedCheckbox(this.menuCheckHSV);
                break;
            }
            case 4: {
                this.groupSliders.setSelectedCheckbox(this.menuCheckRGBV);
                break;
            }
            case 5: {
                this.groupSliders.setSelectedCheckbox(this.menuCheckRGBHSV);
            }
        }
    }

    public int getCurrentSliders() {
        return this.whichSliders;
    }

    public void setUpdateFrequency(int n) {
        if (this.updateFreq == n) {
            return;
        }
        this.updateFreq = n;
        if (this.acceptButton != null) {
            if (this.updateFreq == 0) {
                this.acceptButton.setVisible(false);
            } else {
                this.acceptButton.setVisible(true);
            }
        }
        if (this.updateFreq == 0) {
            this.doUpdates();
        }
        if (this.updateFreq == 0) {
            this.groupEdit.setSelectedCheckbox(this.menuCheckCont);
        } else {
            this.groupEdit.setSelectedCheckbox(this.menuCheckMan);
        }
    }

    public int getUpdateFrequency() {
        return this.updateFreq;
    }

    private void doUpdates() {
        if (this.attached) {
            if (this.colorSF != null) {
                this.colorSF.setValue(this.baseRGB);
                if (this.colorSF.isIgnored()) {
                    this.colorSF.setIgnored(false);
                }
            } else if (this.colorMF != null) {
                this.colorMF.set1Value(this.index, this.baseRGB);
                if (this.colorMF.isIgnored()) {
                    this.colorMF.setIgnored(false);
                }
            } else if (this.colorUInt32MF != null) {
                int n = this.baseRGB.getPackedValue(this.transparency);
                this.colorUInt32MF.set1Value(this.index, n);
                if (this.colorUInt32MF.isIgnored()) {
                    this.colorUInt32MF.setIgnored(false);
                }
            }
        }
        this.callbackList.invokeCallbacks(this.baseRGB);
    }

    private int numberOfSliders(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 6;
            }
        }
        return -1;
    }

    public void setResources(Locale locale) {
        this.resources = locale != null ? (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", locale) : (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources");
        this.setTitle(this.resources.getString("CE_TITLE"));
        this.sliders[0].setLabel(this.resources.getString("CE_SLIDER_R"));
        this.sliders[1].setLabel(this.resources.getString("CE_SLIDER_G"));
        this.sliders[2].setLabel(this.resources.getString("CE_SLIDER_B"));
        this.sliders[3].setLabel(this.resources.getString("CE_SLIDER_H"));
        this.sliders[4].setLabel(this.resources.getString("CE_SLIDER_S"));
        this.sliders[5].setLabel(this.resources.getString("CE_SLIDER_V"));
        this.menuCheckWys.setLabel(this.resources.getString("CE_EDIT_WYSIWIG"));
        this.menuHelp.setLabel(this.resources.getString("CE_EDIT_HELP"));
        this.menuClose.setLabel(this.resources.getString("CE_EDIT_CLOSE"));
        this.menuPaste.setLabel(this.resources.getString("CE_EDIT_PASTE"));
        this.menuCopy.setLabel(this.resources.getString("CE_EDIT_COPY"));
        this.menuCheckCont.setLabel(this.resources.getString("CE_EDIT_CONTINUOUS"));
        this.menuCheckMan.setLabel(this.resources.getString("CE_EDIT_MANUAL"));
        this.menuCheckNone.setLabel(this.resources.getString("CE_SLIDER_NONE"));
        this.menuCheckVal.setLabel(this.resources.getString("CE_SLIDER_VAL"));
        this.menuCheckRGB.setLabel(this.resources.getString("CE_SLIDER_RGB"));
        this.menuCheckHSV.setLabel(this.resources.getString("CE_SLIDER_HSV"));
        this.menuCheckRGBV.setLabel(this.resources.getString("CE_SLIDER_RGBV"));
        this.menuCheckRGBHSV.setLabel(this.resources.getString("CE_SLIDER_RGBHSV"));
        this.menuEdit.setLabel(this.resources.getString("CE_MENU_EDIT"));
        this.menuSliders.setLabel(this.resources.getString("CE_MENU_SLIDERS"));
        this.acceptButton.setLabel(this.resources.getString("CE_BUTTON_ACCEPT"));
    }

    class ColorEditorData {
        public short id;
        public SwColorEditor editor;

        ColorEditorData() {
        }
    }

    class ListenButtons
    extends MouseAdapter {
        int buttonId;

        public ListenButtons(int n) {
            this.buttonId = n;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof SwImageButton) {
                ((SwImageButton)object).setState(true);
            }
            SbColor sbColor = new SbColor();
            switch (this.buttonId) {
                case 7: {
                    SwColorEditor.this.previous.setColor(SwColorEditor.this.baseRGB);
                    break;
                }
                case 8: 
                case 9: {
                    sbColor.setValue(SwColorEditor.this.previous.getColor());
                    if (this.buttonId == 8) {
                        SwColorEditor.this.previous.setColor(SwColorEditor.this.baseRGB);
                    }
                    SwColorEditor.this.setColor(sbColor);
                    if (SwColorEditor.this.updateFreq == 1) break;
                    SwColorEditor.this.doUpdates();
                    break;
                }
                case 10: {
                    SwColorEditor.this.doUpdates();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof SwImageButton) {
                ((SwImageButton)object).setState(false);
            }
        }
    }

    class ListenEditItems
    implements ItemListener,
    ActionListener {
        int itemId;

        public ListenEditItems(int n) {
            this.itemId = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            switch (this.itemId) {
                case 11: {
                    SwColorEditor.this.setUpdateFrequency(0);
                    SwColorEditor.this.doLayout();
                    break;
                }
                case 12: {
                    SwColorEditor.this.setUpdateFrequency(1);
                    SwColorEditor.this.doLayout();
                    break;
                }
                case 19: {
                    SwColorEditor.this.setWYSIWYG(!SwColorEditor.this.WYSIWYGmode);
                    SwColorEditor.this.doLayout();
                    break;
                }
                case 13: {
                    SwColorEditor.this.setCurrentSliders(0);
                    SwColorEditor.this.pack();
                    break;
                }
                case 14: {
                    SwColorEditor.this.setCurrentSliders(1);
                    SwColorEditor.this.pack();
                    break;
                }
                case 15: {
                    SwColorEditor.this.setCurrentSliders(2);
                    SwColorEditor.this.pack();
                    break;
                }
                case 16: {
                    SwColorEditor.this.setCurrentSliders(3);
                    SwColorEditor.this.pack();
                    break;
                }
                case 17: {
                    SwColorEditor.this.setCurrentSliders(4);
                    SwColorEditor.this.pack();
                    break;
                }
                case 18: {
                    SwColorEditor.this.setCurrentSliders(5);
                    SwColorEditor.this.pack();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.itemId) {
                case 20: {
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    SwColorEditor.this.setVisible(false);
                }
            }
        }
    }

    class ListenColorSlider
    implements SliderListener {
        int i;
        int sliderId;

        public ListenColorSlider(int n) {
            this.sliderId = n;
        }

        @Override
        public void adjustmentStarted(SliderEvent sliderEvent) {
        }

        @Override
        public void adjustmentEnded(SliderEvent sliderEvent) {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            if (SwColorEditor.this.ignoreEvent) {
                return;
            }
            SwColorEditor.this.ignoreEvent = true;
            switch (this.sliderId) {
                case 0: 
                case 1: 
                case 2: {
                    SwColorEditor.this.baseRGB.setCoord(this.sliderId - 0, sliderEvent.getSliderValue());
                    SwColorEditor.this.baseRGB.getHSVValue(SwColorEditor.this.baseHSV);
                    this.i = 0;
                    while (this.i < 3) {
                        if (this.i != this.sliderId) {
                            SwColorEditor.this.sliders[this.i].setBaseColor(SwColorEditor.this.baseRGB.getValue());
                        }
                        ++this.i;
                    }
                    if (SwColorEditor.this.whichSliders == 4) {
                        SwColorEditor.this.sliders[5].setBaseColor(SwColorEditor.this.baseHSV);
                    } else if (SwColorEditor.this.whichSliders == 5) {
                        this.i = 3;
                        while (this.i < 6) {
                            SwColorEditor.this.sliders[this.i].setBaseColor(SwColorEditor.this.baseHSV);
                            ++this.i;
                        }
                    }
                    SwColorEditor.this.wheel.setBaseColor(SwColorEditor.this.baseHSV);
                    SwColorEditor.this.current.setColor(SwColorEditor.this.baseRGB);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    ((SwColorEditor)SwColorEditor.this).baseHSV[this.sliderId - 3] = sliderEvent.getSliderValue();
                    SwColorEditor.this.baseRGB.setHSVValue(SwColorEditor.this.baseHSV);
                    switch (SwColorEditor.this.whichSliders) {
                        case 5: {
                            this.i = 0;
                            while (this.i < 3) {
                                SwColorEditor.this.sliders[this.i].setBaseColor(SwColorEditor.this.baseRGB.getValue());
                                ++this.i;
                            }
                        }
                        case 3: {
                            this.i = 3;
                            while (this.i < 6) {
                                if (this.i != this.sliderId) {
                                    SwColorEditor.this.sliders[this.i].setBaseColor(SwColorEditor.this.baseHSV);
                                }
                                ++this.i;
                            }
                            break;
                        }
                        case 4: {
                            this.i = 0;
                            while (this.i < 3) {
                                SwColorEditor.this.sliders[this.i].setBaseColor(SwColorEditor.this.baseRGB.getValue());
                                ++this.i;
                            }
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    SwColorEditor.this.wheel.setBaseColor(SwColorEditor.this.baseHSV);
                    SwColorEditor.this.current.setColor(SwColorEditor.this.baseRGB);
                }
            }
            SwColorEditor.this.ignoreEvent = false;
            if (SwColorEditor.this.updateFreq == 0) {
                SwColorEditor.this.doUpdates();
            }
        }
    }

    class VisibilityChange
    extends ComponentAdapter {
        VisibilityChange() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (SwColorEditor.this.editNode != null && SwColorEditor.this.colorSensor.getAttachedNode() == null) {
                SwColorEditor.this.colorSensor.attach((SoNode)SwColorEditor.this.editNode);
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            SwColorEditor.this.colorSensor.detach();
        }
    }

    class WheelChanged
    extends SoCallbackListCB {
        WheelChanged() {
        }

        @Override
        public void invoke(Object object) {
            float[] fArray = (float[])object;
            ((SwColorEditor)SwColorEditor.this).baseHSV[0] = fArray[0];
            ((SwColorEditor)SwColorEditor.this).baseHSV[1] = fArray[1];
            SwColorEditor.this.baseRGB.setHSVValue(SwColorEditor.this.baseHSV[0], SwColorEditor.this.baseHSV[1], SwColorEditor.this.baseHSV[2]);
            SwColorEditor.this.ignoreEvent = true;
            switch (SwColorEditor.this.whichSliders) {
                case 0: {
                    break;
                }
                case 1: {
                    SwColorEditor.this.sliders[5].setBaseColor(SwColorEditor.this.baseHSV);
                    break;
                }
                case 2: 
                case 4: {
                    for (int i = 0; i < 3; ++i) {
                        SwColorEditor.this.sliders[i].setBaseColor(SwColorEditor.this.baseRGB.getValue());
                    }
                    if (SwColorEditor.this.whichSliders != 4) break;
                    SwColorEditor.this.sliders[5].setBaseColor(SwColorEditor.this.baseHSV);
                    break;
                }
                case 3: {
                    for (int i = 3; i < 6; ++i) {
                        SwColorEditor.this.sliders[i].setBaseColor(SwColorEditor.this.baseHSV);
                    }
                    break;
                }
                case 5: {
                    int n;
                    for (n = 0; n < 3; ++n) {
                        SwColorEditor.this.sliders[n].setBaseColor(SwColorEditor.this.baseRGB.getValue());
                    }
                    for (n = 3; n < 6; ++n) {
                        SwColorEditor.this.sliders[n].setBaseColor(SwColorEditor.this.baseHSV);
                    }
                    break;
                }
            }
            SwColorEditor.this.current.setColor(SwColorEditor.this.baseRGB);
            SwColorEditor.this.ignoreEvent = false;
            if (SwColorEditor.this.updateFreq == 0) {
                SwColorEditor.this.doUpdates();
            }
        }
    }

    class FieldChanged
    implements Runnable {
        FieldChanged() {
        }

        @Override
        public void run() {
            if (!SwColorEditor.this.isVisible()) {
                return;
            }
            if (SwColorEditor.this.colorSF != null) {
                SwColorEditor.this.setColor(SwColorEditor.this.colorSF.getValue());
            } else if (SwColorEditor.this.colorMF != null) {
                SwColorEditor.this.setColor(SwColorEditor.this.colorMF.getValueAt(SwColorEditor.this.index));
            } else if (SwColorEditor.this.colorUInt32MF != null) {
                SbColor sbColor = new SbColor();
                float[] fArray = new float[1];
                sbColor.setPackedValue((long)SwColorEditor.this.colorUInt32MF.getValueAt(SwColorEditor.this.index), fArray);
                SwColorEditor.this.transparency = fArray[0];
                SwColorEditor.this.setColor(sbColor);
            }
        }
    }
}

