/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.awt.event.SliderEvent;
import com.openinventor.awt.event.SliderListener;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.awt.SwSlider;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;

@Deprecated
public class SwColorSlider
extends SwSlider {
    public static final int RED_SLIDER = 0;
    public static final int GREEN_SLIDER = 1;
    public static final int BLUE_SLIDER = 2;
    public static final int HUE_SLIDER = 3;
    public static final int SATURATION_SLIDER = 4;
    public static final int VALUE_SLIDER = 5;
    public static final int INTENSITY_SLIDER = 6;
    private boolean WYSIWYGmode = false;
    private int type;
    private float[] color = new float[3];
    private SbColor[] defaultColors;
    private SbColor[] colors;
    private Rectangle innerRect = null;
    private Image img;

    public SwColorSlider() {
        this(6, 0);
    }

    public SwColorSlider(int n) {
        this(n, 0);
    }

    public SwColorSlider(int n, int n2) {
        super(n2);
        this.type = n;
        this.color[2] = 0.0f;
        this.color[1] = 0.0f;
        this.color[0] = 0.0f;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.colors = new SbColor[2];
                this.colors[0] = new SbColor();
                this.colors[1] = new SbColor();
                this.defaultColors = new SbColor[2];
                this.defaultColors[0] = new SbColor();
                this.defaultColors[1] = new SbColor();
                break;
            }
            case 3: {
                this.colors = new SbColor[7];
                this.defaultColors = new SbColor[7];
                for (int i = 0; i < 7; ++i) {
                    this.colors[i] = new SbColor();
                    this.defaultColors[i] = new SbColor();
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.colors = new SbColor[2];
                this.colors[0] = new SbColor();
                this.colors[1] = new SbColor();
                this.defaultColors = this.colors;
            }
        }
        this.makeDefaultColors();
        if (n != 6) {
            this.addSliderListener(new SliderChange());
        }
    }

    public void setBaseColor(float[] fArray) {
        boolean bl = false;
        float f = this.getValue();
        switch (this.type) {
            case 0: 
            case 3: {
                bl = this.WYSIWYGmode && (fArray[1] != this.color[1] || fArray[2] != this.color[2]);
                f = fArray[0];
                break;
            }
            case 1: {
                bl = this.WYSIWYGmode && (fArray[0] != this.color[0] || fArray[2] != this.color[2]);
                f = fArray[1];
                break;
            }
            case 2: {
                bl = this.WYSIWYGmode && (fArray[0] != this.color[0] || fArray[1] != this.color[1]);
                f = fArray[2];
                break;
            }
            case 4: {
                bl = fArray[0] != this.color[0] || this.WYSIWYGmode && fArray[2] != this.color[2];
                f = fArray[1];
                break;
            }
            case 5: {
                bl = fArray[0] != this.color[0] || this.WYSIWYGmode && fArray[1] != this.color[1];
                f = fArray[2];
                break;
            }
            case 6: {
                bl = fArray[0] != this.color[0] || fArray[1] != this.color[1] || fArray[2] != this.color[2];
            }
        }
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        if (bl) {
            this.makeWYSIWYGcolors();
        }
        if (f != this.getValue()) {
            this.setValue(f);
        } else if (bl) {
            this.redraw();
        }
    }

    public float[] getBaseColor() {
        return this.color;
    }

    public void setWYSIWYG(boolean bl) {
        if (this.WYSIWYGmode == bl) {
            return;
        }
        this.WYSIWYGmode = bl;
        if (this.WYSIWYGmode || this.type == 4 || this.type == 5) {
            this.makeWYSIWYGcolors();
        }
        if (this.isVisible()) {
            this.redraw();
        }
    }

    public boolean isWYSIWYG() {
        return this.WYSIWYGmode;
    }

    public int getType() {
        return this.type;
    }

    @Override
    void drawBackSlider(Graphics graphics, Dimension dimension) {
        SbColor[] sbColorArray = this.WYSIWYGmode ? this.colors : this.defaultColors;
        int n = dimension.width;
        int n2 = dimension.height;
        if (n <= 0 || n2 <= 0) {
            return;
        }
        int[] nArray = new int[n * n2];
        switch (this.type) {
            case 3: {
                float f = (float)n / 6.0f;
                float f2 = 0.0f;
                for (int i = 0; i < 6; ++i) {
                    this.fillPixelsWithShading(nArray, (int)f2, (int)(f2 + f), n, n2, sbColorArray[i].getValue(), sbColorArray[i + 1].getValue());
                    f2 += f;
                }
                break;
            }
            default: {
                this.fillPixelsWithShading(nArray, 0, n, n, n2, sbColorArray[0].getValue(), sbColorArray[1].getValue());
            }
        }
        this.img = this.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        graphics.drawImage(this.img, 0, 0, this);
    }

    private void fillPixelsWithShading(int[] nArray, int n, int n2, int n3, int n4, float[] fArray, float[] fArray2) {
        int n5;
        int n6;
        int n7;
        int n8 = n2 - n + 1;
        int[] nArray2 = new int[n3];
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = (fArray2[0] - fArray[0]) / (float)n8;
        float f5 = (fArray2[1] - fArray[1]) / (float)n8;
        float f6 = (fArray2[2] - fArray[2]) / (float)n8;
        for (n7 = n; n7 < n2; ++n7) {
            n6 = Math.round(f * 255.0f);
            n5 = Math.round(f2 * 255.0f);
            int n9 = Math.round(f3 * 255.0f);
            nArray2[n7] = 0xFF000000 | n6 << 16 | n5 << 8 | n9;
            f += f4;
            f2 += f5;
            f3 += f6;
        }
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = n3 * n7;
            for (n5 = n; n5 < n2; ++n5) {
                nArray[n6 + n5] = nArray2[n5];
            }
        }
    }

    private void makeDefaultColors() {
        SbColor[] sbColorArray = this.defaultColors;
        switch (this.type) {
            case 0: {
                sbColorArray[0].setValue(0.0f, 0.0f, 0.0f);
                sbColorArray[1].setValue(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                sbColorArray[0].setValue(0.0f, 0.0f, 0.0f);
                sbColorArray[1].setValue(0.0f, 1.0f, 0.0f);
                break;
            }
            case 2: {
                sbColorArray[0].setValue(0.0f, 0.0f, 0.0f);
                sbColorArray[1].setValue(0.0f, 0.0f, 1.0f);
                break;
            }
            case 3: {
                sbColorArray[0].setValue(1.0f, 0.0f, 0.0f);
                sbColorArray[1].setValue(1.0f, 1.0f, 0.0f);
                sbColorArray[2].setValue(0.0f, 1.0f, 0.0f);
                sbColorArray[3].setValue(0.0f, 1.0f, 1.0f);
                sbColorArray[4].setValue(0.0f, 0.0f, 1.0f);
                sbColorArray[5].setValue(1.0f, 0.0f, 1.0f);
                sbColorArray[6].setValue(1.0f, 0.0f, 0.0f);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                sbColorArray[0].setValue(0.0f, 0.0f, 0.0f);
                sbColorArray[1].setValue(0.0f, 0.0f, 0.0f);
            }
        }
    }

    private void makeWYSIWYGcolors() {
        SbColor[] sbColorArray = this.colors;
        switch (this.type) {
            case 0: {
                sbColorArray[0].setValue(0.0f, this.color[1], this.color[2]);
                sbColorArray[1].setValue(1.0f, this.color[1], this.color[2]);
                break;
            }
            case 1: {
                sbColorArray[0].setValue(this.color[0], 0.0f, this.color[2]);
                sbColorArray[1].setValue(this.color[0], 1.0f, this.color[2]);
                break;
            }
            case 2: {
                sbColorArray[0].setValue(this.color[0], this.color[1], 0.0f);
                sbColorArray[1].setValue(this.color[0], this.color[1], 1.0f);
                break;
            }
            case 3: {
                SbColor sbColor = new SbColor();
                sbColor.setHSVValue(this.color);
                float f = this.color[2];
                float f2 = sbColor.getX() < sbColor.getY() ? (sbColor.getX() < sbColor.getZ() ? sbColor.getX() : sbColor.getZ()) : (sbColor.getY() < sbColor.getZ() ? sbColor.getY() : sbColor.getZ());
                sbColorArray[0].setValue(f, f2, f2);
                sbColorArray[1].setValue(f, f, f2);
                sbColorArray[2].setValue(f2, f, f2);
                sbColorArray[3].setValue(f2, f, f);
                sbColorArray[4].setValue(f2, f2, f);
                sbColorArray[5].setValue(f, f2, f);
                sbColorArray[6].setValue(f, f2, f2);
                break;
            }
            case 4: {
                float f = this.WYSIWYGmode ? this.color[2] : 1.0f;
                sbColorArray[0].setValue(f, f, f);
                float[] fArray = new float[]{this.color[0], 1.0f, f};
                sbColorArray[1].setHSVValue(fArray);
                break;
            }
            case 5: {
                if (this.color[1] == 0.0f) {
                    sbColorArray[1].setValue(1.0f, 1.0f, 1.0f);
                    break;
                }
                float[] fArray = new float[]{this.color[0], this.WYSIWYGmode ? this.color[1] : 1.0f, 1.0f};
                sbColorArray[1].setHSVValue(fArray);
                break;
            }
            case 6: {
                sbColorArray[1].setValue(this.color);
            }
        }
    }

    class SliderChange
    implements SliderListener {
        SliderChange() {
        }

        @Override
        public void adjustmentStarted(SliderEvent sliderEvent) {
        }

        @Override
        public void adjustmentEnded(SliderEvent sliderEvent) {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            float f = sliderEvent.getSliderValue();
            switch (SwColorSlider.this.type) {
                case 0: 
                case 3: {
                    ((SwColorSlider)SwColorSlider.this).color[0] = f;
                    break;
                }
                case 1: 
                case 4: {
                    ((SwColorSlider)SwColorSlider.this).color[1] = f;
                    break;
                }
                case 2: 
                case 5: {
                    ((SwColorSlider)SwColorSlider.this).color[2] = f;
                    break;
                }
            }
        }
    }
}

