/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.misc.SoCallbackList;
import com.openinventor.inventor.misc.callbacks.SoCallbackListCB;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;

@Deprecated
public class SwColorWheel
extends Canvas {
    private boolean WYSIWYGmode;
    private boolean blackMarker;
    private float[] hsvColor = new float[3];
    private int radius;
    private Image wheelImage = null;
    private SoCallbackList startCallbacks;
    private SoCallbackList changedCallbacks;
    private SoCallbackList finishCallbacks;
    private boolean interactive;
    private static final int CIRCLE = 5;
    private static final int STRIPES = 32;
    private static final int SPACE = 4;
    private WheelRGBImageFilter filter;
    private int Xmarker;
    private int Ymarker;
    private boolean firstDraw = true;
    private Dimension lastSize = new Dimension(0, 0);
    private boolean markerIsVisible;

    public SwColorWheel() {
        ListenMouse listenMouse = new ListenMouse();
        this.addMouseListener(listenMouse);
        this.addMouseMotionListener(listenMouse);
        this.WYSIWYGmode = false;
        this.markerIsVisible = false;
        this.hsvColor[1] = 0.0f;
        this.hsvColor[0] = 0.0f;
        this.hsvColor[2] = 1.0f;
        this.startCallbacks = new SoCallbackList();
        this.changedCallbacks = new SoCallbackList();
        this.finishCallbacks = new SoCallbackList();
        this.interactive = false;
        this.Xmarker = this.getSize().width / 2;
        this.Ymarker = this.getSize().height / 2;
        this.filter = new WheelRGBImageFilter(1.0f);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public void addStartCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.startCallbacks.addCallback(soCallbackListCB, object);
    }

    public void addValueChangedCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.changedCallbacks.addCallback(soCallbackListCB, object);
    }

    public void addFinishCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.finishCallbacks.addCallback(soCallbackListCB, object);
    }

    public void removeStartCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.startCallbacks.removeCallback(soCallbackListCB, object);
    }

    public void removeValueChangedCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.changedCallbacks.removeCallback(soCallbackListCB, object);
    }

    public void removeFinishCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.finishCallbacks.removeCallback(soCallbackListCB, object);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setBaseColor(float[] fArray) {
        Graphics graphics;
        boolean bl = this.hsvColor[2] != fArray[2];
        boolean bl2 = this.WYSIWYGmode && bl;
        boolean bl3 = this.hsvColor[0] != fArray[0] || this.hsvColor[1] != fArray[1];
        this.hsvColor[0] = fArray[0];
        this.hsvColor[1] = fArray[1];
        this.hsvColor[2] = fArray[2];
        if (bl2 && (graphics = this.getGraphics()) != null) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawRect(this.Xmarker - 3, this.Ymarker - 3, 6, 6);
            this.redrawWheel(this.hsvColor[2]);
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawRect(this.Xmarker - 3, this.Ymarker - 3, 6, 6);
        }
        this.drawWheelMarker();
        if (bl3 || bl) {
            this.changedCallbacks.invokeCallbacks(this.hsvColor);
        }
    }

    public float[] getBaseColor() {
        return this.hsvColor;
    }

    public void setWYSIWYG(boolean bl) {
        if (this.WYSIWYGmode == bl) {
            return;
        }
        this.WYSIWYGmode = bl;
        this.redrawWheel(this.hsvColor[2]);
    }

    public boolean isWYSIWYG() {
        return this.WYSIWYGmode;
    }

    private void buildImage(Dimension dimension) {
        int n = dimension.width < dimension.height ? dimension.width : dimension.height;
        int n2 = n - 8;
        int[] nArray = new int[n2 * n2];
        int n3 = this.radius * this.radius;
        float f = (float)Math.PI * 2;
        for (int i = -this.radius; i < this.radius; ++i) {
            int n4 = i * i;
            int n5 = (i + this.radius) * n2;
            for (int j = -this.radius; j < this.radius; ++j) {
                int n6 = j * j;
                int n7 = j + this.radius;
                if (n6 + n4 <= n3) {
                    float f2;
                    float f3 = (float)Math.sqrt(n6 + n4) / (float)this.radius;
                    if (f3 > 1.0f) {
                        f3 = 1.0f;
                    }
                    if ((f2 = (float)Math.atan2(-i, j)) < 0.0f) {
                        f2 += f;
                    }
                    float f4 = f2 / f;
                    nArray[n5 + n7] = Color.HSBtoRGB(f4, f3, 1.0f);
                    continue;
                }
                nArray[n5 + n7] = 0;
            }
        }
        this.wheelImage = this.createImage(new MemoryImageSource(n2, n2, nArray, 0, n2));
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        if (!dimension.equals(this.lastSize)) {
            this.lastSize = dimension;
            int n = dimension.width < dimension.height ? dimension.width : dimension.height;
            int n2 = n - 8;
            this.radius = n2 / 2;
            float f = this.hsvColor[1] * (float)this.radius;
            float f2 = (float)Math.PI * 2 * this.hsvColor[0];
            this.Xmarker = (int)((float)dimension.width / 2.0f + f * (float)Math.cos(f2));
            this.Ymarker = (int)((float)dimension.height / 2.0f - f * (float)Math.sin(f2));
            this.buildImage(dimension);
        }
        this.redrawWheel(this.hsvColor[2]);
        this.markerIsVisible = false;
        this.drawWheelMarker(this.Xmarker, this.Ymarker);
    }

    private void redrawWheel(float f) {
        Image image;
        if (this.wheelImage == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.WYSIWYGmode) {
            this.filter.setIntensity(f);
            image = this.createImage(new FilteredImageSource(this.wheelImage.getSource(), this.filter));
        } else {
            image = this.wheelImage;
        }
        graphics.drawImage(image, dimension.width / 2 - this.radius, dimension.height / 2 - this.radius, null);
    }

    private synchronized void clearMarker() {
        Graphics graphics = this.getGraphics();
        if (this.markerIsVisible && graphics != null) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawRect(this.Xmarker - 3, this.Ymarker - 3, 6, 6);
            this.markerIsVisible = false;
        }
    }

    private void drawWheelMarker() {
        float f = this.hsvColor[1] * (float)this.radius;
        float f2 = (float)Math.PI * 2 * this.hsvColor[0];
        Dimension dimension = this.getSize();
        int n = (int)((float)(dimension.width / 2) + f * (float)Math.cos(f2));
        int n2 = (int)((float)(dimension.height / 2) - f * (float)Math.sin(f2));
        this.drawWheelMarker(n, n2);
    }

    private synchronized void drawWheelMarker(int n, int n2) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.clearMarker();
        graphics.setColor(Color.white);
        graphics.setXORMode(Color.black);
        graphics.drawRect(n - 3, n2 - 3, 6, 6);
        this.markerIsVisible = true;
        this.Xmarker = n;
        this.Ymarker = n2;
    }

    private void moveWheelMarker(int n, int n2) {
        float f;
        float f2;
        Dimension dimension = this.getSize();
        float f3 = n - dimension.width / 2;
        float f4 = dimension.height / 2 - n2;
        float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4) / (float)this.radius;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        if ((f2 = (float)Math.atan2(f4, f3)) < 0.0f) {
            f2 += (float)Math.PI * 2;
        }
        if (this.hsvColor[0] != (f = f2 / ((float)Math.PI * 2)) || this.hsvColor[1] != f5) {
            this.hsvColor[0] = f;
            this.hsvColor[1] = f5;
            this.drawWheelMarker(n, n2);
            this.changedCallbacks.invokeCallbacks(this.hsvColor);
        }
    }

    class WheelRGBImageFilter
    extends RGBImageFilter {
        float intensity;

        public WheelRGBImageFilter(float f) {
            this.intensity = f >= 0.0f && f <= 1.0f ? f : 1.0f;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = (int)((float)((n3 & 0xFF0000) >> 16) * this.intensity) << 16;
            int n5 = (int)((float)((n3 & 0xFF00) >> 8) * this.intensity) << 8;
            int n6 = (int)((float)(n3 & 0xFF) * this.intensity);
            return n3 & 0xFF000000 | n4 | n5 | n6;
        }

        public void setIntensity(float f) {
            if (f >= 0.0f && f <= 1.0f) {
                this.intensity = f;
            }
        }
    }

    class ListenMouse
    extends MouseAdapter
    implements MouseMotionListener {
        ListenMouse() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            Dimension dimension = SwColorWheel.this.getSize();
            int n2 = mouseEvent.getX() - dimension.width / 2;
            if (n2 * n2 + (n = mouseEvent.getY() - dimension.height / 2) * n <= (SwColorWheel.this.radius + 1) * (SwColorWheel.this.radius + 1)) {
                SwColorWheel.this.startCallbacks.invokeCallbacks(SwColorWheel.this.hsvColor);
                SwColorWheel.this.interactive = true;
                SwColorWheel.this.moveWheelMarker(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwColorWheel.this.interactive) {
                SwColorWheel.this.interactive = false;
                SwColorWheel.this.finishCallbacks.invokeCallbacks(SwColorWheel.this.hsvColor);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Dimension dimension = SwColorWheel.this.getSize();
            int n2 = mouseEvent.getX() - dimension.width / 2;
            if (n2 * n2 + (n = mouseEvent.getY() - dimension.height / 2) * n > (SwColorWheel.this.radius + 1) * (SwColorWheel.this.radius + 1)) {
                if (n2 == 0) {
                    n = SwColorWheel.this.radius;
                } else {
                    double d = Math.atan((float)n / (float)n2);
                    if (n2 < 0) {
                        d += Math.PI;
                    }
                    n2 = (int)(Math.cos(d) * (double)SwColorWheel.this.radius);
                    n = (int)(Math.sin(d) * (double)SwColorWheel.this.radius);
                }
            }
            SwColorWheel.this.moveWheelMarker(n2 += dimension.width / 2, n += dimension.height / 2);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

