/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.actions.SoRayPickAction;
import com.openinventor.inventor.awt.SwActiveArea;
import com.openinventor.inventor.nodes.SoCamera;

@Deprecated
public abstract class SwConstrainedArea
extends SwActiveArea {
    protected SbVec3f upDirection;
    float sceneHeight;
    SbVec2s startPos;
    private SbVec3f origUpDirection;
    private static double MinAngle = 0.08726646259971647;

    public SwConstrainedArea(int n) {
        super(true, true, n);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwConstrainedArea.SwConstrainedArea");
        }
        this.startPos = new SbVec2s();
        this.upDirection = new SbVec3f(0.0f, 1.0f, 0.0f);
        this.sceneHeight = 0.0f;
        this.origUpDirection = new SbVec3f();
    }

    public void setUpDirection(SbVec3f sbVec3f) {
        SbRotation sbRotation = new SbRotation(this.upDirection, sbVec3f);
        this.upDirection.setValue(sbVec3f);
        if (this.camera != null) {
            SbRotation sbRotation2 = sbRotation.times(this.camera.orientation.getValue());
            this.camera.orientation.setValue(sbRotation2);
            this.checkForCameraUpConstrain();
        }
    }

    public SbVec3f getUpDirection() {
        return this.upDirection;
    }

    public void findUpDirection(SbVec2s sbVec2s) {
        if (this.camera == null) {
            return;
        }
        SbVec2s sbVec2s2 = new SbVec2s((short)this.getSize().width, (short)this.getSize().height);
        SoRayPickAction soRayPickAction = new SoRayPickAction(new SbViewportRegion(sbVec2s2));
        soRayPickAction.setPoint(sbVec2s);
        soRayPickAction.setRadius(1.0f);
        soRayPickAction.setPickAll(false);
        soRayPickAction.apply(this.internalSceneRoot);
        SoPickedPoint soPickedPoint = soRayPickAction.getPickedPoint();
        if (soPickedPoint == null) {
            return;
        }
        SbVec3f sbVec3f = new SbVec3f(soPickedPoint.getNormal());
        SbVec3f sbVec3f2 = new SbVec3f(soPickedPoint.getPoint());
        SbVec3f sbVec3f3 = this.camera.position.getValue().minus(sbVec3f2);
        if (sbVec3f.dot(sbVec3f3) < 0.0f) {
            sbVec3f.negate();
        }
        this.setUpDirection(sbVec3f);
    }

    @Override
    public void setCamera(SoCamera soCamera) {
        super.setCamera(soCamera);
        if (this.camera != null) {
            this.checkForCameraUpConstrain();
        }
    }

    @Override
    public void changeCameraValues(SoCamera soCamera) {
        if (this.camera == null) {
            return;
        }
        if (!this.camera.getClass().equals(soCamera.getClass())) {
            return;
        }
        super.changeCameraValues(soCamera);
        this.checkForCameraUpConstrain();
    }

    @Override
    public void saveHomePosition() {
        super.saveHomePosition();
        this.origUpDirection.setValue(this.upDirection);
    }

    @Override
    public void resetToHomePosition() {
        super.resetToHomePosition();
        this.upDirection.setValue(this.origUpDirection);
    }

    @Override
    public void tiltCamera(float f) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwConstrainedArea.tiltCamera");
        }
        if (this.camera == null) {
            return;
        }
        SbMatrix sbMatrix = new SbMatrix();
        sbMatrix.setRotate(this.camera.orientation.getValue());
        float[] fArray = sbMatrix.getColumn(2);
        SbVec3f sbVec3f = new SbVec3f(-fArray[0], -fArray[1], -fArray[2]);
        SbRotation sbRotation = new SbRotation(sbVec3f, this.upDirection);
        SbRotation.AxisAngle axisAngle = sbRotation.decompose();
        SbVec3f sbVec3f2 = axisAngle.axis;
        float f2 = axisAngle.radians;
        if ((double)f2 > Math.PI) {
            f2 = (float)((double)f2 - Math.PI * 2);
        } else if ((double)f2 < -Math.PI) {
            f2 = (float)((double)f2 + Math.PI * 2);
        }
        if (f2 < 0.0f) {
            f2 = -f2;
            sbVec3f2.negate();
        }
        if ((double)f2 <= MinAngle && f > 0.0f || (double)f2 >= Math.PI - MinAngle && f < 0.0f) {
            return;
        }
        if (f > 0.0f && (double)f > (double)f2 - MinAngle) {
            f = (float)((double)f2 - MinAngle);
        } else if (f < 0.0f && (double)f < (double)f2 + MinAngle - Math.PI) {
            f = (float)((double)f2 + MinAngle - Math.PI);
        }
        sbRotation.setValue(sbVec3f2, f);
        SbRotation sbRotation2 = this.getCamera().orientation.getValue().times(sbRotation);
        this.camera.orientation.setValue(sbRotation2);
    }

    @Override
    public void xAxisCameraAction(float f) {
        this.tiltCamera(-f);
    }

    @Override
    public void yAxisCameraAction(float f) {
        if (this.getCamera() != null) {
            SbRotation sbRotation = new SbRotation(this.upDirection, f);
            SbRotation sbRotation2 = this.getCamera().orientation.getValue().times(sbRotation);
            this.getCamera().orientation.setValue(sbRotation2);
        }
    }

    @Override
    public void zAxisCameraAction(float f) {
        super.zAxisCameraAction(-f);
    }

    void checkForCameraUpConstrain() {
        if (this.camera == null) {
            return;
        }
        SbMatrix sbMatrix = new SbMatrix();
        sbMatrix.setRotate(this.camera.orientation.getValue());
        float[] fArray = sbMatrix.getColumn(2);
        SbVec3f sbVec3f = new SbVec3f(-fArray[0], -fArray[1], -fArray[2]);
        fArray = sbMatrix.getColumn(0);
        SbVec3f sbVec3f2 = new SbVec3f(fArray[0], fArray[1], fArray[2]);
        SbVec3f sbVec3f3 = sbVec3f.cross(this.upDirection);
        sbVec3f3.normalize();
        if (!sbVec3f3.equals(new SbVec3f(0.0f, 0.0f, 0.0f))) {
            SbRotation sbRotation = this.camera.orientation.getValue().times(new SbRotation(sbVec3f2, sbVec3f3));
            this.camera.orientation.setValue(sbRotation);
        }
    }

    public SbVec2s getStartingMousePosition() {
        return this.startPos;
    }

    @Override
    protected void computeSeekFinalOrientation() {
        super.computeSeekFinalOrientation();
        if (this.isDetailSeek()) {
            this.camera.orientation.setValue(this.m_seekFinalCameraOrientation);
            this.checkForCameraUpConstrain();
            this.m_seekFinalCameraOrientation.setValue(this.camera.orientation.getValue());
        } else {
            this.m_seekFinalCameraOrientation.setValue(this.camera.orientation.getValue());
        }
    }

    @Override
    public void recomputeSceneSize() {
        if (this.userSceneGraph == null || this.internalSceneRoot == null) {
            this.sceneHeight = 0.0f;
            this.sceneSize = 0.0f;
            return;
        }
        SoGetBoundingBoxAction soGetBoundingBoxAction = new SoGetBoundingBoxAction(new SbViewportRegion(this.getSize()));
        soGetBoundingBoxAction.apply(this.internalSceneRoot);
        SbBox3f sbBox3f = soGetBoundingBoxAction.getBoundingBox();
        if (sbBox3f.isEmpty()) {
            this.sceneHeight = 0.0f;
            this.sceneSize = 0.0f;
            return;
        }
        float[] fArray = sbBox3f.getSize().getValue();
        float f = fArray[0];
        this.sceneHeight = fArray[1];
        float f2 = fArray[2];
        float f3 = this.sceneSize = f > f2 ? f : f2;
        if (this.sceneSize <= 0.0f) {
            this.sceneSize = 0.0f;
        }
        if ((double)this.sceneHeight <= 0.0) {
            this.sceneHeight = 0.0f;
        }
    }
}

