/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.awt.event.SliderEvent;
import com.openinventor.awt.event.SliderListener;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.awt.SwColorEditor;
import com.openinventor.inventor.awt.SwColorSlider;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwRenderArea;
import com.openinventor.inventor.awt.SwResources;
import com.openinventor.inventor.draggers.SoDragger;
import com.openinventor.inventor.manips.SoDirectionalLightManip;
import com.openinventor.inventor.misc.SoCallbackList;
import com.openinventor.inventor.misc.callbacks.SoCallbackListCB;
import com.openinventor.inventor.misc.callbacks.SoDraggerCB;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoComplexity;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoEnvironment;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.sensors.SoNodeSensor;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

@Deprecated
public class SwDirectionalLightEditor
extends Frame {
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 250;
    static final boolean DEBUG = Inventor.VERBOSE_LEVEL > 0;
    static final int k_CONTROL_MENU = 0;
    static final int k_COLOR_EDITOR = 0;
    static final int k_COPY = 1;
    static final int k_PASTE = 2;
    static final int k_HELP = 3;
    static final int k_CLOSE = 4;
    private CameraSensorTask cameraSensorTask;
    Vector lightListeners;
    SwDirectionalLightEditor thisEditor;
    protected SoDirectionalLight dirLight;
    protected SoSeparator root;
    protected SoSeparator litStuff;
    protected SoPerspectiveCamera myCamera;
    protected SoCamera cameraToWatch;
    protected SwColorEditor colorEditor;
    protected SwColorSlider intensitySlider;
    protected SwRenderArea renderArea;
    protected SoNodeSensor lightSensor;
    protected SoNodeSensor cameraSensor;
    protected SoDirectionalLightManip dirLightManip;
    protected boolean ignoreCallback;
    protected SoCallbackList callbackList;
    protected SwResources resources;
    protected Locale defaultLocale;
    protected static String geomBuffer = "#Inventor V2.0 ascii\nSeparator {\n    DEF DIR_LIGHT_EDITOR_ROTATOR Group {\n\tLightModel { model PHONG }\n\tSeparator {\n\t    Transform {\n\t\tscaleFactor .2 .2 .2\n\t\trotation    1 0 0 -1.57079632679489661923  # PI/2\n\t\ttranslation 0 0 1.2\n\t    }\n\t    Cone {}\n\t}\n\tSeparator {\n\t    Transform {\n\t\tscaleFactor .08 .3 .08\n\t\trotation    1 0 0 -1.57079632679489661923  # PI/2\n\t\ttranslation 0 0 1.7\n\t    }\n\t    Cylinder {}\n\t}\n\tSeparator {\n\t    Transform {\n\t\tscaleFactor .1 .1 .1\n\t\trotation    1 0 0 -1.57079632679489661923  # PI/2\n\t\ttranslation 0 0 -1.1\n\t    }\n\t    Cone {}\n\t}\n    }\n    DEF dirLightEditorRotator Separator {\n\tMaterial {\n\t    diffuseColor\t[ 0.5 0.5 0.5 ]\n\t    emissiveColor\t[ 0.5 0.5 0.5 ]\n\t}\n\tDrawStyle { lineWidth 2 }\n\tUSE DIR_LIGHT_EDITOR_ROTATOR\n    }\n    DEF dirLightEditorRotatorActive Separator {\n\tMaterial {\n\t    diffuseColor\t[ 0.5 0.5 0.0 ]\n\t    emissiveColor\t[ 0.5 0.5 0.0 ]\n\t}\n\tDrawStyle { lineWidth 3 }\n\tUSE DIR_LIGHT_EDITOR_ROTATOR\n    }\n}\n";
    private MenuBar menubar;
    private Menu menuEdit;
    private MenuItem menuColorEditor;
    private MenuItem menuCopy;
    private MenuItem menuPaste;
    private MenuItem menuHelp;
    private MenuItem menuClose;

    public SwDirectionalLightEditor() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwDirectionalLightEditor.SwDirectionalLightEditor");
        }
        this.thisEditor = this;
        this.defaultLocale = SwPanel.defaultLocale;
        this.resources = (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", this.defaultLocale);
        this.setTitle(this.resources.getString("DL_TITLE"));
        this.addComponentListener(new ListenVisibility());
        this.dirLight = null;
        this.callbackList = new SoCallbackList();
        this.lightListeners = new Vector(2, 2);
        SoInput soInput = new SoInput();
        soInput.setBuffer(geomBuffer.getBytes());
        SoNode soNode = SoDB.readNode(soInput);
        boolean bl = soNode != null;
        this.dirLightManip = new SoDirectionalLightManip();
        SoDragger soDragger = this.dirLightManip.getDragger();
        SoNode soNode2 = SoNode.getByName("dirLightEditorRotator");
        if (soNode2 != null) {
            soDragger.setPart("rotator.rotator", soNode2);
        }
        if ((soNode2 = SoNode.getByName("dirLightEditorRotatorActive")) != null) {
            soDragger.setPart("rotator.rotatorActive", soNode2);
        }
        SoSeparator soSeparator = new SoSeparator();
        soDragger.setPart("translator.xTranslator.translator", soSeparator);
        soDragger.setPart("translator.yTranslator.translator", soSeparator);
        soDragger.setPart("translator.zTranslator.translator", soSeparator);
        soDragger.setPart("translator.xTranslator.translatorActive", soSeparator);
        soDragger.setPart("translator.yTranslator.translatorActive", soSeparator);
        soDragger.setPart("translator.zTranslator.translatorActive", soSeparator);
        soDragger.setPart("translator.yzTranslator.translator", soSeparator);
        soDragger.setPart("translator.xzTranslator.translator", soSeparator);
        soDragger.setPart("translator.xyTranslator.translator", soSeparator);
        soDragger.setPart("translator.yzTranslator.translatorActive", soSeparator);
        soDragger.setPart("translator.xzTranslator.translatorActive", soSeparator);
        soDragger.setPart("translator.xyTranslator.translatorActive", soSeparator);
        soDragger.setPart("rotator.feedback", soSeparator);
        soDragger.setPart("rotator.feedbackActive", soSeparator);
        soDragger.addValueChangedCallback(new DirLightManipCB(), this);
        this.colorEditor = null;
        this.intensitySlider = null;
        this.renderArea = null;
        this.ignoreCallback = false;
        this.lightSensor = new SoNodeSensor(new LightSensorTask());
        this.cameraSensor = new SoNodeSensor();
        this.cameraSensorTask = new CameraSensorTask();
        this.cameraSensor.setTask(this.cameraSensorTask);
        this.cameraToWatch = null;
        this.root = new SoSeparator();
        this.myCamera = new SoPerspectiveCamera();
        this.litStuff = new SoSeparator();
        SoEnvironment soEnvironment = new SoEnvironment();
        SoMaterial soMaterial = new SoMaterial();
        SoComplexity soComplexity = new SoComplexity();
        SoSphere soSphere = new SoSphere();
        this.litStuff.addChild(soEnvironment);
        this.litStuff.addChild(soMaterial);
        this.litStuff.addChild(soComplexity);
        this.litStuff.addChild(soSphere);
        this.litStuff.renderCaching.setValue(SoSeparator.Cachings.AUTO);
        this.root.addChild(this.myCamera);
        this.root.addChild(this.dirLightManip);
        this.root.addChild(this.litStuff);
        soEnvironment.ambientColor.setValue(1.0f, 1.0f, 1.0f);
        soEnvironment.ambientIntensity.setValue(0.5f);
        soMaterial.ambientColor.setValue(0.2f, 0.2f, 0.2f);
        soMaterial.diffuseColor.setValue(0.55f, 0.55f, 0.55f);
        soMaterial.specularColor.setValue(0.7f, 0.7f, 0.7f);
        soMaterial.shininess.setValue(1.0f);
        soComplexity.value.setValue(0.6f);
        this.buildGUI();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwDirectionalLightEditor.this.setVisible(false);
            }
        };
        this.addWindowListener(windowAdapter);
    }

    protected void finalize() throws Throwable {
        if (this.isAttached()) {
            this.detach();
        }
        super.finalize();
    }

    private MenuBar buildMenuBar() {
        this.menubar = new MenuBar();
        this.menuEdit = new Menu(this.resources.getString("DL_MENU_EDIT"));
        this.menubar.add(this.menuEdit);
        this.menuColorEditor = new MenuItem(this.resources.getString("DL_MENU_COLOR_EDITOR"));
        this.menuCopy = new MenuItem(this.resources.getString("DL_MENU_COPY"));
        this.menuPaste = new MenuItem(this.resources.getString("DL_MENU_PASTE"));
        this.menuHelp = new MenuItem(this.resources.getString("DL_MENU_HELP"));
        this.menuClose = new MenuItem(this.resources.getString("DL_MENU_CLOSE"));
        this.menuEdit.add(this.menuColorEditor);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuCopy);
        this.menuEdit.add(this.menuPaste);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuHelp);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuClose);
        this.menuColorEditor.addActionListener(new ListenMenuItem(0));
        this.menuCopy.addActionListener(new ListenMenuItem(1));
        this.menuPaste.addActionListener(new ListenMenuItem(2));
        this.menuHelp.addActionListener(new ListenMenuItem(3));
        this.menuClose.addActionListener(new ListenMenuItem(4));
        return this.menubar;
    }

    private void buildGUI() {
        this.intensitySlider = new SwColorSlider(6);
        this.intensitySlider.setLabel(this.resources.getString("DL_INTEN"));
        this.intensitySlider.addSliderListener(new ListenIntensitySlider());
        this.renderArea = new SwRenderArea();
        this.renderArea.setSceneGraph(this.root);
        this.myCamera.viewAll(this.litStuff, new SbViewportRegion(this.renderArea.getSize()), 2.0f);
        this.menubar = this.buildMenuBar();
        this.ignoreCallback = true;
        this.intensitySlider.setBaseColor(this.dirLightManip.color.getValue().getValue());
        this.ignoreCallback = false;
        this.setMenuBar(this.menubar);
        this.setLayout(new BorderLayout());
        this.add("Center", this.renderArea);
        this.add("South", this.intensitySlider);
        this.pack();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 250);
    }

    public void attach(SoPath soPath) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwDirectionalLightEditor.attach");
        }
        if (this.isAttached()) {
            this.detach();
        }
        if (soPath == null) {
            return;
        }
        if (soPath.getTail() instanceof SoDirectionalLight) {
            this.dirLight = (SoDirectionalLight)soPath.getTail();
            this.ignoreCallback = true;
            this.copyLight(this.dirLightManip, this.dirLight);
            this.ignoreCallback = false;
            SoSearchAction soSearchAction = new SoSearchAction();
            soSearchAction.setNodeClass(SoCamera.class, true);
            soSearchAction.apply(soPath);
            if (soSearchAction.getPath() != null) {
                this.cameraToWatch = (SoCamera)soSearchAction.getPath().getTail();
                this.cameraSensorTask.run();
            } else {
                if (this.cameraToWatch != null) {
                    this.cameraToWatch = null;
                }
                this.myCamera.orientation.setValue(0.0f, 0.0f, 0.0f, 1.0f);
                this.myCamera.position.setValue(0.0f, 0.0f, 0.0f);
                if (this.renderArea != null) {
                    this.myCamera.viewAll(this.litStuff, new SbViewportRegion(this.renderArea.getSize()), 2.0f);
                }
            }
            if (this.isVisible()) {
                this.activate();
            }
        }
    }

    public void detach() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwDirectionalLightEditor.detach");
        }
        if (this.isAttached()) {
            this.deactivate();
            if (this.cameraToWatch != null) {
                this.cameraToWatch = null;
            }
            this.dirLight = null;
        }
    }

    public boolean isAttached() {
        return this.dirLight != null;
    }

    public void setLight(SoDirectionalLight soDirectionalLight) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwDirectionalLightEditor.setLight");
        }
        if (this.dirLight != null) {
            this.lightSensor.detach();
            this.copyLight(this.dirLight, soDirectionalLight);
            this.lightSensor.attach(this.dirLight);
        }
        this.ignoreCallback = true;
        this.copyLight(this.dirLightManip, soDirectionalLight);
        this.ignoreCallback = false;
        this.updateLocalComponents();
        this.callbackList.invokeCallbacks(this.dirLightManip);
    }

    public SoDirectionalLight getLight() {
        return this.dirLight;
    }

    public void addLightChangedCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.addCallback(soCallbackListCB, object);
    }

    public void removeLightListener(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.removeCallback(soCallbackListCB, object);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.colorEditor != null) {
            this.colorEditor.show();
        } else if (!bl && this.colorEditor != null) {
            this.colorEditor.setVisible(bl);
        }
        super.setVisible(bl);
    }

    protected void copyLight(SoDirectionalLight soDirectionalLight, SoDirectionalLight soDirectionalLight2) {
        soDirectionalLight.color.setValue(soDirectionalLight2.color.getValue());
        soDirectionalLight.intensity.setValue(soDirectionalLight2.intensity.getValue());
        soDirectionalLight.direction.setValue(soDirectionalLight2.direction.getValue());
    }

    protected void updateLocalComponents() {
        if (this.colorEditor != null) {
            this.ignoreCallback = true;
            this.colorEditor.setColor(this.dirLightManip.color.getValue());
            this.ignoreCallback = false;
        }
        if (this.intensitySlider != null) {
            this.ignoreCallback = true;
            this.intensitySlider.setValue(this.dirLightManip.intensity.getValue());
            this.intensitySlider.setBaseColor(this.dirLightManip.color.getValue().getValue());
            this.ignoreCallback = false;
        }
    }

    private void pasteDone() {
    }

    private void activate() {
        this.updateLocalComponents();
        if (this.dirLight == null) {
            return;
        }
        if (this.lightSensor.getAttachedNode() == null) {
            this.lightSensor.attach(this.dirLight);
        }
        if (this.cameraToWatch != null) {
            this.cameraSensorTask.run();
            this.cameraSensor.attach(this.cameraToWatch);
        }
    }

    private void deactivate() {
        this.lightSensor.detach();
        this.cameraSensor.detach();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
    }

    public void setResources(Locale locale) {
        if (locale != null) {
            this.resources = (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", locale);
            this.defaultLocale = locale;
        }
        if (this.colorEditor != null) {
            this.colorEditor.setResources(locale);
        }
        this.setTitle(this.resources.getString("DL_TITLE"));
        this.menuEdit.setLabel(this.resources.getString("DL_MENU_EDIT"));
        this.menuColorEditor.setLabel(this.resources.getString("DL_MENU_COLOR_EDITOR"));
        this.menuCopy.setLabel(this.resources.getString("DL_MENU_COPY"));
        this.menuPaste.setLabel(this.resources.getString("DL_MENU_PASTE"));
        this.menuHelp.setLabel(this.resources.getString("DL_MENU_HELP"));
        this.menuClose.setLabel(this.resources.getString("DL_MENU_CLOSE"));
        this.intensitySlider.setLabel(this.resources.getString("DL_INTEN"));
    }

    class ListenMenuItem
    implements ActionListener {
        private int id;

        public ListenMenuItem(int n) {
            this.id = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.id) {
                case 0: {
                    if (SwDirectionalLightEditor.this.colorEditor == null) {
                        SwDirectionalLightEditor.this.colorEditor = new SwColorEditor();
                        SwDirectionalLightEditor.this.colorEditor.setCurrentSliders(0);
                        SwDirectionalLightEditor.this.colorEditor.setResources(SwDirectionalLightEditor.this.defaultLocale);
                        SwDirectionalLightEditor.this.colorEditor.addColorChangedCallback(new ColorEditorCB(), SwDirectionalLightEditor.this.thisEditor);
                    }
                    SwDirectionalLightEditor.this.colorEditor.show();
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    SwDirectionalLightEditor.this.setVisible(false);
                }
            }
        }
    }

    class ListenVisibility
    extends ComponentAdapter {
        ListenVisibility() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            SwDirectionalLightEditor.this.activate();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            SwDirectionalLightEditor.this.deactivate();
        }
    }

    class ColorEditorCB
    extends SoCallbackListCB {
        ColorEditorCB() {
        }

        @Override
        public void invoke(Object object) {
            SbColor sbColor = (SbColor)object;
            if (SwDirectionalLightEditor.this.ignoreCallback) {
                return;
            }
            if (SwDirectionalLightEditor.this.dirLight != null) {
                SwDirectionalLightEditor.this.lightSensor.detach();
                SwDirectionalLightEditor.this.dirLight.color.setValue(sbColor);
                SwDirectionalLightEditor.this.lightSensor.attach(SwDirectionalLightEditor.this.dirLight);
            }
            SwDirectionalLightEditor.this.ignoreCallback = true;
            SwDirectionalLightEditor.this.intensitySlider.setBaseColor(sbColor.getValue());
            SwDirectionalLightEditor.this.ignoreCallback = false;
            SwDirectionalLightEditor.this.ignoreCallback = true;
            SwDirectionalLightEditor.this.dirLightManip.color.setValue(sbColor);
            SwDirectionalLightEditor.this.ignoreCallback = false;
            SwDirectionalLightEditor.this.callbackList.invokeCallbacks(SwDirectionalLightEditor.this.dirLightManip);
        }
    }

    class ListenIntensitySlider
    implements SliderListener {
        ListenIntensitySlider() {
        }

        @Override
        public void adjustmentStarted(SliderEvent sliderEvent) {
        }

        @Override
        public void adjustmentEnded(SliderEvent sliderEvent) {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            if (SwDirectionalLightEditor.this.ignoreCallback) {
                return;
            }
            if (SwDirectionalLightEditor.this.dirLight != null) {
                SwDirectionalLightEditor.this.lightSensor.detach();
                SwDirectionalLightEditor.this.dirLight.intensity.setValue(sliderEvent.getSliderValue());
                SwDirectionalLightEditor.this.lightSensor.attach(SwDirectionalLightEditor.this.dirLight);
            }
            SwDirectionalLightEditor.this.ignoreCallback = true;
            SwDirectionalLightEditor.this.dirLightManip.intensity.setValue(sliderEvent.getSliderValue());
            SwDirectionalLightEditor.this.ignoreCallback = false;
            SwDirectionalLightEditor.this.callbackList.invokeCallbacks(SwDirectionalLightEditor.this.dirLightManip);
        }
    }

    class DirLightManipCB
    extends SoDraggerCB {
        DirLightManipCB() {
        }

        @Override
        public void invoke(SoDragger soDragger) {
            if (SwDirectionalLightEditor.this.ignoreCallback) {
                return;
            }
            if (SwDirectionalLightEditor.this.dirLight != null) {
                SwDirectionalLightEditor.this.lightSensor.detach();
                SwDirectionalLightEditor.this.dirLight.direction.setValue(SwDirectionalLightEditor.this.dirLightManip.direction.getValue());
                SwDirectionalLightEditor.this.lightSensor.attach(SwDirectionalLightEditor.this.dirLight);
            }
            SwDirectionalLightEditor.this.callbackList.invokeCallbacks(SwDirectionalLightEditor.this.dirLightManip);
        }
    }

    class LightSensorTask
    implements Runnable {
        LightSensorTask() {
        }

        @Override
        public void run() {
            if (!SwDirectionalLightEditor.this.isVisible()) {
                return;
            }
            SwDirectionalLightEditor.this.ignoreCallback = true;
            SwDirectionalLightEditor.this.copyLight(SwDirectionalLightEditor.this.dirLightManip, SwDirectionalLightEditor.this.dirLight);
            SwDirectionalLightEditor.this.ignoreCallback = false;
            SwDirectionalLightEditor.this.updateLocalComponents();
            SwDirectionalLightEditor.this.callbackList.invokeCallbacks(SwDirectionalLightEditor.this.dirLightManip);
        }
    }

    class CameraSensorTask
    implements Runnable {
        CameraSensorTask() {
        }

        @Override
        public void run() {
            if (SwDirectionalLightEditor.this.cameraToWatch != null) {
                SbRotation sbRotation = SwDirectionalLightEditor.this.cameraToWatch.orientation.getValue();
                SwDirectionalLightEditor.this.myCamera.orientation.setValue(sbRotation);
                SwDirectionalLightEditor.this.myCamera.viewAll(SwDirectionalLightEditor.this.litStuff, new SbViewportRegion(SwDirectionalLightEditor.this.renderArea.getSize()), 2.0f);
            }
        }
    }
}

