/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.awt.SwGLGraphicsConfig;
import com.openinventor.inventor.awt.SwGLGraphicsConfigTemplate;
import com.openinventor.inventor.awt.peer.SwDrawingAreaPeer;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.helpers.SbGLShareContext;
import java.awt.Canvas;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import sun.awt.SunToolkit;

@Deprecated
public abstract class SwDrawingArea
extends Canvas {
    static final boolean DEBUG = Inventor.VERBOSE_LEVEL > 0;
    private SwGLGraphicsConfigTemplate m_configTemplate = null;
    private SwGLGraphicsConfig m_glConfig = null;
    protected SwDrawingAreaPeer m_areaPeer = null;
    private boolean hascontext = false;
    private float m_lastFsaaQuality = 1.0f;
    boolean m_isFsaaHighQuality = false;
    private int m_fsaaMaxSamplesCount = -1;
    private boolean m_fsaaEnabled = false;
    private int m_fsaaSamplesCount = -1;

    public SwDrawingArea() {
        this(new SwGLGraphicsConfigTemplate());
    }

    public SwDrawingArea(SwGLGraphicsConfigTemplate swGLGraphicsConfigTemplate) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwDrawingArea.SwDrawingArea");
        }
        this.m_configTemplate = swGLGraphicsConfigTemplate;
        this.m_areaPeer = SwDrawingAreaPeer.createDrawingAreaPeer(this);
    }

    public void setGLGraphicsConfigTemplate(SwGLGraphicsConfigTemplate swGLGraphicsConfigTemplate) {
        this.m_configTemplate = swGLGraphicsConfigTemplate;
    }

    public SwGLGraphicsConfig getGLGraphicsConfig() {
        return this.m_glConfig;
    }

    @Override
    public void addNotify() throws UnsupportedOperationException {
        boolean bl;
        boolean bl2 = bl = !SunToolkit.isAWTLockHeldByCurrentThread();
        if (bl) {
            SunToolkit.awtLock();
        }
        try {
            this.m_glConfig = new SwGLGraphicsConfig(this.m_configTemplate);
            this.m_areaPeer.setArea(this);
            this.m_areaPeer.setGLGraphicsConfig(this.m_glConfig);
        }
        catch (Exception exception) {
            new UnsupportedOperationException("Cannot find any valid graphic configuration. \nPlease check the graphics board configuration.").printStackTrace();
            if (this.m_glConfig != null) {
                this.m_glConfig.dispose();
                this.m_glConfig = null;
            }
        }
        finally {
            if (bl) {
                SunToolkit.awtUnlock();
            }
            super.addNotify();
        }
    }

    @Override
    public void removeNotify() {
        boolean bl;
        boolean bl2 = bl = !SunToolkit.isAWTLockHeldByCurrentThread();
        if (bl) {
            SunToolkit.awtLock();
        }
        try {
            this.hascontext = false;
            this.m_areaPeer.glDestroyContext();
        }
        finally {
            if (bl) {
                SunToolkit.awtUnlock();
            }
        }
        super.removeNotify();
        this.m_areaPeer.setGraphicsConfiguration(null);
        this.m_glConfig.dispose();
        this.m_glConfig = null;
        this.m_areaPeer.setArea(null);
    }

    protected void resetNotify() throws UnsupportedOperationException {
        if (this.haveContext()) {
            boolean bl = this.isVisible();
            this.setVisible(false);
            this.removeNotify();
            this.addNotify();
            this.setVisible(bl);
        }
    }

    public boolean haveContext() {
        return this.hascontext;
    }

    public SwDrawingAreaPeer getAreaPeer() {
        return this.m_areaPeer;
    }

    public void setDoubleBuffer(boolean bl) throws UnsupportedOperationException {
        SwGLGraphicsConfigTemplate swGLGraphicsConfigTemplate = (SwGLGraphicsConfigTemplate)this.m_configTemplate.clone();
        int n = bl ? 1 : 3;
        this.m_configTemplate.setDoubleBuffer(n);
        try {
            this.resetNotify();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.m_configTemplate = swGLGraphicsConfigTemplate;
            throw unsupportedOperationException;
        }
    }

    public boolean isDoubleBuffer() {
        if (this.m_glConfig != null) {
            return this.m_glConfig.getDoubleBuffer();
        }
        return false;
    }

    public void setOpenGlStereoConfiguration(boolean bl) throws UnsupportedOperationException {
        if (this.hasOpenGlStereoConfiguration() == bl) {
            return;
        }
        SwGLGraphicsConfigTemplate swGLGraphicsConfigTemplate = (SwGLGraphicsConfigTemplate)this.m_configTemplate.clone();
        int n = bl ? 1 : 3;
        this.m_configTemplate.setStereo(n);
        try {
            SwGLGraphicsConfig swGLGraphicsConfig = new SwGLGraphicsConfig(this.m_configTemplate);
            if (swGLGraphicsConfig.getVisualId() == 0) {
                throw new UnsupportedOperationException("Cannot find any graphic configuration that with stereo support.\nPlease check the graphics board configuration.");
            }
            this.resetNotify();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.m_configTemplate = swGLGraphicsConfigTemplate;
            throw unsupportedOperationException;
        }
    }

    public boolean hasOpenGlStereoConfiguration() {
        if (this.m_glConfig != null) {
            return this.m_glConfig.getStereo();
        }
        return false;
    }

    void setColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.m_areaPeer.glColorMask(bl, bl2, bl3, bl4);
    }

    public void setFullSceneAntialiasing(boolean bl) throws UnsupportedOperationException {
        this.setFullSceneAntialiasing(bl, 1.0f);
    }

    public void setFullSceneAntialiasing(boolean bl, float f) throws UnsupportedOperationException {
        if (!this.m_fsaaEnabled && !bl) {
            return;
        }
        if (bl) {
            int n;
            try {
                n = this.getFullSceneAntialiasingMaxSamples();
                if (n <= 0) {
                    throw new IllegalArgumentException("GL config is not supported.");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedOperationException("setFullSceneAntialiasing: FSAA is not available on this device, " + illegalArgumentException.getMessage());
            }
            if ((double)f < 0.0) {
                f = 0.0f;
            }
            n = (int)((float)(n - 2) * f) + 2;
            n >>= 1;
            if ((n <<= 1) != this.m_fsaaSamplesCount || !this.m_fsaaEnabled) {
                SwGLGraphicsConfigTemplate swGLGraphicsConfigTemplate = (SwGLGraphicsConfigTemplate)this.m_configTemplate.clone();
                this.m_configTemplate.setFullSceneAntialiasing(1, n, n);
                try {
                    SwGLGraphicsConfig swGLGraphicsConfig = new SwGLGraphicsConfig(this.m_configTemplate);
                    if (swGLGraphicsConfig.getVisualId() == 0 || swGLGraphicsConfig.getFullSceneAntialiasingNumSamples() == 0 || !swGLGraphicsConfig.isFullSceneAntialiasingEnabled()) {
                        throw new UnsupportedOperationException("setFullSceneAntialiasing: Error cannot set any FSAA configuration, looks like FSSA is incompatible with the current pixel format, visualId:" + swGLGraphicsConfig.getVisualId() + ", numSamples:" + swGLGraphicsConfig.getFullSceneAntialiasingNumSamples() + ", fsaaEnabled:" + swGLGraphicsConfig.isFullSceneAntialiasingEnabled());
                    }
                    this.m_fsaaEnabled = true;
                    this.m_fsaaSamplesCount = swGLGraphicsConfig.getFullSceneAntialiasingNumSamples();
                    this.resetNotify();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.m_configTemplate = swGLGraphicsConfigTemplate;
                    throw unsupportedOperationException;
                }
            }
        } else {
            this.m_fsaaEnabled = false;
            this.m_fsaaSamplesCount = -1;
            this.m_configTemplate.setFullSceneAntialiasing(3, 0, 0);
            this.resetNotify();
        }
    }

    private int getFullSceneAntialiasingMaxSamples() {
        if (this.m_fsaaMaxSamplesCount == -1) {
            SwGLGraphicsConfigTemplate swGLGraphicsConfigTemplate = new SwGLGraphicsConfigTemplate(this.m_configTemplate);
            swGLGraphicsConfigTemplate.setFullSceneAntialiasing(1, 256, 256);
            SwGLGraphicsConfig swGLGraphicsConfig = new SwGLGraphicsConfig(swGLGraphicsConfigTemplate);
            this.m_fsaaMaxSamplesCount = swGLGraphicsConfig.getFullSceneAntialiasingNumSamples();
        }
        return this.m_fsaaMaxSamplesCount;
    }

    public boolean isFullSceneAntialiasingEnabled() {
        if (this.m_glConfig != null) {
            return this.m_glConfig.isFullSceneAntialiasingEnabled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFullSceneAntialiasingQuality() {
        boolean bl;
        boolean bl2 = bl = !SunToolkit.isAWTLockHeldByCurrentThread();
        if (bl) {
            SunToolkit.awtLock();
        }
        try {
            if (this.m_glConfig == null) {
                float f = 0.0f;
                return f;
            }
            float f = this.getFullSceneAntialiasingMaxSamples();
            if (f == 0.0f) {
                float f2 = 0.0f;
                return f2;
            }
            float f3 = (float)this.m_glConfig.getFullSceneAntialiasingNumSamples() / f;
            return f3;
        }
        finally {
            if (bl) {
                SunToolkit.awtUnlock();
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        boolean bl;
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwDrawingArea.paint");
        }
        if (!this.haveContext()) {
            this.createBufferStrategy(2);
        }
        ObjectManager.globalLock.lock();
        assert (EventQueue.isDispatchThread());
        boolean bl2 = bl = !SunToolkit.isAWTLockHeldByCurrentThread();
        assert (!bl);
        if (bl) {
            SunToolkit.awtLock();
        }
        try {
            if (!this.haveContext()) {
                this.firstPaint();
            }
            this.doPaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.err.println("Oops! Trying to repair render area...");
                    SwDrawingArea.this.resetNotify();
                }
            });
        }
        finally {
            if (bl) {
                SunToolkit.awtUnlock();
            }
            ObjectManager.globalLock.unlock();
        }
    }

    private static void callInitGuiThread() {
        try {
            Method method = SoDB.class.getDeclaredMethod("initGuiThread", new Class[0]);
            ObjectManager.helperFor(SoDB.class).invokeMethod(method, null, null);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    private void initGuiThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Current thread is not EventDispatchThread.");
        }
        SwDrawingArea.callInitGuiThread();
    }

    void firstPaint() {
        this.initGuiThread();
        this.m_areaPeer.glCreateContext();
        this.hascontext = true;
        this.m_areaPeer.glBindContext();
        if (this.isFullSceneAntialiasingEnabled()) {
            this.m_areaPeer.glEnable(32925);
            if (SwDrawingAreaPeer.supportFsaaHighQuality()) {
                this.m_areaPeer.glHint(34100, this.m_isFsaaHighQuality ? 4354 : 4353);
            }
        } else {
            this.m_areaPeer.glDisable(32925);
            if (SwDrawingAreaPeer.supportFsaaHighQuality()) {
                this.m_areaPeer.glHint(34100, 4353);
            }
        }
        this.m_areaPeer.glUnbindContext();
    }

    protected void doPaint() {
        this.m_areaPeer.glBindContext();
        this.m_areaPeer.glClearColor(1.0f, 0.0f, 0.0f, 0.0f);
        this.m_areaPeer.glClear(16384);
        this.m_areaPeer.glViewport(0, 0, this.getWidth(), this.getHeight());
        this.m_areaPeer.glLoadIdentity();
        this.m_areaPeer.glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
        this.m_areaPeer.glColor3ub(255, 255, 255);
        this.m_areaPeer.glBegin(9L);
        this.m_areaPeer.glVertex3fv(new float[]{0.1f, 0.1f, 0.0f});
        this.m_areaPeer.glVertex3fv(new float[]{0.9f, 0.1f, 0.0f});
        this.m_areaPeer.glVertex3fv(new float[]{0.9f, 0.9f, 0.0f});
        this.m_areaPeer.glVertex3fv(new float[]{0.1f, 0.9f, 0.0f});
        this.m_areaPeer.glEnd();
        this.m_areaPeer.glFlush();
        if (this.isDoubleBuffer()) {
            this.m_areaPeer.glSwapBuffers();
        }
        this.m_areaPeer.glUnbindContext();
    }

    public SbGLShareContext getGLSharedContext() {
        SoGLContext soGLContext = ObjectManager.getManagedObjectFor(SoGLContext.class, this.m_areaPeer.getGlContext());
        return new SbGLShareContext(soGLContext, this.m_areaPeer.getCacheContextId());
    }

    private class ContextKeeper
    extends Hashtable {
        private ContextKeeper() {
        }

        Vector find(long l) {
            Long l2;
            if (DEBUG) {
                System.err.println("DEBUG: JAVA MTHD->SwDrawingAreaPeer$ContextKeeper.find");
            }
            if (this.containsKey(l2 = new Long(l))) {
                return (Vector)this.get(l2);
            }
            Vector vector = new Vector();
            this.put(l2, vector);
            return vector;
        }

        long whichDisplay(long l) {
            if (DEBUG) {
                System.err.println("DEBUG: JAVA MTHD->SwDrawingAreaPeer$ContextKeeper.whichDisplay");
            }
            Enumeration enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                Long l2 = (Long)enumeration.nextElement();
                Enumeration enumeration2 = ((Vector)this.get(l2)).elements();
                while (enumeration2.hasMoreElements()) {
                    if ((Long)enumeration2.nextElement() != l) continue;
                    return l2;
                }
            }
            return -1L;
        }
    }
}

