/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbSphere;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewVolume;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.awt.SwActiveArea;
import com.openinventor.inventor.awt.SwCursor;
import com.openinventor.inventor.awt.SwDrawingArea;
import com.openinventor.inventor.awt.SwExaminerPreferences;
import com.openinventor.inventor.awt.SwPreferences;
import com.openinventor.inventor.awt.event.SwActiveAreaKeyboard;
import com.openinventor.inventor.awt.event.SwActiveAreaMouse;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.fields.SoSFTime;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoScale;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.projectors.SbSphereSheetProjector;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.util.Scene;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@Deprecated
public class SwExaminerArea
extends SwActiveArea {
    protected static final boolean UseAnimThread = false;
    protected static String[] mouseHelp = new String[]{"HELP_MOUSE_EXAM_SPIN", "HELP_MOUSE_EXAM_PAN", "HELP_MOUSE_EXAM_DOLLY", "HELP_MOUSE_EXAM_MENU"};
    private static String geometryBuffer = "#Inventor V2.0 ascii\nSeparator {     PickStyle { style UNPICKABLE }     LightModel { model BASE_COLOR }     MaterialBinding { value PER_PART }     DrawStyle { lineWidth 2 }     Coordinate3 { point [0 0 0, 1 0 0, 0 1 0, 0 0 1] }     BaseColor { rgb [1 0 0, 0 1 0, 0 0 1] }     IndexedLineSet { coordIndex [1, 0, 2, -1, 0, 3] }          LightModel { model PHONG }     MaterialBinding { value OVERALL }     Complexity { value .1 }     Separator {     \tMaterial { \t    diffuseColor    [ 0.5 0 0 ] \t    emissiveColor   [ 0.5 0 0 ] \t} \tTranslation { translation 1 0 0 }     \tRotationXYZ { axis Z angle -1.570796327 }     \tCone { bottomRadius .2 height .3 }     }     Separator {     \tMaterial { \t    diffuseColor    [ 0 0.5 0 ] \t    emissiveColor   [ 0 0.5 0 ] \t} \tTranslation { translation 0 1 0 }     \tCone { bottomRadius .2 height .3 }     }     Material { \tdiffuseColor    [ 0 0 0.5 ] \temissiveColor   [ 0 0 0.5 ]     }     Translation { translation 0 0 1 }     RotationXYZ { axis X angle 1.570796327 }     Cone { bottomRadius .2 height .3 } }";
    private static final int ROT_BUFF_SIZE = 3;
    private Scene.ViewingModes mode;
    private SbSphereSheetProjector sphereSheet;
    protected boolean animationEnabled;
    protected boolean animatingFlag;
    private boolean feedbackFlag;
    private int feedbackSize;
    private SoSeparator feedbackRoot;
    private SoSwitch feedbackSwitch;
    private SoTranslation feedbackTransNode;
    private SoScale feedbackScaleNode;
    private SoNode feedbackGeometry;
    protected SoFieldSensor animationSensor;
    private final SbRotation[] rotBuffer;
    private int firstIndex;
    private int lastIndex;
    private final SbRotation averageRotation;
    private final SbRotation cameraRotation;
    private boolean computeAverage;
    private long lastMotionTime;
    private final SbVec3f forward = new SbVec3f();
    private SbVec3f center = new SbVec3f();
    private final SbMatrix mx = new SbMatrix();
    private SbVec3f feedbackPos = null;
    private boolean isButton1Down = false;
    private boolean isButton2Down = false;
    AnimThread animThread = null;

    public SwExaminerArea() {
        this(0);
    }

    public SwExaminerArea(int n) {
        super(true, true, n);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.SwExaminerArea");
        }
        this.addComponentListener(new ListenExaminerComponent());
        this.addMouseDevice(new SwExaminerAreaMouse());
        this.addKeyboardDevice(new SwExaminerAreaKeyboard());
        this.mode = this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE;
        this.updateCursor();
        this.feedbackFlag = false;
        this.feedbackRoot = null;
        this.feedbackSwitch = null;
        this.feedbackSize = 20;
        this.animationEnabled = true;
        this.animatingFlag = false;
        this.rotBuffer = new SbRotation[3];
        for (int i = 0; i < 3; ++i) {
            this.rotBuffer[i] = new SbRotation();
        }
        this.animationSensor = new SoFieldSensor();
        this.averageRotation = new SbRotation();
        this.cameraRotation = new SbRotation();
        SbViewVolume sbViewVolume = new SbViewVolume();
        sbViewVolume.ortho(-1.0f, 1.0f, -1.0f, 1.0f, -10.0f, 10.0f);
        this.sphereSheet = new SbSphereSheetProjector();
        this.sphereSheet.setViewVolume(sbViewVolume);
        this.sphereSheet.setSphere(new SbSphere(new SbVec3f(0.0f, 0.0f, 0.0f), 0.7f));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.animationSensor.setTask(new AnimationTask());
        if (this.animatingFlag) {
            this.animationSensor.attach(this.getRealTime());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.animationSensor.detach();
    }

    @Override
    public SwPreferences getPreferencesPanel() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.getPreferencesPanel");
        }
        if (this.preferences == null) {
            this.preferences = new SwExaminerPreferences(this);
        }
        return this.preferences;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public Scene.ViewingModes getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Scene.ViewingModes viewingModes, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.setMode (" + viewingModes + ")");
        }
        if (this.mode == viewingModes) {
            return;
        }
        Dimension dimension = this.getSize();
        Scene.ViewingModes viewingModes2 = this.mode;
        this.mode = viewingModes;
        this.updateCursor();
        switch (viewingModes) {
            case PICK_MODE: {
                if (aWTEvent != null && aWTEvent instanceof InputEvent) {
                    long l = ((InputEvent)aWTEvent).getModifiers();
                    if ((l & 0x10L) != 0L && viewingModes2 != Scene.ViewingModes.SEEK_MODE) {
                        this.interactiveCountDec();
                    }
                    if ((l & 8L) != 0L && viewingModes2 != Scene.ViewingModes.SEEK_MODE) {
                        this.interactiveCountDec();
                    }
                }
                this.stopAnimating();
                break;
            }
            case SPIN_MODE_ACTIVE: {
                SbVec2f sbVec2f = new SbVec2f((float)this.locator.getX() / (float)dimension.width, (float)this.locator.getY() / (float)dimension.height);
                this.normalizeLocatorInsideView(sbVec2f);
                this.sphereSheet.project(sbVec2f);
                this.firstIndex = 0;
                this.lastIndex = -1;
                break;
            }
            case PAN_MODE_ACTIVE: {
                this.mx.setRotate(this.camera.orientation.getValue());
                float[] fArray = this.mx.getColumn(2);
                SbVec3f sbVec3f = new SbVec3f(-fArray[0], -fArray[1], -fArray[2]);
                SbVec3f sbVec3f2 = sbVec3f.times(this.camera.focalDistance.getValue());
                SbVec3f sbVec3f3 = sbVec3f2.plus(this.camera.position.getValue());
                this.focalPlane.setValue(new SbPlane(sbVec3f, sbVec3f3));
                SbViewVolume sbViewVolume = new SbViewVolume();
                sbViewVolume.setValue(this.camera.getViewVolume((float)dimension.width / (float)dimension.height));
                SbVec2f sbVec2f = new SbVec2f((float)this.locator.getX() / (float)dimension.width, (float)this.locator.getY() / (float)dimension.height);
                this.normalizeLocatorInsideView(sbVec2f);
                SbLine sbLine = sbViewVolume.projectPointToLine(sbVec2f);
                this.locator3D = this.focalPlane.intersect(sbLine);
            }
        }
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.setMode fin");
        }
    }

    @Override
    public void updateMode(AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.updateMode");
        }
        if (aWTEvent != null && aWTEvent instanceof MouseEvent) {
            long l = ((InputEvent)aWTEvent).getModifiers();
            if ((l & 0x10L) != 0L) {
                if (aWTEvent.getID() == 501) {
                    this.isButton1Down = true;
                } else if (aWTEvent.getID() == 502) {
                    this.isButton1Down = false;
                }
            } else if ((l & 8L) != 0L) {
                if (aWTEvent.getID() == 501) {
                    this.isButton2Down = true;
                } else if (aWTEvent.getID() == 502) {
                    this.isButton2Down = false;
                }
            }
        }
        if (this.isButton1Down && this.isButton2Down) {
            this.setMode(Scene.ViewingModes.DOLLY_MODE_ACTIVE, aWTEvent);
        } else if (this.isButton1Down) {
            if (((InputEvent)aWTEvent).isControlDown()) {
                if (((InputEvent)aWTEvent).isShiftDown()) {
                    this.setMode(Scene.ViewingModes.DOLLY_MODE_ACTIVE, aWTEvent);
                } else {
                    this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
                }
            } else if (((InputEvent)aWTEvent).isShiftDown()) {
                this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
            } else {
                this.setMode(Scene.ViewingModes.SPIN_MODE_ACTIVE, aWTEvent);
            }
        } else if (this.isButton2Down) {
            this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
        } else if (this.isSeekMode()) {
            this.setMode(Scene.ViewingModes.SEEK_MODE, aWTEvent);
        } else if (((InputEvent)aWTEvent).isControlDown() || ((InputEvent)aWTEvent).isShiftDown()) {
            this.setMode(Scene.ViewingModes.PAN_MODE, aWTEvent);
        } else if (this.isViewing()) {
            this.setMode(Scene.ViewingModes.VIEW_MODE, aWTEvent);
        } else {
            this.setMode(Scene.ViewingModes.PICK_MODE, aWTEvent);
        }
    }

    @Override
    public void viewAll() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.viewAll");
        }
        if (this.isAnimating()) {
            this.stopAnimating();
        }
        if (this.feedbackFlag && this.isViewing() && this.feedbackSwitch != null) {
            this.feedbackSwitch.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());
        }
        super.viewAll();
        if (this.feedbackFlag && this.isViewing() && this.feedbackSwitch != null) {
            this.feedbackSwitch.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_ALL.getValue());
        }
    }

    @Override
    public void resetToHomePosition() {
        if (this.isAnimating()) {
            this.stopAnimating();
        }
        super.resetToHomePosition();
    }

    @Override
    public void setCamera(SoCamera soCamera) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.setCamera camera = " + this.camera);
        }
        if (this.camera == soCamera) {
            return;
        }
        if (this.feedbackFlag) {
            this.setFeedbackVisibility(false);
            this.feedbackFlag = true;
        }
        super.setCamera(soCamera);
        if (this.feedbackFlag) {
            this.feedbackFlag = false;
            this.setFeedbackVisibility(true);
        }
        this.notifySceneHandlers();
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.setCamera fin");
        }
    }

    @Override
    public void setViewing(boolean bl, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.setViewing");
        }
        if (bl == this.viewingFlag) {
            return;
        }
        super.setViewing(bl, aWTEvent);
        this.setMode(this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE, aWTEvent);
        if (this.feedbackFlag && this.feedbackSwitch != null) {
            this.feedbackSwitch.whichChild.setValue(this.viewingFlag ? SoSwitch.WhichChild.SO_SWITCH_ALL.getValue() : SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());
        }
    }

    @Override
    public void setAnimationEnabled(boolean bl) {
        if (this.animationEnabled == bl) {
            return;
        }
        this.animationEnabled = bl;
        if (!this.animationEnabled && this.isAnimating()) {
            this.stopAnimating();
        }
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    @Override
    public void setAnimating(boolean bl) {
        this.animatingFlag = bl;
    }

    @Override
    public boolean isAnimating() {
        return this.animatingFlag;
    }

    @Override
    public void stopAnimating() {
        if (this.animatingFlag) {
            this.animatingFlag = false;
            this.animationSensor.detach();
            this.animationSensor.unschedule();
            this.interactiveCountDec();
        }
        this.animThread = null;
    }

    @Override
    public void setSeekMode(boolean bl) {
        if (this.isAnimating()) {
            this.stopAnimating();
        }
        super.setSeekMode(bl);
        this.setMode(this.isSeekMode() ? Scene.ViewingModes.SEEK_MODE : (this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE), null);
    }

    @Override
    public void rotateCamera(SbRotation sbRotation) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.rotateCamera");
        }
        if (this.camera == null) {
            return;
        }
        this.camera.enableNotify(false);
        SbRotation sbRotation2 = this.camera.orientation.getValue();
        float f = this.camera.focalDistance.getValue();
        this.mx.setRotate(sbRotation2);
        float[] fArray = this.mx.getColumn(2);
        this.forward.setValue(-fArray[0], -fArray[1], -fArray[2]);
        this.forward.multiply(f);
        this.center = this.camera.position.getValue().plus(this.forward);
        sbRotation2 = sbRotation.times(sbRotation2);
        this.camera.orientation.setValue(sbRotation2);
        this.mx.setRotate(sbRotation2);
        fArray = this.mx.getColumn(2);
        this.forward.setValue(-fArray[0], -fArray[1], -fArray[2]);
        this.forward.multiply(f);
        this.center.substract(this.forward);
        this.camera.position.setValue(this.center);
        this.camera.enableNotify(true);
        this.camera.touch();
    }

    @Override
    public void xAxisCameraAction(float f) {
        SbVec3f sbVec3f = new SbVec3f(1.0f, 0.0f, 0.0f);
        this.cameraRotation.setValue(sbVec3f, f);
        this.rotateCamera(this.cameraRotation);
    }

    @Override
    public void yAxisCameraAction(float f) {
        SbVec3f sbVec3f = new SbVec3f(0.0f, 1.0f, 0.0f);
        this.cameraRotation.setValue(sbVec3f, f);
        this.rotateCamera(this.cameraRotation);
    }

    @Override
    public void spinCamera(SbVec2f sbVec2f) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.spinCamera");
        }
        this.lastIndex = (this.lastIndex + 1) % 3;
        this.rotBuffer[this.lastIndex] = this.sphereSheet.projectAndGetRotation(sbVec2f);
        this.rotBuffer[this.lastIndex].invert();
        this.rotateCamera(this.rotBuffer[this.lastIndex]);
        if ((this.lastIndex + 1) % 3 == this.firstIndex) {
            this.firstIndex = (this.firstIndex + 1) % 3;
        }
    }

    @Override
    public void setFeedbackVisibility(boolean bl) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.setFeedbackVisibility");
        }
        if (bl == this.feedbackFlag || this.camera == null) {
            this.feedbackFlag = bl;
            return;
        }
        SoSearchAction soSearchAction = new SoSearchAction();
        soSearchAction.setNode(bl ? this.camera : this.feedbackRoot);
        soSearchAction.apply(this.internalSceneRoot);
        SoPath soPath = soSearchAction.getPath();
        if (soPath == null) {
            return;
        }
        SoGroup soGroup = (SoGroup)soPath.regular.getNode(soPath.regular.getLength() - 2);
        this.feedbackFlag = bl;
        if (this.feedbackRoot == null) {
            this.createFeedbackNodes();
        }
        if (this.feedbackFlag) {
            if (soGroup.findChild(this.feedbackRoot) >= 0) {
                return;
            }
            if (this.isHeadlight()) {
                soGroup.insertChild(this.feedbackRoot, soGroup.findChild(this.camera) + 2);
            } else {
                soGroup.insertChild(this.feedbackRoot, soGroup.findChild(this.camera) + 1);
            }
            this.feedbackSwitch.whichChild.setValue(this.viewingFlag ? SoSwitch.WhichChild.SO_SWITCH_ALL.getValue() : SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());
        } else {
            soGroup.removeChild(this.feedbackRoot);
        }
    }

    @Override
    public boolean isFeedbackVisible() {
        return this.feedbackFlag;
    }

    @Override
    public void setFeedbackSize(int n) {
        if (this.feedbackSize == n) {
            return;
        }
        this.feedbackSize = n;
        if (this.isFeedbackVisible() && this.isViewing()) {
            this.scheduleRedraw();
        }
    }

    @Override
    public int getFeedbackSize() {
        return this.feedbackSize;
    }

    protected void doSpinAnimation() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.doSpinAnimation");
        }
        if (this.computeAverage) {
            int n = (this.lastIndex - this.firstIndex + 1 + 3) % 3;
            if (n < 2) {
                this.stopAnimating();
                return;
            }
            SbVec3f sbVec3f = this.rotBuffer[this.firstIndex].decompose().axis;
            float f = 0.0f;
            for (int i = 0; i < n; ++i) {
                int n2 = (this.firstIndex + i) % 3;
                float f2 = this.rotBuffer[n2].decompose().radians;
                f += f2;
            }
            this.averageRotation.setValue(sbVec3f, f /= (float)n);
            this.computeAverage = false;
        }
        this.rotateCamera(this.averageRotation);
    }

    protected void createFeedbackNodes() {
        if (this.feedbackRoot != null) {
            return;
        }
        this.feedbackRoot = new SoSeparator();
        this.feedbackSwitch = new SoSwitch();
        this.feedbackTransNode = new SoTranslation();
        this.feedbackScaleNode = new SoScale();
        this.feedbackRoot.addChild(this.feedbackSwitch);
        this.feedbackSwitch.addChild(this.feedbackTransNode);
        this.feedbackSwitch.addChild(this.feedbackScaleNode);
        SoInput soInput = new SoInput();
        soInput.setBuffer(geometryBuffer.getBytes());
        if (this.feedbackGeometry == null) {
            this.feedbackGeometry = SoDB.readNode(soInput);
        }
        if (this.feedbackGeometry != null) {
            this.feedbackSwitch.addChild(this.feedbackGeometry);
        }
    }

    public void setFeedbackGeometry(SoNode soNode) {
        if (this.feedbackSwitch != null) {
            this.feedbackSwitch.removeChild(this.feedbackGeometry);
        }
        this.feedbackGeometry = soNode;
        if (this.feedbackSwitch != null) {
            this.feedbackSwitch.addChild(this.feedbackGeometry);
        }
    }

    @Override
    public void updateCursor() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->ExaminerArea.updateCursor");
        }
        switch (this.mode) {
            case PICK_MODE: {
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case SPIN_MODE_ACTIVE: 
            case VIEW_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(101));
                break;
            }
            case DOLLY_MODE_ACTIVE: {
                this.setCursor(SwCursor.getPredefinedCursor(103));
                break;
            }
            case PAN_MODE_ACTIVE: 
            case PAN_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(102));
                break;
            }
            case SEEK_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(105));
            }
        }
    }

    public void setLastMotionTime(long l) {
        this.lastMotionTime = l;
    }

    public long getLastMotionTime() {
        return this.lastMotionTime;
    }

    @Override
    public SoSFTime getRealTime() {
        return areaRealTime;
    }

    @Override
    public void actualRedraw() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->ExaminerArea.actualRedraw");
        }
        if (this.isViewing() && this.feedbackFlag && this.camera != null && this.feedbackRoot != null) {
            float f;
            this.mx.setRotate(this.camera.orientation.getValue());
            if (this.feedbackPos == null) {
                this.feedbackPos = new SbVec3f();
            }
            this.feedbackPos.setValue(this.mx.getColumn(2));
            this.feedbackPos.multiply(-this.camera.focalDistance.getValue());
            this.feedbackPos.add(this.camera.position.getValue());
            if (!this.feedbackTransNode.translation.getValue().equals(this.feedbackPos)) {
                this.feedbackTransNode.translation.setValue(this.feedbackPos);
            }
            float f2 = 0.0f;
            if (this.camera instanceof SoPerspectiveCamera) {
                f = ((SoPerspectiveCamera)this.camera).heightAngle.getValue();
                f2 = (float)((double)this.camera.focalDistance.getValue() * Math.tan(f / 2.0f));
            } else if (this.camera instanceof SoOrthographicCamera) {
                f2 = ((SoOrthographicCamera)this.camera).height.getValue() / 2.0f;
            }
            if (this.getSize().height != 0) {
                f = 2.0f * (f2 * (float)this.feedbackSize / (float)this.getSize().height);
                if (this.feedbackScaleNode.scaleFactor.getValue().getX() != f) {
                    this.feedbackScaleNode.scaleFactor.setValue(f, f, f);
                }
            }
        }
        super.actualRedraw();
    }

    public void setComputeAverage(boolean bl) {
        this.computeAverage = bl;
    }

    public SoFieldSensor getAnimationSensor() {
        return this.animationSensor;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
    }

    @Override
    public String[] getMouseResourcesName() {
        return mouseHelp;
    }

    class AnimThread
    extends Thread {
        public AnimThread() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            System.out.println("Start AnimThread");
            while (SwExaminerArea.this.isAnimating()) {
                SwExaminerArea.this.doSpinAnimation();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class SwExaminerAreaMouse
    extends SwActiveAreaMouse {
        SbVec2f locatorF = new SbVec2f();

        SwExaminerAreaMouse() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            int n = mouseEvent.getModifiers();
            if ((n & 4) != 0) {
                return;
            }
            Dimension dimension = SwExaminerArea.this.getSize();
            SwExaminerArea.this.setLocator(mouseEvent.getX(), dimension.height - mouseEvent.getY());
            if (SwExaminerArea.this.mode == Scene.ViewingModes.SEEK_MODE) {
                SwExaminerArea.this.seekToPoint(SwExaminerArea.this.locator);
            } else {
                SwExaminerArea.this.interactiveCountInc();
                SwExaminerArea.this.updateMode(mouseEvent);
            }
            SwExaminerArea.this.stopAnimating();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            int n = mouseEvent.getModifiers();
            if ((n & 4) != 0) {
                return;
            }
            if (SwExaminerArea.this.mode == Scene.ViewingModes.SPIN_MODE_ACTIVE && SwExaminerArea.this.isAnimationEnabled() && mouseEvent.getWhen() - SwExaminerArea.this.getLastMotionTime() < 100L) {
                SwExaminerArea.this.setComputeAverage(true);
                SwExaminerArea.this.setAnimating(true);
                SwExaminerArea.this.getAnimationSensor().attach(SwActiveArea.areaRealTime);
                SwExaminerArea.this.interactiveCountInc();
            }
            SwExaminerArea.this.interactiveCountDec();
            SwExaminerArea.this.updateMode(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            Dimension dimension = SwExaminerArea.this.getSize();
            switch (SwExaminerArea.this.mode) {
                case SPIN_MODE_ACTIVE: {
                    SwExaminerArea.this.setLastMotionTime(mouseEvent.getWhen());
                    this.locatorF.setValue((float)mouseEvent.getX() / (float)dimension.width, (float)(dimension.height - mouseEvent.getY()) / (float)dimension.height);
                    SwExaminerArea.this.normalizeLocatorInsideView(this.locatorF);
                    SwExaminerArea.this.spinCamera(this.locatorF);
                    break;
                }
                case PAN_MODE_ACTIVE: {
                    this.locatorF.setValue((float)mouseEvent.getX() / (float)dimension.width, (float)(dimension.height - mouseEvent.getY()) / (float)dimension.height);
                    SwExaminerArea.this.normalizeLocatorInsideView(this.locatorF);
                    SwExaminerArea.this.panCamera(this.locatorF);
                    break;
                }
                case DOLLY_MODE_ACTIVE: {
                    SwExaminerArea.this.dollyCamera(new SbVec2s((short)mouseEvent.getX(), (short)(dimension.height - mouseEvent.getY())));
                }
            }
        }
    }

    class SwExaminerAreaKeyboard
    extends SwActiveAreaKeyboard {
        boolean pressed = true;

        SwExaminerAreaKeyboard() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            SoKeyboardEvent.Keys keys;
            if (this.pressed) {
                super.keyPressed(keyEvent);
                if (keyEvent.isConsumed()) {
                    return;
                }
            }
            if ((keys = SoKeyboardEvent.getKeySym(keyEvent.getKeyCode())) == SoKeyboardEvent.Keys.LEFT_CONTROL || keys == SoKeyboardEvent.Keys.RIGHT_CONTROL || keys == SoKeyboardEvent.Keys.LEFT_SHIFT || keys == SoKeyboardEvent.Keys.RIGHT_SHIFT) {
                SwExaminerArea.this.updateMode(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            super.keyReleased(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
            this.pressed = false;
            this.keyPressed(keyEvent);
            this.pressed = true;
        }
    }

    class AnimationTask
    implements Runnable {
        AnimationTask() {
        }

        @Override
        public void run() {
            SwExaminerArea.this.doSpinAnimation();
        }
    }

    class ListenExaminerComponent
    extends ComponentAdapter {
        ListenExaminerComponent() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (SwDrawingArea.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->ListenExaminerComponent.componentHidden");
            }
            SwExaminerArea swExaminerArea = (SwExaminerArea)componentEvent.getSource();
            if (!swExaminerArea.animatingFlag) {
                return;
            }
            swExaminerArea.animationSensor.detach();
            swExaminerArea.animationSensor.unschedule();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (SwDrawingArea.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->ListenExaminerComponent.componentShown");
            }
            SwExaminerArea swExaminerArea = (SwExaminerArea)componentEvent.getSource();
            if (!swExaminerArea.animatingFlag) {
                return;
            }
            swExaminerArea.animationSensor.attach(swExaminerArea.getRealTime());
            swExaminerArea.repaint(0L);
        }
    }
}

