/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwPreferences;
import com.openinventor.inventor.awt.SwScene;
import com.openinventor.inventor.awt.SwWheel;
import com.openinventor.inventor.awt.event.SwWheelEvent;
import com.openinventor.inventor.awt.event.SwWheelListener;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;

@Deprecated
public class SwExaminerPreferences
extends SwPreferences {
    private Checkbox cbSpinAnim;
    private Checkbox cbRotAxes;
    private Panel rotAxes;
    private Label axesLabel;
    private Label axesUnit;
    private TextField axesText;
    private SwWheel axesWheel;
    private float feedbackSizeWheelVal = 0.0f;

    public SwExaminerPreferences(SwScene swScene) {
        super(swScene);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.SwExaminerPreferences");
        }
    }

    @Override
    protected void buildGUI() {
        super.buildGUI();
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.buildGUI");
        }
        this.addPreferences(new ExaminerPref());
    }

    @Override
    public void updateLocalComponents() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.updateLocalComponents");
        }
        this.cbRotAxes.setState(this.scene.isFeedbackVisible());
        this.rotAxes.setEnabled(this.cbRotAxes.getState());
        this.axesWheel.setEnabled(this.cbRotAxes.getState());
        this.axesText.setText(Integer.toString(this.scene.getFeedbackSize()));
        this.cbSpinAnim.setState(this.scene.isAnimationEnabled());
        super.updateLocalComponents();
    }

    @Override
    public void setResources(Locale locale) {
        super.setResources(locale);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.setResources");
        }
        this.cbRotAxes.setLabel(resources.getString("PS_SHOW_ROT_AXES"));
        this.cbSpinAnim.setLabel(resources.getString("PS_ENABLE_SPIN_ANIM"));
        this.axesLabel.setText(resources.getString("PS_ROT_AXES_SIZE"));
        this.axesUnit.setText(resources.getString("PS_ROT_AXES_SIZE_UNIT"));
    }

    class ListenAxesText
    implements ActionListener {
        ListenAxesText() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (SwPanel.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.$ListenAxesText.actionPerformed");
            }
            int n2 = SwExaminerPreferences.this.scene.getFeedbackSize();
            try {
                n = Integer.valueOf(SwExaminerPreferences.this.axesText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = n2;
            }
            if (n > 0) {
                SwExaminerPreferences.this.scene.setFeedbackSize(n);
            } else {
                n = n2;
            }
            SwExaminerPreferences.this.axesText.setText(Integer.toString(n));
            SwExaminerPreferences.this.axesText.setCaretPosition(0);
            if (SwExaminerPreferences.this.scene.isViewing()) {
                SwExaminerPreferences.this.scene.scheduleRedraw();
            }
        }
    }

    class ListenAxesWheel
    implements SwWheelListener {
        boolean drag = false;

        ListenAxesWheel() {
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            if (SwPanel.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.$ListenAxesWheel.wheelChanged");
            }
            SwExaminerPreferences.this.scene.interactiveCountDec();
            this.drag = false;
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            if (SwPanel.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.$ListenAxesWheel.wheelDragged");
            }
            if (!this.drag) {
                SwExaminerPreferences.this.scene.interactiveCountInc();
                this.drag = true;
            }
            SwExaminerPreferences.this.scene.setFeedbackSize((int)((double)SwExaminerPreferences.this.scene.getFeedbackSize() * Math.pow(12.0, (double)(SwExaminerPreferences.this.axesWheel.getValue() - SwExaminerPreferences.this.feedbackSizeWheelVal) / 360.0)));
            SwExaminerPreferences.this.feedbackSizeWheelVal = SwExaminerPreferences.this.axesWheel.getValue();
            SwExaminerPreferences.this.axesText.setText(Integer.toString(SwExaminerPreferences.this.scene.getFeedbackSize()));
            SwExaminerPreferences.this.axesText.setCaretPosition(0);
            if (SwExaminerPreferences.this.scene.isViewing()) {
                SwExaminerPreferences.this.scene.scheduleRedraw();
            }
        }
    }

    class ListenRotAxesCheckbox
    implements ItemListener {
        ListenRotAxesCheckbox() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SwPanel.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.$ListenRotAxesCheckbox.itemStateChanged");
            }
            SwExaminerPreferences.this.scene.setFeedbackVisibility(SwExaminerPreferences.this.cbRotAxes.getState());
            SwExaminerPreferences.this.rotAxes.setEnabled(SwExaminerPreferences.this.cbRotAxes.getState());
            SwExaminerPreferences.this.axesWheel.setEnabled(SwExaminerPreferences.this.cbRotAxes.getState());
        }
    }

    class ListenSpinCheckbox
    implements ItemListener {
        ListenSpinCheckbox() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SwPanel.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.$ListenSpinCheckbox.itemStateChanged");
            }
            SwExaminerPreferences.this.scene.setAnimationEnabled(SwExaminerPreferences.this.cbSpinAnim.getState());
        }
    }

    class ExaminerPref
    extends Panel {
        public ExaminerPref() {
            super(new BorderLayout());
            if (SwPanel.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->SwExaminerPreferences.$ExaminerPref.ExaminerPref");
            }
            SwExaminerPreferences.this.cbSpinAnim = new Checkbox(SwPanel.resources.getString("PS_ENABLE_SPIN_ANIM"));
            SwExaminerPreferences.this.cbRotAxes = new Checkbox(SwPanel.resources.getString("PS_SHOW_ROT_AXES"));
            SwExaminerPreferences.this.cbSpinAnim.addItemListener(new ListenSpinCheckbox());
            SwExaminerPreferences.this.cbRotAxes.addItemListener(new ListenRotAxesCheckbox());
            SwExaminerPreferences.this.rotAxes = new Panel(new FlowLayout());
            SwExaminerPreferences.this.axesLabel = new Label(SwPanel.resources.getString("PS_ROT_AXES_SIZE"), 2);
            SwExaminerPreferences.this.axesUnit = new Label(SwPanel.resources.getString("PS_ROT_AXES_SIZE_UNIT"));
            SwExaminerPreferences.this.axesWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 360.0f, true);
            SwExaminerPreferences.this.axesText = new TextField(4);
            SwExaminerPreferences.this.axesWheel.addWheelListener(new ListenAxesWheel());
            SwExaminerPreferences.this.axesText.addActionListener(new ListenAxesText());
            SwExaminerPreferences.this.rotAxes.add(SwExaminerPreferences.this.axesLabel);
            SwExaminerPreferences.this.rotAxes.add(SwExaminerPreferences.this.axesWheel);
            SwExaminerPreferences.this.rotAxes.add(SwExaminerPreferences.this.axesUnit);
            SwExaminerPreferences.this.rotAxes.add(SwExaminerPreferences.this.axesText);
            Font font = new Font("Dialog", 1, 12);
            SwExaminerPreferences.this.cbRotAxes.setFont(font);
            SwExaminerPreferences.this.cbSpinAnim.setFont(font);
            SwExaminerPreferences.this.axesLabel.setFont(font);
            SwExaminerPreferences.this.axesUnit.setFont(font);
            this.add("South", SwExaminerPreferences.this.cbSpinAnim);
            this.add("East", SwExaminerPreferences.this.rotAxes);
            this.add("North", SwExaminerPreferences.this.cbRotAxes);
        }
    }
}

